/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.server.BrokerState;
import kafka.server.BrokerStates;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.RunningAsBroker$;
import kafka.server.ServerStartupTest;
import kafka.server.ServerStartupTest$MockKafkaServer$2$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9Q\u0002\u0001a\u0001\n\u0013a\u0002b\u0002\u0011\u0001\u0001\u0004%I!\t\u0005\u0007U\u0001\u0001\u000b\u0015B\u000f\t\u000b-\u0002A\u0011\t\u0017\t\u000bY\u0002A\u0011\u0001\u0017\t\u000bm\u0002A\u0011\u0001\u0017\t\u000bu\u0002A\u0011\u0001\u0017\t\u000b}\u0002A\u0011\u0001\u0017\t\u000b\u0005\u0003A\u0011\u0001\u0017\u0003#M+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u001d\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\r+\u0005i\u0002CA\u000e\u001f\u0013\tyBBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0004*\u0007\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\t\u0015\u0003\u000b9\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000b),h.\u001b;\u000b\u0003M\n1a\u001c:h\u0013\t)\u0004GA\u0003BMR,'/A\ruKN$(I]8lKJ\u001c%/Z1uKNT6j\u00115s_>$\bF\u0001\u00049!\ty\u0013(\u0003\u0002;a\t!A+Z:u\u0003\u0015\"Xm\u001d;D_:4G.[2u\u0005J|7.\u001a:Ti\u0006\u0014H/\u001e9XSRD7+Y7f!>\u0014H\u000f\u000b\u0002\bq\u0005qB/Z:u\u0007>tg\r\\5di\n\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0015\u0003\u0011a\n1\u0003^3ti\n\u0013xn[3s'\u0016dg-Q<be\u0016D#!\u0003\u001d\u0002;Q,7\u000f\u001e\"s_.,'o\u0015;bi\u0016\u0014VO\u001c8j]\u001e\fe\r^3s5.C#A\u0003\u001d")
public class ServerStartupTest
extends ZooKeeperTestHarness {
    private KafkaServer server = null;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @After
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$));
        }
        super.tearDown();
    }

    @Test
    public void testBrokerCreatesZKChroot() {
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", new StringBuilder(0).append(zooKeeperConnect.toString()).append(zookeeperChroot).toString());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(zookeeperChroot));
    }

    @Test
    public void testConflictBrokerStartupWithSamePort() {
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        int port = TestUtils$.MODULE$.boundPort(this.server(), TestUtils$.MODULE$.boundPort$default$2());
        int brokerId2 = 1;
        String x$2 = this.zkConnect();
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId2, x$2, x$4, x$5, port, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2());
            Assert.fail((String)"Starting a broker with the same port should fail");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConflictBrokerRegistration() {
        Object object;
        Object object2;
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        Option option = this.zkClient().getBroker(brokerId);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ServerStartupTest.$anonfun$testConflictBrokerRegistration$1();
            object2 = BoxedUnit.UNIT;
        } else {
            object2 = getOrElse_this.get();
        }
        Object brokerRegistration = object2;
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2());
            Assert.fail((String)"Registering a broker with a conflicting id should fail");
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        Option option2 = this.zkClient().getBroker(brokerId);
        if (option2 == null) {
            throw null;
        }
        Option getOrElse_this2 = option2;
        if (getOrElse_this2.isEmpty()) {
            ServerStartupTest.$anonfun$testConflictBrokerRegistration$2();
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this2.get();
        }
        Assert.assertEquals((Object)brokerRegistration, (Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSelfAware() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerSelfAware$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ServerStartupTest.$anonfun$testBrokerSelfAware$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)1L, (long)this.server().metadataCache().getAliveBrokers().size());
        Assert.assertEquals((long)brokerId, (long)((Broker)this.server().metadataCache().getAliveBrokers().head()).id());
    }

    @Test
    public void testBrokerStateRunningAfterZK() {
        LazyRef MockKafkaServer$module = new LazyRef();
        int brokerId = 0;
        BrokerState mockBrokerState = (BrokerState)EasyMock.niceMock(BrokerState.class);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        public class Kafka_server_ServerStartupTest$MockKafkaServer$1
        extends KafkaServer {
            private final BrokerState brokerState;

            public KafkaConfig config() {
                return super.config();
            }

            public BrokerState brokerState() {
                return this.brokerState;
            }

            public Kafka_server_ServerStartupTest$MockKafkaServer$1(ServerStartupTest $outer, KafkaConfig config, BrokerState brokerState) {
                this.brokerState = brokerState;
                super(config, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
            }
        }
        this.server_$eq(new Kafka_server_ServerStartupTest$MockKafkaServer$1(null, KafkaConfig$.MODULE$.fromProps(props), this.MockKafkaServer$3(MockKafkaServer$module, mockBrokerState).$lessinit$greater$default$2()));
        mockBrokerState.newState((BrokerStates)RunningAsBroker$.MODULE$);
        public class Kafka_server_ServerStartupTest$BrokerStateInterceptor$1
        extends BrokerState {
            private final /* synthetic */ ServerStartupTest $outer;
            private final int brokerId$1;

            public void newState(BrokerStates newState) {
                Seq brokers = this.$outer.zkClient().getAllBrokersInCluster();
                Assert.assertEquals((long)1L, (long)brokers.size());
                Assert.assertEquals((long)this.brokerId$1, (long)((Broker)brokers.head()).id());
            }

            public Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(ServerStartupTest $outer, int brokerId$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
            }
        }
        EasyMock.expect((Object)BoxedUnit.UNIT).andDelegateTo((Object)new Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(this, brokerId)).once();
        EasyMock.replay((Object[])new Object[]{mockBrokerState});
        this.server().startup();
    }

    public static final /* synthetic */ void $anonfun$testConflictBrokerRegistration$1() {
        Assert.fail((String)"broker doesn't exists");
    }

    public static final /* synthetic */ void $anonfun$testConflictBrokerRegistration$2() {
        Assert.fail((String)"broker doesn't exists");
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerSelfAware$1(ServerStartupTest $this) {
        return $this.server().metadataCache().getAliveBrokers().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testBrokerSelfAware$2() {
        return "Wait for cache to update";
    }

    private static final /* synthetic */ ServerStartupTest$MockKafkaServer$2$ MockKafkaServer$lzycompute$1(LazyRef MockKafkaServer$module$1, BrokerState mockBrokerState$1) {
        synchronized (MockKafkaServer$module$1) {
            ServerStartupTest$MockKafkaServer$2$ serverStartupTest$MockKafkaServer$2$ = MockKafkaServer$module$1.initialized() ? (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.value() : (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.initialize((Object)new ServerStartupTest$MockKafkaServer$2$(null, mockBrokerState$1));
            return serverStartupTest$MockKafkaServer$2$;
        }
    }

    private final ServerStartupTest$MockKafkaServer$2$ MockKafkaServer$3(LazyRef MockKafkaServer$module$1, BrokerState mockBrokerState$1) {
        if (MockKafkaServer$module$1.initialized()) {
            return (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.value();
        }
        return ServerStartupTest.MockKafkaServer$lzycompute$1(MockKafkaServer$module$1, mockBrokerState$1);
    }
}

