/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kafka.server.LinuxIoMetricsCollector;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001D\u0007\u0001%!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I\u0019!A\u0007\u0001\u00016\u0011\u0015y2\u0001\"\u00017\u0011\u001dI4A1A\u0005\u0002iBaaQ\u0002!\u0002\u0013Y\u0004b\u0002#\u0004\u0005\u0004%\t!\u0012\u0005\u0007\u001d\u000e\u0001\u000b\u0011\u0002$\t\u000b=\u001bA\u0011\u0001)\t\u000ba\u0003A\u0011A-\t\u000b\u0005\u0004A\u0011A-\u000371Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\b\u0002\u000bU$\u0018\u000e\\:\n\u0005yY\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u00035\tQb\u001a7pE\u0006dG+[7f_V$X#A\u0013\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013!\u0002:vY\u0016\u001c(B\u0001\u0016,\u0003\u0015QWO\\5u\u0015\u0005a\u0013aA8sO&\u0011af\n\u0002\b)&lWm\\;uQ\t\u0011\u0001\u0007\u0005\u00022e5\t\u0011&\u0003\u00024S\t!!+\u001e7f\u00055!Vm\u001d;ESJ,7\r^8ssN\u00111a\u0005\u000b\u0002oA\u0011\u0001hA\u0007\u0002\u0001\u00059!-Y:f\t&\u0014X#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014AA5p\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\t\u0019KG.Z\u0001\tE\u0006\u001cX\rR5sA\u000591/\u001a7g\t&\u0014X#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00024jY\u0016T!aS \u0002\u00079Lw.\u0003\u0002N\u0011\n!\u0001+\u0019;i\u0003!\u0019X\r\u001c4ESJ\u0004\u0013!D<sSR,\u0007K]8d\r&dW\rF\u0002G#ZCQAU\u0005A\u0002M\u000b\u0011B]3bI\nKH/Z:\u0011\u0005Q!\u0016BA+\u0016\u0005\u0011auN\\4\t\u000b]K\u0001\u0019A*\u0002\u0015]\u0014\u0018\u000e^3CsR,7/\u0001\tuKN$(+Z1e!J|7MR5mKR\t!\f\u0005\u0002\u00157&\u0011A,\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u000b=B\u0011\u0011gX\u0005\u0003A&\u0012A\u0001V3ti\u0006\u0019C/Z:u+:\f'\r\\3U_J+\u0017\r\u001a(p]\u0016D\u0018n\u001d;f]R\u0004&o\\2GS2,\u0007FA\u0006_\u0001")
public class LinuxIoMetricsCollectorTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Test
    public void testReadProcFile() {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(100L, 1000L);
        testDirectory.writeProcFile(123L, 456L);
        LinuxIoMetricsCollector collector = new LinuxIoMetricsCollector(testDirectory.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying());
        Assert.assertTrue((boolean)collector.usable());
        Assert.assertEquals((long)123L, (long)collector.readBytes());
        Assert.assertEquals((long)456L, (long)collector.writeBytes());
        testDirectory.writeProcFile(124L, 457L);
        Assert.assertEquals((long)123L, (long)collector.readBytes());
        Assert.assertEquals((long)456L, (long)collector.writeBytes());
        time.sleep(1L);
        Assert.assertEquals((long)124L, (long)collector.readBytes());
        Assert.assertEquals((long)457L, (long)collector.writeBytes());
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(100L, 1000L);
        Assert.assertFalse((boolean)new LinuxIoMetricsCollector(testDirectory.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying()).usable());
    }

    public LinuxIoMetricsCollectorTest() {
        Logging.$init$((Logging)this);
    }

    public class TestDirectory {
        private final File baseDir;
        private final Path selfDir;

        public File baseDir() {
            return this.baseDir;
        }

        public Path selfDir() {
            return this.selfDir;
        }

        /*
         * WARNING - void declaration
         */
        public Path writeProcFile(long readBytes, long writeBytes) {
            void augmentString_x;
            void augmentString_x2;
            void augmentString_x3;
            void augmentString_x4;
            void augmentString_x5;
            void augmentString_x6;
            void augmentString_x7;
            StringBuilder bld = new StringBuilder();
            String string = "rchar: 0%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x7).format((Seq)Nil$.MODULE$));
            String string2 = "wchar: 0%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x6).format((Seq)Nil$.MODULE$));
            String string3 = "syschr: 0%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x5).format((Seq)Nil$.MODULE$));
            String string4 = "syscw: 0%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x4).format((Seq)Nil$.MODULE$));
            String string5 = "read_bytes: %d%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)readBytes)})));
            String string6 = "write_bytes: %d%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)writeBytes)})));
            String string7 = "cancelled_write_bytes: 0%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bld.append(new StringOps((String)augmentString_x).format((Seq)Nil$.MODULE$));
            return Files.write(this.selfDir().resolve("io"), bld.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        public /* synthetic */ LinuxIoMetricsCollectorTest kafka$server$LinuxIoMetricsCollectorTest$TestDirectory$$$outer() {
            return LinuxIoMetricsCollectorTest.this;
        }

        public TestDirectory() {
            if (LinuxIoMetricsCollectorTest.this == null) {
                throw null;
            }
            this.baseDir = TestUtils.tempDirectory();
            this.selfDir = Files.createDirectories(this.baseDir().toPath().resolve("self"), new FileAttribute[0]);
        }
    }
}

