/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001\u0002\u001f>\u0001\tCQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004^\u0001\u0001\u0006I!\u0016\u0005\b=\u0002\u0011\r\u0011\"\u0001U\u0011\u0019y\u0006\u0001)A\u0005+\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007BB7\u0001A\u0003%!\rC\u0004o\u0001\t\u0007I\u0011A8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\u0002aDa\u0001 \u0001!\u0002\u0013I\bbB?\u0001\u0005\u0004%\tA \u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u0000\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0006\r\u0019\t\u0019\u0003\u0001\u0001\u0002&!a\u0011Q\u0006\t\u0003\u0002\u0003\u0006I!a\f\u0002H!a\u0011\u0011\n\t\u0003\u0002\u0003\u0006I!a\u0013\u0002X!a\u0011\u0011\f\t\u0003\u0002\u0003\u0006I!a\u0017\u0002h!1q\n\u0005C\u0001\u0003SBq!!\u001e\u0011\t\u0003\n9\bC\u0004\u0002\bB!\t%!#\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAh\u0001\u0011\u0005\u0011q\u0015\u0005\b\u00033\u0004A\u0011AAT\u0011\u001d\ti\u000e\u0001C\u0001\u0003OCq!!9\u0001\t\u0003\t9\u000bC\u0004\u0002f\u0002!\t!a*\t\u000f\u0005%\b\u0001\"\u0001\u0002(\"9\u0011Q\u001e\u0001\u0005\u0002\u0005\u001d\u0006bBAy\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003k\u0004A\u0011AAT\u0011\u001d\tI\u0010\u0001C\u0001\u0003OCq!!@\u0001\t\u0003\t9\u000bC\u0004\u0003\u0002\u0001!\t!a*\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002(\"9!\u0011\u0002\u0001\u0005\u0002\u0005\u001d\u0006b\u0002B\u0007\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0005#\u0001A\u0011AAT\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003OCqA!\u0007\u0001\t\u0003\t9\u000bC\u0004\u0003\u001e\u0001!\t!a*\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002(\"9!Q\u0005\u0001\u0005\u0002\u0005\u001d\u0006b\u0002B\u0015\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0005[\u0001A\u0011AAT\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0003OCqA!\u000e\u0001\t\u0003\t9\u000bC\u0004\u0003:\u0001!IAa\u000f\t\u000f\t}\u0002\u0001\"\u0003\u0003B!9!q\t\u0001\u0005\n\t%\u0003\"\u0003B.\u0001E\u0005I\u0011\u0002B/\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005kBqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u000e\u0002!IAa$\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\"I!1\u0015\u0001\u0012\u0002\u0013%!Q\u0015\u0005\b\u0005S\u0003A\u0011\u0002BV\u0005UaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d+fgRT!AP \u0002\u00071|wMC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fMB\u0011!*T\u0007\u0002\u0017*\u0011AjP\u0001\u0006kRLGn]\u0005\u0003\u001d.\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002#B\u0011!\u000bA\u0007\u0002{\u00051A/\u001c9ESJ,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000b!![8\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001c!\t\u00197.D\u0001e\u0015\t)g-\u0001\u0004d_6lwN\u001c\u0006\u0003\u0001\u001eT!\u0001[5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0017aA8sO&\u0011A\u000e\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]-\u0002\tU$\u0018\u000e\\\u0005\u0003kJ\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\t\u0011\u0010\u0005\u0002Su&\u001110\u0010\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0003}\u00042ASA\u0001\u0013\r\t\u0019a\u0013\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005\u00112\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\tY\u0001E\u0004\u0002\u000e\u0005]!-a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\tq!\\;uC\ndWMC\u0002\u0002\u0016\u0015\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI\"a\u0004\u0003\u00075\u000b\u0007\u000fE\u0002E\u0003;I1!a\bF\u0005\u0011auN\\4\u0002'\rdW-\u00198fe\u000eCWmY6q_&tGo\u001d\u0011\u0003+1{wm\u00117fC:,'/T1oC\u001e,'/T8dWN\u0019\u0001#a\n\u0011\u0007I\u000bI#C\u0002\u0002,u\u0012\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0003\u001dawn\u001a#jeN\u0004R!!\r\u0002BUsA!a\r\u0002>9!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0005\u000ba\u0001\u0010:p_Rt\u0014\"\u0001$\n\u0007\u0005}R)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0013Q\t\u0002\u0004'\u0016\f(bAA \u000b&!\u0011QFA\u0015\u0003\u0011awnZ:\u0011\r)\u000biEYA)\u0013\r\tye\u0013\u0002\u0005!>|G\u000eE\u0002S\u0003'J1!!\u0016>\u0005\raunZ\u0005\u0005\u0003\u0013\nI#\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M \u0002\rM,'O^3s\u0013\u0011\t)'a\u0018\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0013\u0011\tI&!\u000b\u0015\u0011\u0005-\u0014qNA9\u0003g\u00022!!\u001c\u0011\u001b\u0005\u0001\u0001bBA\u0017)\u0001\u0007\u0011q\u0006\u0005\b\u0003\u0013\"\u0002\u0019AA&\u0011\u001d\tI\u0006\u0006a\u0001\u00037\nQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002zA9\u00111PABE\u0006ma\u0002BA?\u0003\u007f\u00022!!\u000eF\u0013\r\t\t)R\u0001\u0007!J,G-\u001a4\n\t\u0005e\u0011Q\u0011\u0006\u0004\u0003\u0003+\u0015!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR1\u00111RAI\u0003+\u00032\u0001RAG\u0013\r\ty)\u0012\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0014Z\u0001\r!V\u0001\bI\u0006$\u0018\rR5s\u0011\u001d\t9J\u0006a\u0001\u00033\u000ba!\u001e9eCR,\u0007#\u0002#\u0002\u001c\u0006}\u0015bAAO\u000b\n1q\n\u001d;j_:\u0004b\u0001RAQE\u0006m\u0011bAAR\u000b\n1A+\u001e9mKJ\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u0017C3aFAV!\u0011\ti+a-\u000e\u0005\u0005=&bAAYS\u0006)!.\u001e8ji&!\u0011QWAX\u0005\u0015\te\r^3s\u0003m\u0019X\r^;q\u0013:\u001c'/Z1tS:<G.\u001f$jYRD\u0017\u0010T8hgRA\u00111JA^\u0003\u0003\fY\rC\u0004\u0002>b\u0001\r!a0\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003\u00022\u0005\u0005#\rC\u0004\u0002Db\u0001\r!!2\u0002\u001fM$\u0018M\u001d;Ok6\u0014\u0015\r^2iKN\u00042\u0001RAd\u0013\r\tI-\u0012\u0002\u0004\u0013:$\bbBAg1\u0001\u0007\u0011QY\u0001\u000fE\u0006$8\r[%oGJ,W.\u001a8u\u00031\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><G\u000b\u001b:poN,\u0005pY3qi&|g\u000eK\u0002\u001a\u0003'\u0004B!!,\u0002V&!\u0011q[AX\u0005\u0011!Vm\u001d;\u0002qQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e\u0014V\r^;s]NdunZ,ji\"$\u0015N\u001d;jKN$(+\u0019;j_\"\u001a!$a5\u0002sQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3aGAj\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]ND3\u0001HAj\u0003Q#Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c(i\u001c;i\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:B]\u0012,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3!HAj\u0003%\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&3G*\u0019:hKJ$\u0006.\u00198F]\u0012|eMZ:fi\"\u001aa$a5\u0002YQ,7\u000f\u001e#jeRLxJ\u001a4tKR\u0014Vm]3u\u0013\u001a\u001cV.\u00197mKJ$\u0006.\u00198Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\u0010\u0002T\u0006\u0019D/Z:u\u0019><7\u000b^1si>3gm]3u\u0019\u0006\u0014x-\u001a:UQ\u0006t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0004A\u0005M\u0017\u0001\r;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;MCJ<WM\u001d+iC:\f5\r^5wKN+w-\\3oi\n\u000b7/Z(gMN,G\u000fK\u0002\"\u0003'\fA\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=EK2,G/\u001a'pOND3AIAj\u0003!#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di\u0012+G.\u001a;f\u0019><7\u000fK\u0002$\u0003'\f!\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$7i\u001c8tS\u0012,'o\u00117fC:,\b\u000fU8mS\u000eL8i\\7qC\u000e$Hj\\4tQ\r!\u00131[\u0001,i\u0016\u001cH\u000fT8hgVsG-\u001a:DY\u0016\fg.\u001e9J]\u0016d\u0017nZ5cY\u00164uN]\"p[B\f7\r^5p]\"\u001aQ%a5\u0002QQ,7\u000f^\"p]\u000e,(O]3oi2{wm\u00117fC:,\b/\u00118e\u0019><GK];oG\u0006$\u0018n\u001c8)\u0007\u0019\n\u0019.\u0001\u0015uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u001e\u001cE.Z1okB\fe\u000e\u001a+pa&\u001cG)\u001a7fi&|g\u000eK\u0002(\u0003'\f!\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rA\u00131[\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_JtuN\\3)\u0007%\n\u0019.A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peRKW.\u001a\u0015\u0004U\u0005M\u0017\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D3aKAj\u0003!\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug:+W\rZ:DQ\u0016\u001c7\u000e]8j]R\u0014Vm]3uQ\ra\u00131[\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\ri\u00131[\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3ALAj\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u00020\u0003'\fq\u0006^3ti\u000eCWmY6q_&tG/\u00169eCR,GMR8s\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;O_\u000ecW-\u00198j]\u001eD3\u0001MAj\u0003A\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8u'\u0016dWm\u0019;fI\"\u001a\u0011'a5\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0011\t9C!\u0010\t\ry\u0012\u0004\u0019AA)\u0003a\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4fe6{7m\u001b\u000b\u0005\u0003W\u0012\u0019\u0005C\u0004\u0003FM\u0002\r!a\u0013\u0002\tA|w\u000e\\\u0001\nGJ,\u0017\r^3M_\u001e$\u0002\"!\u0015\u0003L\t=#\u0011\f\u0005\b\u0005\u001b\"\u0004\u0019AAc\u0003-\u0019XmZ7f]R\u001c\u0016N_3\t\u000f\tEC\u00071\u0001\u0003T\u0005i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a\u001f\u0003V%!!qKAC\u0005\u0019\u0019FO]5oO\"9\u0001\r\u000eI\u0001\u0002\u0004\u0011\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001B0U\r\u0011'\u0011M\u0016\u0003\u0005G\u0002BA!\u001a\u0003p5\u0011!q\r\u0006\u0005\u0005S\u0012Y'A\u0005v]\u000eDWmY6fI*\u0019!QN#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003r\t\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y2M]3bi\u0016dun\u001e*fi\u0016tG/[8o\u0019><7i\u001c8gS\u001e$R!\u001fB<\u0005sBqA!\u00147\u0001\u0004\t)\rC\u0004\u0003RY\u0002\rAa\u0015\u0002\u0019]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:\u0015\u0015\u0005-%q\u0010BA\u0005\u000b\u0013I\t\u0003\u0004?o\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005\u0007;\u0004\u0019AAc\u0003)qW/\u001c\"bi\u000eDWm\u001d\u0005\b\u0005\u000f;\u0004\u0019AAc\u0003=\u0011XmY8sIN\u0004VM\u001d\"bi\u000eD\u0007b\u0002BFo\u0001\u0007\u0011QY\u0001\u0012E\u0006$8\r[3t!\u0016\u00148+Z4nK:$\u0018!D1qa\u0016tGMU3d_J$7\u000f\u0006\u0004\u0002\f\nE%1\u0013\u0005\u0007}a\u0002\r!!\u0015\t\u000f\tU\u0005\b1\u0001\u0002F\u0006Qa.^7SK\u000e|'\u000fZ:\u0002\u000f5\f7.\u001a'pOR1\u0011\u0011\u000bBN\u0005?C\u0001B!(:!\u0003\u0005\r!V\u0001\u0004I&\u0014\bB\u0002BQs\u0001\u0007\u00110\u0001\u0004d_:4\u0017nZ\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\nTC\u0001BTU\r)&\u0011M\u0001\be\u0016\u001cwN\u001d3t)!\u0011iK!/\u0003>\n\u0005\u0007\u0003\u0002BX\u0005kk!A!-\u000b\u0007\tMF-\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005o\u0013\tLA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005w[\u0004\u0019AAc\u0003\rYW-\u001f\u0005\b\u0005\u007f[\u0004\u0019AAc\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011\u0019m\u000fa\u0001\u00037\t\u0011\u0002^5nKN$\u0018-\u001c9")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, Log> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends Log {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, File dir, LogConfig config, TopicPartition tp$1, File tpDir$1) {
                super(dir, config, 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), $outer.topicPartition(), new ProducerStateManager(tp$1, tpDir$1, 3600000), new LogDirFailureChannel(10));
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(this, tpDir, this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact()), tp, tpDir);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get(), ClassTag$.MODULE$.apply(LogCleaningException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        Assert.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assert.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        Assert.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> (TopicPartition)x$4._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertFalse((String)"Checkpoint offset should not be reset if valid", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if less than log start offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if greater than log end offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"Log should not be selected for cleaning", (Object)None$.MODULE$, (Object)filthiestLog);
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp).get()));
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((Log)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((String)"Dirtier log should be selected", (Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp0).get()));
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, Log> pool) {
        return new LogCleanerManagerMock((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private Log createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(partitionDir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    /*
     * WARNING - void declaration
     */
    private void writeRecords(Log log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, numBatches);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.roll(log.roll$default$1());
    }

    private void appendRecords(Log log, int numRecords) {
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)new RichLong(startOffset).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private Log makeLog(File dir, LogConfig config) {
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(dir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        Log log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1$adapted(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, Object i) {
        return LogCleanerManagerTest.$anonfun$writeRecords$1($this, log$2, recordsPerBatch$1, batchesPerSegment$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
            void var4_4;
            if (update == null) {
                throw null;
            }
            if (update.isEmpty()) {
                throw LogCleanerManagerMock.$anonfun$updateCheckpoints$1();
            }
            Tuple2 tuple2 = (Tuple2)update.get();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var4_4, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public static final /* synthetic */ Nothing$ $anonfun$updateCheckpoints$1() {
            throw new IllegalArgumentException("update=None argument not yet handled");
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

