/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0006\r\u0001EA\u0001B\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t5\u0001\u0011\t\u0011)A\u00057!)\u0011\u0005\u0001C\u0001E!9a\u0005\u0001a\u0001\n\u00039\u0003b\u0002\u001c\u0001\u0001\u0004%\ta\u000e\u0005\u0007{\u0001\u0001\u000b\u0015\u0002\u0015\t\u000by\u0002A\u0011A \t\u000b\t\u0003A\u0011A\"\t\u000b\u0011\u0003A\u0011I#\t\u000bq\u0004A\u0011B?\u000335{7m\u001b)beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0006\u0003\u001b9\t!bY8oiJ|G\u000e\\3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u00031I!!\u0006\u0007\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005MA\u0012BA\r\r\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u001dk:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3e!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA\u0012%KA\u00111\u0003\u0001\u0005\u0006-\r\u0001\ra\u0006\u0005\u00065\r\u0001\raG\u0001\u001agR\fG/Z\"iC:<Wm\u001d\"z)\u0006\u0014x-\u001a;Ti\u0006$X-F\u0001)!\u0011Ic\u0006M\u001a\u000e\u0003)R!a\u000b\u0017\u0002\u000f5,H/\u00192mK*\u0011Q&H\u0001\u000bG>dG.Z2uS>t\u0017BA\u0018+\u0005\ri\u0015\r\u001d\t\u0003'EJ!A\r\u0007\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uKB\u0011A\u0004N\u0005\u0003ku\u00111!\u00138u\u0003u\u0019H/\u0019;f\u0007\"\fgnZ3t\u0005f$\u0016M]4fiN#\u0018\r^3`I\u0015\fHC\u0001\u001d<!\ta\u0012(\u0003\u0002;;\t!QK\\5u\u0011\u001daT!!AA\u0002!\n1\u0001\u001f\u00132\u0003i\u0019H/\u0019;f\u0007\"\fgnZ3t\u0005f$\u0016M]4fiN#\u0018\r^3!\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3t\u0007\u0006dGn\u001d\u000b\u0003g\u0001CQ!Q\u0004A\u0002A\n1\u0002^1sO\u0016$8\u000b^1uK\u0006)1\r\\3beR\t\u0001(\u0001\niC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0003\u0002$ngR\u0004Ba\u0012(Q7:\u0011\u0001\n\u0014\t\u0003\u0013vi\u0011A\u0013\u0006\u0003\u0017B\ta\u0001\u0010:p_Rt\u0014BA'\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011qf\u0014\u0006\u0003\u001bv\u0001\"!U-\u000e\u0003IS!a\u0015+\u0002\r\r|W.\\8o\u0015\tyQK\u0003\u0002W/\u00061\u0011\r]1dQ\u0016T\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.S\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B\u0001X1eO:\u0011Ql\u0018\b\u0003\u0013zK\u0011AH\u0005\u0003Av\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n1Q)\u001b;iKJT!\u0001Y\u000f\u0011\u0005q+\u0017B\u00014d\u0005%!\u0006N]8xC\ndW\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001d\u0005\u0019\u0011\r]5\n\u00051L'\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\b\"\u00028\n\u0001\u0004y\u0017A\u00039beRLG/[8ogB\u0019\u0001/\u001d)\u000e\u00031J!A\u001d\u0017\u0003\u0007M+\u0017\u000fC\u0003B\u0013\u0001\u0007\u0001\u0007C\u0003v\u0013\u0001\u0007a/\u0001\fmK\u0006$WM]#mK\u000e$\u0018n\u001c8TiJ\fG/Z4z!\rar/_\u0005\u0003qv\u0011aa\u00149uS>t\u0007CA\n{\u0013\tYHBA\u0010QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]N#(/\u0019;fOf\f\u0011\u0003Z8MK\u0006$WM]#mK\u000e$\u0018n\u001c8t)\r1ep \u0005\u0006]*\u0001\ra\u001c\u0005\u0006k*\u0001\r!\u001f")
public class MockPartitionStateMachine
extends PartitionStateMachine {
    private final ControllerContext controllerContext;
    private final boolean uncleanLeaderElectionEnabled;
    private Map<PartitionState, Object> stateChangesByTargetState;

    public Map<PartitionState, Object> stateChangesByTargetState() {
        return this.stateChangesByTargetState;
    }

    public void stateChangesByTargetState_$eq(Map<PartitionState, Object> x$1) {
        this.stateChangesByTargetState = x$1;
    }

    public int stateChangesCalls(PartitionState targetState) {
        return BoxesRunTime.unboxToInt((Object)this.stateChangesByTargetState().apply((Object)targetState));
    }

    public void clear() {
        this.stateChangesByTargetState().clear();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> leaderElectionStrategy) {
        void var6_6;
        void var5_5;
        this.stateChangesByTargetState().update((Object)targetState, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.stateChangesByTargetState().apply((Object)targetState)) + 1)));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, (PartitionState)NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        void validPartitions2 = var5_5;
        void invalidPartitions2 = var6_6;
        if (invalidPartitions2.nonEmpty()) {
            Seq currentStates = (Seq)invalidPartitions2.map((Function1 & Serializable & scala.Serializable)p -> $this.controllerContext.partitionStates().get(p), Seq$.MODULE$.canBuildFrom());
            throw new IllegalStateException(new StringBuilder(44).append("Invalid state transition to ").append(targetState).append(" for partitions ").append(currentStates).toString());
        }
        PartitionState partitionState = targetState;
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (!(partitionState != null ? !partitionState.equals(onlinePartition$) : onlinePartition$ != null)) {
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$3(this, partition)));
            Seq partitionsToElectLeader = (Seq)partitions.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$4(this, partition)));
            uninitializedPartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.doLeaderElections((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)leaderElectionStrategy.get());
            electionResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MockPartitionStateMachine.$anonfun$handleStateChanges$6(this, targetState, x0$1);
                return BoxedUnit.UNIT;
            });
            return electionResults;
        }
        validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionState(partition, targetState);
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doLeaderElections(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy leaderElectionStrategy) {
        Seq seq;
        Map failedElections = Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply(partition);
            if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                String failMsg = new StringBuilder(233).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append("already written by another controller. This probably means that the current controller went through ").append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString();
                return failedElections.put(partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
            }
            validLeaderAndIsrs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr())}));
            return BoxedUnit.UNIT;
        });
        if (leaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean isUnclean = ((OfflinePartitionLeaderElectionStrategy)leaderElectionStrategy).allowUnclean();
            Buffer partitionsWithUncleanLeaderElectionState = (Buffer)validLeaderAndIsrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition partition = (TopicPartition)x0$1._1();
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
                    return new Tuple3((Object)partition, (Object)new Some((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((isUnclean || $this.uncleanLeaderElectionEnabled ? 1 : 0) != 0));
                }
                throw new MatchError(null);
            }, Buffer$.MODULE$.canBuildFrom());
            seq = Election$.MODULE$.leaderForOffline(this.controllerContext, (Seq)partitionsWithUncleanLeaderElectionState);
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else {
            throw new MatchError((Object)leaderElectionStrategy);
        }
        return ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)electionResult -> {
            void $minus$greater$extension_$this;
            Left left;
            TopicPartition partition = electionResult.topicPartition();
            Option option = electionResult.leaderAndIsr();
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(leaderElectionStrategy).toString();
                left = package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg));
            } else if (option instanceof Some) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)option).value();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                left = package$.MODULE$.Right().apply((Object)leaderAndIsr);
            } else {
                throw new MatchError((Object)option);
            }
            Left value = left;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)value);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedElections);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$3(MockPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.controllerContext.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$4(MockPartitionStateMachine $this, TopicPartition partition) {
        block3: {
            block2: {
                PartitionState currentState;
                PartitionState partitionState = currentState = $this.controllerContext.partitionState(partition);
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (!(partitionState == null ? offlinePartition$ != null : !partitionState.equals(offlinePartition$))) break block2;
                PartitionState partitionState2 = currentState;
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                if (partitionState2 != null ? !partitionState2.equals(onlinePartition$) : onlinePartition$ != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$6(MockPartitionStateMachine $this, PartitionState targetState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            if ((Either)x0$1._2() instanceof Right) {
                $this.controllerContext.putPartitionState(partition, targetState$1);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Left) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public MockPartitionStateMachine(ControllerContext controllerContext, boolean uncleanLeaderElectionEnabled) {
        this.controllerContext = controllerContext;
        this.uncleanLeaderElectionEnabled = uncleanLeaderElectionEnabled;
        super(controllerContext);
        this.stateChangesByTargetState = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
    }
}

