/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0016-\u0001EBQA\u0011\u0001\u0005\u0002\rC\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002$\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C0\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0011%\u0001\u0007\u00011AA\u0002\u0013%\u0011\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019Q\b\u0001)A\u0005a\")1\u0010\u0001C\u0001_\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\b\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u00033\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u000bAq!a\n\u0001\t\u0003\t)\u0001C\u0004\u0002,\u0001!\t!!\u0002\t\u000f\u0005=\u0002\u0001\"\u0001\u0002\u0006!9\u00111\u0007\u0001\u0005\u0002\u0005\u0015\u0001bBA\u001c\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003w\u0001A\u0011AA\u0003\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u000bAq!a\u0011\u0001\t\u0003\t)\u0001C\u0004\u0002H\u0001!\t!!\u0002\t\u000f\u0005-\u0003\u0001\"\u0001\u0002\u0006!9\u0011q\n\u0001\u0005\u0002\u0005\u0015\u0001bBA*\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003/\u0002A\u0011AA\u0003\u0011\u001d\tY\u0006\u0001C\u0001\u0003\u000bAq!a\u0018\u0001\t\u0003\t)\u0001C\u0004\u0002d\u0001!\t!!\u0002\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002\u0006!9\u00111\u000e\u0001\u0005\u0002\u0005\u0015\u0001bBA8\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003g\u0002A\u0011AA\u0003\u0011\u001d\t9\b\u0001C\u0001\u0003\u000bAq!a\u001f\u0001\t\u0003\t)\u0001C\u0004\u0002\u0000\u0001!\t!!\u0002\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006!9\u0011q\u0011\u0001\u0005\u0002\u0005\u0015\u0001bBAF\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0003A\u0011AA\u0003\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u0013A\u0004V8qS\u000e\u001cu.\\7b]\u0012<\u0016\u000e\u001e5[\u0017\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002.]\u0005)\u0011\rZ7j]*\tq&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0011\u0004H\u0010\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k9\n!A_6\n\u0005]\"$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002:y5\t!H\u0003\u0002<]\u0005)Q\u000f^5mg&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h!\ty\u0004)D\u0001-\u0013\t\tEFA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"a\u0010\u0001\u0002\u0019Q|\u0007/[2TKJ4\u0018nY3\u0016\u0003\u001d\u0003\"\u0001\u0013*\u000f\u0005%\u0003fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti\u0005'\u0001\u0004=e>|GOP\u0005\u0002_%\u0011QFL\u0005\u0003#2\nA\u0002V8qS\u000e\u001cu.\\7b]\u0012L!a\u0015+\u0003+i{wn[3fa\u0016\u0014Hk\u001c9jGN+'O^5dK*\u0011\u0011\u000bL\u0001\u0011i>\u0004\u0018nY*feZL7-Z0%KF$\"aV/\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\tUs\u0017\u000e\u001e\u0005\b=\u000e\t\t\u00111\u0001H\u0003\rAH%M\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\u0002\u001bQ,7\u000f\u001e+pa&\u001cg*Y7f+\u0005\u0011\u0007CA2h\u001d\t!W\r\u0005\u0002L3&\u0011a-W\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g3\u0006\tB/Z:u)>\u0004\u0018n\u0019(b[\u0016|F%Z9\u0015\u0005]c\u0007b\u00020\u0007\u0003\u0003\u0005\rAY\u0001\u000fi\u0016\u001cH\u000fV8qS\u000et\u0015-\\3!\u0003%yF/Z:u\u001d\u0006lW-F\u0001q!\t\t\b0D\u0001s\u0015\t\u0019H/A\u0003sk2,7O\u0003\u0002vm\u0006)!.\u001e8ji*\tq/A\u0002pe\u001eL!!\u001f:\u0003\u0011Q+7\u000f\u001e(b[\u0016\f!b\u0018;fgRt\u0015-\\3!\u0003!!Xm\u001d;OC6,\u0007F\u0001\u0006~!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\u0005%VdW-A\u0003tKR,\b\u000fF\u0001XQ\rY\u0011\u0011\u0002\t\u0004}\u0006-\u0011bAA\u0007i\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u0019\u0005M\u0001c\u0001@\u0002\u0016%\u0019\u0011q\u0003;\u0003\u000b\u00053G/\u001a:\u0002\u0015Q,7\u000f^\"sK\u0006$X\rK\u0002\u000e\u0003;\u00012A`A\u0010\u0013\r\t\t\u0003\u001e\u0002\u0005)\u0016\u001cH/A\u000buKN$8I]3bi\u0016<\u0016\u000e\u001e5D_:4\u0017nZ:)\u00079\ti\"A\u000buKN$8I]3bi\u0016LeMT8u\u000bbL7\u000f^:)\u0007=\ti\"A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD3\u0001EA\u000f\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004#\u0005u\u0011a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JD3AEA\u000f\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$\bfA\n\u0002\u001e\u0005YB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019'fm\u0016d7i\u001c8gS\u001eD3\u0001FA\u000f\u00039!Xm\u001d;MSN$Hk\u001c9jGND3!FA\u000f\u0003m!Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5XQ&$X\r\\5ti\"\u001aa#!\b\u0002CQ,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[#yG2,H-Z%oi\u0016\u0014h.\u00197)\u0007]\ti\"A\fuKN$\u0018\t\u001c;feB\u000b'\u000f^5uS>t7i\\;oi\"\u001a\u0001$!\b\u0002'Q,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;)\u0007e\ti\"\u0001\u0012uKN$\u0018\t\u001c;fe^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u00045\u0005u\u0011!\u0005;fgR\fE\u000e^3s\u0013\u001a,\u00050[:ug\"\u001a1$!\b\u0002!Q,7\u000f^!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u000f\u0002\u001e\u0005yC/Z:u\u0007>tg-[4Qe\u0016\u001cXM\u001d<bi&|g.Q2s_N\u001c\b+\u0019:uSRLwN\\!mi\u0016\u0014\u0018\r^5p]\"\u001aQ$!\b\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eK\u0002\u001f\u0003;\t!\u0003^3ti\u0012+G.\u001a;f\u0013\u001a,\u00050[:ug\"\u001aq$!\b\u0002/Q,7\u000f\u001e#fY\u0016$X-\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007f\u0001\u0011\u0002\u001e\u0005aB/Z:u\t\u0016\u001c8M]5cK&3Gk\u001c9jG:{G/\u0012=jgR\u001c\bfA\u0011\u0002\u001e\u0005\tC/Z:u\u0007J,\u0017\r^3BYR,'\u000fV8qS\u000e<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sK\"\u001a!%!\b\u0002\u0019Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3)\u0007\r\ni\"A\u0012uKN$H)Z:de&\u0014WMU3q_J$xJ^3se&$G-\u001a8D_:4\u0017nZ:)\u0007\u0011\ni\"\u0001\u0016uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cX*\u0019:lK\u00124uN\u001d#fY\u0016$\u0018n\u001c8)\u0007\u0015\ni\"\u0001\u0018uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i_V$\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bf\u0001\u0014\u0002\u001e\u0005iC/Z:u)>\u0004\u0018nY(qKJ\fG/[8og^KG\u000f\u001b*fO\u0016D8+_7c_2Le\u000eV8qS\u000et\u0015-\\3)\u0007\u001d\ni\"\u0001\u0013uKN$\u0018\t\u001c;fe&sG/\u001a:oC2$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\rA\u0013QD\u0001Di\u0016\u001cHo\u0011:fCR,w+\u001b;i+:\u001c\b/Z2jM&,GMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003:$\u0007+\u0019:uSRLwN\\:XSRD'l[\"mS\u0016tG\u000fK\u0002*\u0003;\ta\"Y:tKJ$X\t_5u\u0007>$W\rF\u0003X\u0003/\u000b\t\u000bC\u0004\u0002\u001a*\u0002\r!a'\u0002\u0011\u0015D\b/Z2uK\u0012\u00042\u0001WAO\u0013\r\ty*\u0017\u0002\u0004\u0013:$\bbBARU\u0001\u0007\u0011QU\u0001\u0007[\u0016$\bn\u001c3\u0011\ta\u000b9kV\u0005\u0004\u0003SK&!\u0003$v]\u000e$\u0018n\u001c81\u0001")
public class TopicCommandWithZKClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService topicService;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private TopicCommand.ZookeeperTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.topicService = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    @Before
    public void setup() {
        this.topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void teardown() {
        if (this.topicService() != null) {
            this.topicService().close();
            return;
        }
    }

    @Test
    public void testCreate() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        KafkaZkClient qual$1 = this.zkClient();
        boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
        Assert.assertTrue((boolean)qual$1.getAllTopicsInCluster(x$1).contains((Object)this.testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"})));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName(), "--if-not-exists"}));
        this.topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 0));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.format.version=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts2), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithWhitelist() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topic2, x$7, x$8, x$9, x$10);
        AdminZkClient qual$3 = this.adminZkClient();
        int x$12 = 2;
        int x$13 = 2;
        Properties x$14 = qual$3.createTopic$default$4();
        RackAwareMode x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(topic3, x$12, x$13, x$14, x$15);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = "__consumer_offsets";
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
    }

    @Test
    public void testAlterAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
        this.topicService().alterTopic(alterExistsOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=compact"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output.contains("Configs: cleanup.policy=compact"));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=delete"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output2 = grabConsoleOutput_out2.toString();
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output2.contains("Configs: cleanup.policy=delete"));
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(describeOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        TopicCommand.TopicCommandOptions describeOptsAllTopics = new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        this.topicService().describeTopic(describeOptsAllTopics);
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().describeTopic(describeOptsWithExists);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Tuple2[] tuple2Array = new Tuple2[6];
        String string = "rack1";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                void $minus$greater$extension_$this;
                TopicPartition tp = (TopicPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition()));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                void $minus$greater$extension_$this;
                TopicPartition tp = (TopicPartition)x0$2._1();
                Seq replicas = (Seq)x0$2._2();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition()));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsWithConfig$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String outputWithConfig = grabConsoleOutput_out.toString();
        Assert.assertTrue((outputWithConfig.contains(this.testTopicName()) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsNoConfig$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String outputNoConfig = grabConsoleOutput_out2.toString();
        Assert.assertTrue((outputNoConfig.contains(this.testTopicName()) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.listTopics$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out3.toString();
        Assert.assertTrue((output.contains(this.testTopicName()) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        output = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", topic1}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", topic2}));
        this.topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", escapedTopic}));
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", unescapedTopic}));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(escapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertFalse((boolean)grabConsoleOutput_out.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(unescapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertTrue((boolean)grabConsoleOutput_out2.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(escapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertFalse((boolean)grabConsoleOutput_out3.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect4 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(unescapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out4 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out4, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertTrue((boolean)grabConsoleOutput_out4.toString().contains(topic2));
    }

    @Test
    public void testAlterInternalTopicPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "__consumer_offsets";
        int x$2 = 1;
        int x$3 = 1;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = "__transaction_state";
        int x$7 = 1;
        int x$8 = 1;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        this.expectAlterInternalTopicPartitionCountFailed$1("__consumer_offsets");
        this.expectAlterInternalTopicPartitionCountFailed$1("__transaction_state");
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()})).checkArgs());
    }

    /*
     * WARNING - void declaration
     */
    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithZKClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithZKClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private final void describeTopicsWithConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    private final void describeTopicsNoConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    private final void listTopics$1() {
        this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    private final void expectAlterInternalTopicPartitionCountFailed$1(String topic) {
        try {
            this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topic, "--partitions", "2"})));
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandWithZKClientTest() {
        RackAwareTest.$init$(this);
        this._testName = new TestName();
    }
}

