/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.tools.FeatureCommand;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FeatureCommandUnitTest {
    FeatureCommandUnitTest() {
    }

    @Test
    public void testLevelToString() {
        Assertions.assertEquals((Object)"5", (Object)FeatureCommand.levelToString((String)"foo.bar", (short)5));
        Assertions.assertEquals((Object)"3.3-IV0", (Object)FeatureCommand.levelToString((String)"metadata.version", (short)MetadataVersion.IBP_3_3_IV0.featureLevel()));
    }

    @Test
    public void testMetadataVersionsToString() {
        Assertions.assertEquals((Object)"3.3-IV0, 3.3-IV1, 3.3-IV2, 3.3-IV3", (Object)FeatureCommand.metadataVersionsToString((MetadataVersion)MetadataVersion.IBP_3_3_IV0, (MetadataVersion)MetadataVersion.IBP_3_3_IV3));
    }

    @Test
    public void testdowngradeType() {
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.singletonMap("unsafe", Boolean.FALSE))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.singletonMap("unsafe", Boolean.TRUE))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.emptyMap())));
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo.bar", "5"}, (Object[])FeatureCommand.parseNameAndLevel((String)"foo.bar=5"));
        Assertions.assertArrayEquals((Object[])new String[]{"quux", "0"}, (Object[])FeatureCommand.parseNameAndLevel((String)"quux=0"));
        Assertions.assertTrue((boolean)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FeatureCommand.parseNameAndLevel((String)"baaz"))).getMessage().contains("Can't parse feature=level string baaz: equals sign not found."));
        Assertions.assertTrue((boolean)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FeatureCommand.parseNameAndLevel((String)"w=tf"))).getMessage().contains("Can't parse feature=level string w=tf: unable to parse tf as a short."));
    }

    private static MockAdminClient buildAdminClient() {
        HashMap<String, Short> minSupportedFeatureLevels = new HashMap<String, Short>();
        minSupportedFeatureLevels.put("metadata.version", MetadataVersion.IBP_3_3_IV0.featureLevel());
        minSupportedFeatureLevels.put("foo.bar", (short)0);
        HashMap<String, Short> featureLevels = new HashMap<String, Short>();
        featureLevels.put("metadata.version", MetadataVersion.IBP_3_3_IV2.featureLevel());
        featureLevels.put("foo.bar", (short)5);
        HashMap<String, Short> maxSupportedFeatureLevels = new HashMap<String, Short>();
        maxSupportedFeatureLevels.put("metadata.version", MetadataVersion.IBP_3_3_IV3.featureLevel());
        maxSupportedFeatureLevels.put("foo.bar", (short)10);
        return new MockAdminClient.Builder().minSupportedFeatureLevels(minSupportedFeatureLevels).featureLevels(featureLevels).maxSupportedFeatureLevels(maxSupportedFeatureLevels).build();
    }

    @Test
    public void testHandleDescribe() {
        String describeResult = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleDescribe((Admin)FeatureCommandUnitTest.buildAdminClient());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)String.format("Feature: foo.bar\tSupportedMinVersion: 0\tSupportedMaxVersion: 10\tFinalizedVersionLevel: 5\tEpoch: 123%nFeature: metadata.version\tSupportedMinVersion: 3.3-IV0\tSupportedMaxVersion: 3.3-IV3\tFinalizedVersionLevel: 3.3-IV2\tEpoch: 123", new Object[0]), (Object)describeResult);
    }

    @Test
    public void testHandleUpgrade() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV1");
        namespace.put("feature", Collections.singletonList("foo.bar=6"));
        namespace.put("dry_run", false);
        String upgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar was upgraded to 6.%nCould not upgrade metadata.version to 5. Can't upgrade to lower version.", new Object[0]), (Object)upgradeOutput);
    }

    @Test
    public void testHandleUpgradeDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV1");
        namespace.put("feature", Collections.singletonList("foo.bar=6"));
        namespace.put("dry_run", true);
        String upgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar can be upgraded to 6.%nCan not upgrade metadata.version to 5. Can't upgrade to lower version.", new Object[0]), (Object)upgradeOutput);
    }

    @Test
    public void testHandleDowngrade() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV3");
        namespace.put("feature", Collections.singletonList("foo.bar=1"));
        namespace.put("dry_run", false);
        String downgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDowngrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar was downgraded to 1.%nCould not downgrade metadata.version to 7. Can't downgrade to newer version.", new Object[0]), (Object)downgradeOutput);
    }

    @Test
    public void testHandleDowngradeDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV3");
        namespace.put("feature", Collections.singletonList("foo.bar=1"));
        namespace.put("dry_run", true);
        String downgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDowngrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar can be downgraded to 1.%nCan not downgrade metadata.version to 7. Can't downgrade to newer version.", new Object[0]), (Object)downgradeOutput);
    }

    @Test
    public void testHandleDisable() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("feature", Arrays.asList("foo.bar", "metadata.version", "quux"));
        namespace.put("dry_run", false);
        String disableOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDisable((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 3 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar was disabled.%nCould not disable metadata.version. Can't downgrade below 4%nquux was disabled.", new Object[0]), (Object)disableOutput);
    }

    @Test
    public void testHandleDisableDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("feature", Arrays.asList("foo.bar", "metadata.version", "quux"));
        namespace.put("dry_run", true);
        String disableOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDisable((Namespace)new Namespace(namespace), (Admin)FeatureCommandUnitTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("1 out of 3 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("foo.bar can be disabled.%nCan not disable metadata.version. Can't downgrade below 4%nquux can be disabled.", new Object[0]), (Object)disableOutput);
    }
}

