/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.ConsumerPerformance;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ConsumerPerformanceTest {
    private final ToolsTestUtils.MockExitProcedure exitProcedure = new ToolsTestUtils.MockExitProcedure();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    @TempDir
    static Path tempDir;

    @BeforeEach
    public void beforeEach() {
        Exit.setExitProcedure((Exit.Procedure)this.exitProcedure);
    }

    @AfterEach
    public void afterEach() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testDetailedHeaderMatchBody() {
        this.testHeaderMatchContent(true, 2, () -> ConsumerPerformance.printConsumerProgress((int)1, (long)0x100000L, (long)0L, (long)1L, (long)0L, (long)0L, (long)1L, (SimpleDateFormat)this.dateFormat, (long)1L));
    }

    @Test
    public void testNonDetailedHeaderMatchBody() {
        this.testHeaderMatchContent(false, 2, () -> ConsumerPerformance.printConsumerProgress((int)1, (long)0x100000L, (long)0L, (long)1L, (long)0L, (long)0L, (long)1L, (SimpleDateFormat)this.dateFormat, (long)1L));
    }

    @Test
    public void testConfigBrokerList() {
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfOptions config = new ConsumerPerformance.ConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertTrue((boolean)config.topic().contains("test"));
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigBootStrapServer() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--print-metrics"};
        ConsumerPerformance.ConsumerPerfOptions config = new ConsumerPerformance.ConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertTrue((boolean)config.topic().contains("test"));
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testBrokerListOverride() {
        String[] args = new String[]{"--broker-list", "localhost:9094", "--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfOptions config = new ConsumerPerformance.ConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertTrue((boolean)config.topic().contains("test"));
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigWithUnrecognizedOption() {
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--new-consumer"};
        String err = ToolsTestUtils.captureStandardErr(() -> new ConsumerPerformance.ConsumerPerfOptions(args));
        Assertions.assertTrue((boolean)err.contains("new-consumer is not a recognized option"));
    }

    @Test
    public void testClientIdOverride() throws IOException {
        File tempFile = Files.createFile(tempDir.resolve("test_consumer_config.conf"), new FileAttribute[0]).toFile();
        try (PrintWriter output = new PrintWriter(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
            output.println("client.id=consumer-1");
            output.flush();
        }
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--consumer.config", tempFile.getAbsolutePath()};
        ConsumerPerformance.ConsumerPerfOptions config = new ConsumerPerformance.ConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"consumer-1", (Object)config.props().getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() throws IOException {
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfOptions config = new ConsumerPerformance.ConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"perf-consumer-client", (Object)config.props().getProperty("client.id"));
    }

    private void testHeaderMatchContent(boolean detailed, int expectedOutputLineCount, Runnable runnable) {
        String out = ToolsTestUtils.captureStandardOut(() -> {
            ConsumerPerformance.printHeader((boolean)detailed);
            runnable.run();
        });
        String[] contents = out.split("\n");
        Assertions.assertEquals((int)expectedOutputLineCount, (int)contents.length);
        String header = contents[0];
        String body = contents[1];
        Assertions.assertEquals((int)header.split(",\\s").length, (int)body.split(",\\s").length);
    }
}

