/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.tools.ClusterTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class ClusterToolTest {
    @Test
    public void testPrintClusterId() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId("QtNwvtfVQ3GEFpzOmDEE-w").build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.clusterIdCommand((PrintStream)new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"Cluster ID: QtNwvtfVQ3GEFpzOmDEE-w\n", (Object)stream.toString());
    }

    @Test
    public void testClusterTooOldToHaveId() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId(null).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.clusterIdCommand((PrintStream)new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"No cluster ID found. The Kafka version is probably too old.\n", (Object)stream.toString());
    }

    @Test
    public void testUnregisterBroker() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(true).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.unregisterCommand((PrintStream)new PrintStream(stream), (Admin)adminClient, (int)0);
        Assertions.assertEquals((Object)"Broker 0 is no longer registered.\n", (Object)stream.toString());
    }

    @Test
    public void testLegacyModeClusterCannotUnregisterBroker() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(false).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.unregisterCommand((PrintStream)new PrintStream(stream), (Admin)adminClient, (int)0);
        Assertions.assertEquals((Object)"The target cluster does not support the broker unregistration API.\n", (Object)stream.toString());
    }
}

