/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class KeyValueStoreWrapperTest {
    private static final String STORE_NAME = "kvStore";
    private static final String KEY = "k";
    private static final ValueAndTimestamp<String> VALUE_AND_TIMESTAMP = ValueAndTimestamp.make((Object)"v", (long)8L);
    @Mock
    private TimestampedKeyValueStore<String, String> timestampedStore;
    @Mock
    private VersionedKeyValueStore<String, String> versionedStore;
    @Mock
    private ProcessorContext context;
    @Mock
    private Query query;
    @Mock
    private PositionBound positionBound;
    @Mock
    private QueryConfig queryConfig;
    @Mock
    private QueryResult result;
    @Mock
    private Position position;
    private KeyValueStoreWrapper<String, String> wrapper;

    @Test
    public void shouldThrowOnNonTimestampedOrVersionedStore() {
        Mockito.when((Object)this.context.getStateStore(STORE_NAME)).thenReturn(Mockito.mock(KeyValueStore.class));
        Assert.assertThrows(InvalidStateStoreException.class, () -> new KeyValueStoreWrapper(this.context, STORE_NAME));
    }

    @Test
    public void shouldGetFromTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)((ValueAndTimestamp)this.timestampedStore.get((Object)KEY))).thenReturn(VALUE_AND_TIMESTAMP);
        MatcherAssert.assertThat((Object)this.wrapper.get((Object)KEY), (Matcher)CoreMatchers.equalTo(VALUE_AND_TIMESTAMP));
    }

    @Test
    public void shouldGetFromVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.get((Object)KEY)).thenReturn((Object)new VersionedRecord((Object)((String)VALUE_AND_TIMESTAMP.value()), VALUE_AND_TIMESTAMP.timestamp()));
        MatcherAssert.assertThat((Object)this.wrapper.get((Object)KEY), (Matcher)CoreMatchers.equalTo(VALUE_AND_TIMESTAMP));
    }

    @Test
    public void shouldGetNullFromTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)((ValueAndTimestamp)this.timestampedStore.get((Object)KEY))).thenReturn(null);
        MatcherAssert.assertThat((Object)this.wrapper.get((Object)KEY), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldGetNullFromVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.get((Object)KEY)).thenReturn(null);
        MatcherAssert.assertThat((Object)this.wrapper.get((Object)KEY), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldPutToTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        long putReturnCode = this.wrapper.put((Object)KEY, (Object)((String)VALUE_AND_TIMESTAMP.value()), VALUE_AND_TIMESTAMP.timestamp());
        MatcherAssert.assertThat((Object)putReturnCode, (Matcher)CoreMatchers.equalTo((Object)-1L));
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).put((Object)KEY, VALUE_AND_TIMESTAMP);
    }

    @Test
    public void shouldPutToVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.put((Object)KEY, (Object)((String)VALUE_AND_TIMESTAMP.value()), VALUE_AND_TIMESTAMP.timestamp())).thenReturn((Object)12L);
        long putReturnCode = this.wrapper.put((Object)KEY, (Object)((String)VALUE_AND_TIMESTAMP.value()), VALUE_AND_TIMESTAMP.timestamp());
        MatcherAssert.assertThat((Object)putReturnCode, (Matcher)CoreMatchers.equalTo((Object)12L));
    }

    @Test
    public void shouldPutNullToTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        long putReturnCode = this.wrapper.put((Object)KEY, null, VALUE_AND_TIMESTAMP.timestamp());
        MatcherAssert.assertThat((Object)putReturnCode, (Matcher)CoreMatchers.equalTo((Object)-1L));
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).put((Object)KEY, null);
    }

    @Test
    public void shouldPutNullToVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.put((Object)KEY, null, VALUE_AND_TIMESTAMP.timestamp())).thenReturn((Object)12L);
        long putReturnCode = this.wrapper.put((Object)KEY, null, VALUE_AND_TIMESTAMP.timestamp());
        MatcherAssert.assertThat((Object)putReturnCode, (Matcher)CoreMatchers.equalTo((Object)12L));
    }

    @Test
    public void shouldGetTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        MatcherAssert.assertThat((Object)this.wrapper.getStore(), (Matcher)CoreMatchers.equalTo(this.timestampedStore));
    }

    @Test
    public void shouldGetVersionedStore() {
        this.givenWrapperWithVersionedStore();
        MatcherAssert.assertThat((Object)this.wrapper.getStore(), (Matcher)CoreMatchers.equalTo(this.versionedStore));
    }

    @Test
    public void shouldGetNameForTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)this.timestampedStore.name()).thenReturn((Object)STORE_NAME);
        MatcherAssert.assertThat((Object)this.wrapper.name(), (Matcher)CoreMatchers.equalTo((Object)STORE_NAME));
    }

    @Test
    public void shouldGetNameForVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.name()).thenReturn((Object)STORE_NAME);
        MatcherAssert.assertThat((Object)this.wrapper.name(), (Matcher)CoreMatchers.equalTo((Object)STORE_NAME));
    }

    @Deprecated
    @Test
    public void shouldDeprecatedInitTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        org.apache.kafka.streams.processor.ProcessorContext mockContext = (org.apache.kafka.streams.processor.ProcessorContext)Mockito.mock(org.apache.kafka.streams.processor.ProcessorContext.class);
        this.wrapper.init(mockContext, this.wrapper);
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).init(mockContext, this.wrapper);
    }

    @Deprecated
    @Test
    public void shouldDeprecatedInitVersionedStore() {
        this.givenWrapperWithVersionedStore();
        org.apache.kafka.streams.processor.ProcessorContext mockContext = (org.apache.kafka.streams.processor.ProcessorContext)Mockito.mock(org.apache.kafka.streams.processor.ProcessorContext.class);
        this.wrapper.init(mockContext, this.wrapper);
        ((VersionedKeyValueStore)Mockito.verify(this.versionedStore)).init(mockContext, this.wrapper);
    }

    @Test
    public void shouldInitTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        StateStoreContext mockContext = (StateStoreContext)Mockito.mock(StateStoreContext.class);
        this.wrapper.init(mockContext, this.wrapper);
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).init(mockContext, this.wrapper);
    }

    @Test
    public void shouldInitVersionedStore() {
        this.givenWrapperWithVersionedStore();
        StateStoreContext mockContext = (StateStoreContext)Mockito.mock(StateStoreContext.class);
        this.wrapper.init(mockContext, this.wrapper);
        ((VersionedKeyValueStore)Mockito.verify(this.versionedStore)).init(mockContext, this.wrapper);
    }

    @Test
    public void shouldFlushTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        this.wrapper.flush();
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).flush();
    }

    @Test
    public void shouldFlushVersionedStore() {
        this.givenWrapperWithVersionedStore();
        this.wrapper.flush();
        ((VersionedKeyValueStore)Mockito.verify(this.versionedStore)).flush();
    }

    @Test
    public void shouldCloseTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        this.wrapper.close();
        ((TimestampedKeyValueStore)Mockito.verify(this.timestampedStore)).close();
    }

    @Test
    public void shouldCloseVersionedStore() {
        this.givenWrapperWithVersionedStore();
        this.wrapper.close();
        ((VersionedKeyValueStore)Mockito.verify(this.versionedStore)).close();
    }

    @Test
    public void shouldReturnPersistentForTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)this.timestampedStore.persistent()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.wrapper.persistent(), (Matcher)CoreMatchers.equalTo((Object)true));
        Mockito.when((Object)this.timestampedStore.persistent()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.wrapper.persistent(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnPersistentForVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.persistent()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.wrapper.persistent(), (Matcher)CoreMatchers.equalTo((Object)true));
        Mockito.when((Object)this.versionedStore.persistent()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.wrapper.persistent(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnIsOpenForTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)this.timestampedStore.isOpen()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.wrapper.isOpen(), (Matcher)CoreMatchers.equalTo((Object)true));
        Mockito.when((Object)this.timestampedStore.isOpen()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.wrapper.isOpen(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnIsOpenForVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.isOpen()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.wrapper.isOpen(), (Matcher)CoreMatchers.equalTo((Object)true));
        Mockito.when((Object)this.versionedStore.isOpen()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.wrapper.isOpen(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldQueryTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)this.timestampedStore.query(this.query, this.positionBound, this.queryConfig)).thenReturn((Object)this.result);
        MatcherAssert.assertThat((Object)this.wrapper.query(this.query, this.positionBound, this.queryConfig), (Matcher)CoreMatchers.equalTo((Object)this.result));
    }

    @Test
    public void shouldQueryVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.query(this.query, this.positionBound, this.queryConfig)).thenReturn((Object)this.result);
        MatcherAssert.assertThat((Object)this.wrapper.query(this.query, this.positionBound, this.queryConfig), (Matcher)CoreMatchers.equalTo((Object)this.result));
    }

    @Test
    public void shouldGetPositionForTimestampedStore() {
        this.givenWrapperWithTimestampedStore();
        Mockito.when((Object)this.timestampedStore.getPosition()).thenReturn((Object)this.position);
        MatcherAssert.assertThat((Object)this.wrapper.getPosition(), (Matcher)CoreMatchers.equalTo((Object)this.position));
    }

    @Test
    public void shouldGetPositionForVersionedStore() {
        this.givenWrapperWithVersionedStore();
        Mockito.when((Object)this.versionedStore.getPosition()).thenReturn((Object)this.position);
        MatcherAssert.assertThat((Object)this.wrapper.getPosition(), (Matcher)CoreMatchers.equalTo((Object)this.position));
    }

    private void givenWrapperWithTimestampedStore() {
        Mockito.when((Object)this.context.getStateStore(STORE_NAME)).thenReturn(this.timestampedStore);
        this.wrapper = new KeyValueStoreWrapper(this.context, STORE_NAME);
    }

    private void givenWrapperWithVersionedStore() {
        Mockito.when((Object)this.context.getStateStore(STORE_NAME)).thenReturn(this.versionedStore);
        this.wrapper = new KeyValueStoreWrapper(this.context, STORE_NAME);
    }
}

