/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;
import org.apache.kafka.streams.kstream.internals.suppress.EagerBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.FinalResultsSuppressionBuilder;
import org.apache.kafka.streams.kstream.internals.suppress.StrictBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class SuppressedTest {
    @Test
    public void bufferBuilderShouldBeConsistent() {
        MatcherAssert.assertThat((String)"noBound should remove bounds", (Object)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).withMaxRecords(4L)).withNoBound(), (Matcher)CoreMatchers.is((Object)Suppressed.BufferConfig.unbounded()));
        MatcherAssert.assertThat((String)"keys alone should be set", (Object)Suppressed.BufferConfig.maxRecords((long)2L), (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(2L, Long.MAX_VALUE, Collections.emptyMap())));
        MatcherAssert.assertThat((String)"size alone should be set", (Object)Suppressed.BufferConfig.maxBytes((long)2L), (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(Long.MAX_VALUE, 2L, Collections.emptyMap())));
        MatcherAssert.assertThat((String)"config should be set even after max records", (Object)((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).withMaxBytes(4L)).withLoggingEnabled(Collections.singletonMap("myConfigKey", "myConfigValue"))), (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(2L, 4L, Collections.singletonMap("myConfigKey", "myConfigValue"))));
    }

    @Test
    public void intermediateEventsShouldAcceptAnyBufferAndSetBounds() {
        MatcherAssert.assertThat((String)"name should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()).withName("myname"), (Matcher)CoreMatchers.is((Object)new SuppressedInternal("myname", Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time alone should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time and unbounded buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time and keys buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)2L), null, false)));
        MatcherAssert.assertThat((String)"time and size buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxBytes((long)2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxBytes((long)2L), null, false)));
        MatcherAssert.assertThat((String)"all constraints should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)3L).withMaxBytes(2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)new EagerBufferConfigImpl(3L, 2L, Collections.emptyMap()), null, false)));
        MatcherAssert.assertThat((String)"config is not lost early emit is set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).withLoggingEnabled(Collections.singletonMap("myConfigKey", "myConfigValue"))).emitEarlyWhenFull()), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)new EagerBufferConfigImpl(2L, Long.MAX_VALUE, Collections.singletonMap("myConfigKey", "myConfigValue")), null, false)));
    }

    @Test
    public void finalEventsShouldAcceptStrictBuffersAndSetBounds() {
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, Suppressed.BufferConfig.unbounded())));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).shutDownWhenFull()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(2L, Long.MAX_VALUE, BufferFullStrategy.SHUT_DOWN, Collections.emptyMap()))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).shutDownWhenFull()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(Long.MAX_VALUE, 2L, BufferFullStrategy.SHUT_DOWN, Collections.emptyMap()))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", Suppressed.BufferConfig.unbounded())));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).shutDownWhenFull()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(2L, Long.MAX_VALUE, BufferFullStrategy.SHUT_DOWN, Collections.emptyMap()))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).shutDownWhenFull()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(Long.MAX_VALUE, 2L, BufferFullStrategy.SHUT_DOWN, Collections.emptyMap()))));
        MatcherAssert.assertThat((String)"config is not lost when shutdown when full is set", (Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).withLoggingEnabled(Collections.singletonMap("myConfigKey", "myConfigValue"))).shutDownWhenFull()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(Long.MAX_VALUE, 2L, BufferFullStrategy.SHUT_DOWN, Collections.singletonMap("myConfigKey", "myConfigValue")))));
    }

    @Test
    public void supportLongChainOfMethods() {
        Suppressed.BufferConfig bufferConfig = ((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.unbounded().emitEarlyWhenFull().withMaxRecords(3L)).withMaxBytes(4L)).withMaxRecords(5L)).withMaxBytes(6L);
        MatcherAssert.assertThat((String)"long chain of eager buffer config sets attributes properly", (Object)bufferConfig, (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(5L, 6L, Collections.emptyMap())));
        MatcherAssert.assertThat((String)"long chain of strict buffer config sets attributes properly", (Object)bufferConfig.shutDownWhenFull(), (Matcher)CoreMatchers.is((Object)new StrictBufferConfigImpl(5L, 6L, BufferFullStrategy.SHUT_DOWN, Collections.emptyMap())));
        Suppressed.BufferConfig bufferConfigWithLogging = ((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded().withLoggingEnabled(Collections.singletonMap("myConfigKey", "myConfigValue"))).emitEarlyWhenFull().withMaxRecords(3L)).withMaxBytes(4L)).withMaxRecords(5L)).withMaxBytes(6L);
        MatcherAssert.assertThat((String)"long chain of eager buffer config sets attributes properly with logging enabled", (Object)bufferConfigWithLogging, (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(5L, 6L, Collections.singletonMap("myConfigKey", "myConfigValue"))));
        MatcherAssert.assertThat((String)"long chain of strict buffer config sets attributes properly with logging enabled", (Object)bufferConfigWithLogging.shutDownWhenFull(), (Matcher)CoreMatchers.is((Object)new StrictBufferConfigImpl(5L, 6L, BufferFullStrategy.SHUT_DOWN, Collections.singletonMap("myConfigKey", "myConfigValue"))));
        Suppressed.BufferConfig bufferConfigWithLoggingCalledAtTheEnd = ((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)((Suppressed.EagerBufferConfig)Suppressed.BufferConfig.unbounded().emitEarlyWhenFull().withMaxRecords(3L)).withMaxBytes(4L)).withMaxRecords(5L)).withMaxBytes(6L)).withLoggingEnabled(Collections.singletonMap("myConfigKey", "myConfigValue"));
        MatcherAssert.assertThat((String)"long chain of eager buffer config sets logging even after other setters", (Object)bufferConfigWithLoggingCalledAtTheEnd, (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(5L, 6L, Collections.singletonMap("myConfigKey", "myConfigValue"))));
        MatcherAssert.assertThat((String)"long chain of strict buffer config sets logging even after other setters", (Object)bufferConfigWithLoggingCalledAtTheEnd.shutDownWhenFull(), (Matcher)CoreMatchers.is((Object)new StrictBufferConfigImpl(5L, 6L, BufferFullStrategy.SHUT_DOWN, Collections.singletonMap("myConfigKey", "myConfigValue"))));
    }
}

