/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingSessionBytesStore
extends WrappedStateStore<SessionStore<Bytes, byte[]>, byte[], byte[]>
implements SessionStore<Bytes, byte[]> {
    private InternalProcessorContext context;

    ChangeLoggingSessionBytesStore(SessionStore<Bytes, byte[]> bytesStore) {
        super(bytesStore);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        super.init(context, root);
        this.context = (InternalProcessorContext)context;
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        ((SessionStore)this.wrapped()).remove(sessionKey);
        this.context.logChange(this.name(), SessionKeySchema.toBinary(sessionKey), null, this.context.timestamp());
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        ((SessionStore)this.wrapped()).put(sessionKey, aggregate);
        this.context.logChange(this.name(), SessionKeySchema.toBinary(sessionKey), aggregate, this.context.timestamp());
    }

    @Override
    public byte[] fetchSession(Bytes key, long startTime, long endTime) {
        return (byte[])((SessionStore)this.wrapped()).fetchSession(key, startTime, endTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return ((SessionStore)this.wrapped()).fetch(key);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        return ((SessionStore)this.wrapped()).fetch(from, to);
    }
}

