/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KTableAggregate<K, V, T>
implements KTableProcessorSupplier<K, V, T> {
    private final String storeName;
    private final Initializer<T> initializer;
    private final Aggregator<? super K, ? super V, T> add;
    private final Aggregator<? super K, ? super V, T> remove;
    private boolean sendOldValues = false;

    KTableAggregate(String storeName, Initializer<T> initializer, Aggregator<? super K, ? super V, T> add, Aggregator<? super K, ? super V, T> remove) {
        this.storeName = storeName;
        this.initializer = initializer;
        this.add = add;
        this.remove = remove;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableAggregateProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, T> view() {
        return new KTableMaterializedValueGetterSupplier(this.storeName);
    }

    private class KTableAggregateProcessor
    extends AbstractProcessor<K, Change<V>> {
        private TimestampedKeyValueStore<K, T> store;
        private TimestampedTupleForwarder<K, T> tupleForwarder;

        private KTableAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (TimestampedKeyValueStore)context.getStateStore(KTableAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, Change<V> value) {
            Object newAgg;
            Object intermediateAgg;
            if (key == null) {
                throw new StreamsException("Record key for KTable aggregate operator with state " + KTableAggregate.this.storeName + " should not be null.");
            }
            ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.store.get(key);
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            long newTimestamp = this.context().timestamp();
            if (value.oldValue != null && oldAgg != null) {
                intermediateAgg = KTableAggregate.this.remove.apply(key, value.oldValue, oldAgg);
                newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
            } else {
                intermediateAgg = oldAgg;
            }
            if (value.newValue != null) {
                Object initializedAgg = intermediateAgg == null ? KTableAggregate.this.initializer.apply() : intermediateAgg;
                newAgg = KTableAggregate.this.add.apply(key, value.newValue, initializedAgg);
                if (oldAggAndTimestamp != null) {
                    newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
                }
            } else {
                newAgg = intermediateAgg;
            }
            this.store.put(key, ValueAndTimestamp.make(newAgg, newTimestamp));
            this.tupleForwarder.maybeForward(key, newAgg, KTableAggregate.this.sendOldValues ? oldAgg : null, newTimestamp);
        }
    }
}

