/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.ProcessorContext;

public final class ProcessorContextUtils {
    private ProcessorContextUtils() {
    }

    public static Serializer<?> getKeySerializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getSerializer(processorContext, true);
    }

    public static Serializer<?> getValueSerializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getSerializer(processorContext, false);
    }

    private static Serializer<?> getSerializer(ProcessorContext processorContext, boolean key) {
        Serde<?> serde = key ? processorContext.keySerde() : processorContext.valueSerde();
        return serde == null ? null : serde.serializer();
    }

    public static Deserializer<?> getKeyDeserializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getDeserializer(processorContext, true);
    }

    public static Deserializer<?> getValueDeserializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getDeserializer(processorContext, false);
    }

    private static Deserializer<?> getDeserializer(ProcessorContext processorContext, boolean key) {
        Serde<?> serde = key ? processorContext.keySerde() : processorContext.valueSerde();
        return serde == null ? null : serde.deserializer();
    }
}

