/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.SessionCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.SessionTupleForwarder;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamSessionWindowAggregate<K, V, Agg>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, Agg> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamSessionWindowAggregate.class);
    private final String storeName;
    private final SessionWindows windows;
    private final Initializer<Agg> initializer;
    private final Aggregator<? super K, ? super V, Agg> aggregator;
    private final Merger<? super K, Agg> sessionMerger;
    private boolean sendOldValues = false;

    public KStreamSessionWindowAggregate(SessionWindows windows, String storeName, Initializer<Agg> initializer, Aggregator<? super K, ? super V, Agg> aggregator, Merger<? super K, Agg> sessionMerger) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
        this.sessionMerger = sessionMerger;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamSessionWindowAggregateProcessor();
    }

    public SessionWindows windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private SessionWindow mergeSessionWindow(SessionWindow one, SessionWindow two) {
        long start = one.start() < two.start() ? one.start() : two.start();
        long end = one.end() > two.end() ? one.end() : two.end();
        return new SessionWindow(start, end);
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, Agg> view() {
        return new KTableValueGetterSupplier<Windowed<K>, Agg>(){

            @Override
            public KTableValueGetter<Windowed<K>, Agg> get() {
                return new KTableSessionWindowValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSessionWindowAggregate.this.storeName};
            }
        };
    }

    private class KTableSessionWindowValueGetter
    implements KTableValueGetter<Windowed<K>, Agg> {
        private SessionStore<K, Agg> store;

        private KTableSessionWindowValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<Agg> get(Windowed<K> key) {
            return ValueAndTimestamp.make(this.store.fetchSession(key.key(), key.window().start(), key.window().end()), key.window().end());
        }

        @Override
        public void close() {
        }
    }

    private class KStreamSessionWindowAggregateProcessor
    extends AbstractProcessor<K, V> {
        private SessionStore<K, Agg> store;
        private SessionTupleForwarder<K, Agg> tupleForwarder;
        private StreamsMetricsImpl metrics;
        private InternalProcessorContext internalProcessorContext;
        private Sensor lateRecordDropSensor;
        private Sensor droppedRecordsSensor;
        private long observedStreamTime = -1L;

        private KStreamSessionWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.internalProcessorContext = (InternalProcessorContext)context;
            this.metrics = (StreamsMetricsImpl)context.metrics();
            String threadId = Thread.currentThread().getName();
            this.lateRecordDropSensor = TaskMetrics.droppedRecordsSensorOrLateRecordDropSensor(threadId, context.taskId().toString(), this.internalProcessorContext.currentNode().name(), this.metrics);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor(threadId, context.taskId().toString(), this.metrics);
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
            this.tupleForwarder = new SessionTupleForwarder(this.store, context, new SessionCacheFlushListener(context), KStreamSessionWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            SessionWindow newSessionWindow;
            if (key == null) {
                LOG.warn("Skipping record due to null key. value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.droppedRecordsSensor.record();
                return;
            }
            long timestamp = this.context().timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long closeTime = this.observedStreamTime - KStreamSessionWindowAggregate.this.windows.gracePeriodMs();
            ArrayList<KeyValue> merged = new ArrayList<KeyValue>();
            SessionWindow mergedWindow = newSessionWindow = new SessionWindow(timestamp, timestamp);
            Object agg = KStreamSessionWindowAggregate.this.initializer.apply();
            try (Iterator iterator = this.store.findSessions(key, timestamp - KStreamSessionWindowAggregate.this.windows.inactivityGap(), timestamp + KStreamSessionWindowAggregate.this.windows.inactivityGap());){
                while (iterator.hasNext()) {
                    KeyValue keyValue = (KeyValue)iterator.next();
                    merged.add(keyValue);
                    agg = KStreamSessionWindowAggregate.this.sessionMerger.apply(key, agg, keyValue.value);
                    mergedWindow = KStreamSessionWindowAggregate.this.mergeSessionWindow(mergedWindow, (SessionWindow)((Windowed)keyValue.key).window());
                }
            }
            if (mergedWindow.end() < closeTime) {
                LOG.warn("Skipping record for expired window. key=[{}] topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{key, this.context().topic(), this.context().partition(), this.context().offset(), timestamp, mergedWindow.start(), mergedWindow.end(), closeTime, this.observedStreamTime});
                this.lateRecordDropSensor.record();
            } else {
                if (!mergedWindow.equals(newSessionWindow)) {
                    for (KeyValue keyValue : merged) {
                        this.store.remove((Windowed)keyValue.key);
                        this.tupleForwarder.maybeForward((Windowed)keyValue.key, null, KStreamSessionWindowAggregate.this.sendOldValues ? (Object)keyValue.value : null);
                    }
                }
                agg = KStreamSessionWindowAggregate.this.aggregator.apply(key, value, agg);
                Windowed sessionKey = new Windowed(key, mergedWindow);
                this.store.put(sessionKey, agg);
                this.tupleForwarder.maybeForward(sessionKey, agg, null);
            }
        }
    }
}

