/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowStoreIteratorWrapper;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBWindowStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements WindowStore<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final boolean retainDuplicates;
    protected final long windowSize;
    protected final SegmentedBytesStore bytesStore;
    private ProcessorContext context;
    protected StateSerdes<K, V> serdes;
    protected int seqnum = 0;

    static RocksDBWindowStore<Bytes, byte[]> bytesStore(SegmentedBytesStore inner, boolean retainDuplicates, long windowSize) {
        return new RocksDBWindowBytesStore(inner, retainDuplicates, windowSize);
    }

    RocksDBWindowStore(SegmentedBytesStore bytesStore, Serde<K> keySerde, Serde<V> valueSerde, boolean retainDuplicates, long windowSize) {
        super(bytesStore);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.bytesStore = bytesStore;
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.bytesStore.name(), context.applicationInternalStream()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        this.bytesStore.init(context, root);
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long timestamp) {
        this.maybeUpdateSeqnumForDups();
        this.bytesStore.put(WindowStoreUtils.toBinaryKey(key, timestamp, this.seqnum, this.serdes), this.serdes.rawValue(value));
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(Bytes.wrap((byte[])this.serdes.rawKey(key)), timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).valuesIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(Bytes.wrap((byte[])this.serdes.rawKey(from)), Bytes.wrap((byte[])this.serdes.rawKey(to)), timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.all();
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }

    private static class RocksDBWindowBytesStore
    extends RocksDBWindowStore<Bytes, byte[]> {
        RocksDBWindowBytesStore(SegmentedBytesStore inner, boolean retainDuplicates, long windowSize) {
            super(inner, Serdes.Bytes(), Serdes.ByteArray(), retainDuplicates, windowSize);
        }

        @Override
        public void put(Bytes key, byte[] value, long timestamp) {
            this.maybeUpdateSeqnumForDups();
            this.bytesStore.put(WindowStoreUtils.toBinaryKey(key.get(), timestamp, this.seqnum), value);
        }

        @Override
        public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
            KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(key, timeFrom, timeTo);
            return WindowStoreIteratorWrapper.bytesIterator(bytesIterator, this.serdes, this.windowSize).valuesIterator();
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to, long timeFrom, long timeTo) {
            KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(from, to, timeFrom, timeTo);
            return WindowStoreIteratorWrapper.bytesIterator(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
        }
    }
}

