/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WrappedSessionStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBSessionStore<K, AGG>
extends WrappedStateStore.AbstractStateStore
implements SessionStore<K, AGG> {
    private final Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    protected final SegmentedBytesStore bytesStore;
    protected StateSerdes<K, AGG> serdes;
    protected String topic;

    static RocksDBSessionStore<Bytes, byte[]> bytesStore(SegmentedBytesStore inner) {
        return new RocksDBSessionBytesStore(inner);
    }

    RocksDBSessionStore(SegmentedBytesStore bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde) {
        super(bytesStore);
        this.keySerde = keySerde;
        this.bytesStore = bytesStore;
        this.aggSerde = aggSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        String storeName = this.bytesStore.name();
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName, context.applicationInternalStream());
        this.serdes = new StateSerdes(this.topic, (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.aggSerde == null ? context.valueSerde() : this.aggSerde));
        this.bytesStore.init(context, root);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        return this.findSessions(key, key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(Bytes.wrap((byte[])this.serdes.rawKey(keyFrom)), Bytes.wrap((byte[])this.serdes.rawKey(keyTo)), earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator<K, AGG>(bytesIterator, this.serdes);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K from, K to) {
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    @Override
    public void remove(Windowed<K> key) {
        this.bytesStore.remove(SessionKeySerde.toBinary(key, this.serdes.keySerializer(), this.topic));
    }

    @Override
    public void put(Windowed<K> sessionKey, AGG aggregate) {
        this.bytesStore.put(SessionKeySerde.toBinary(sessionKey, this.serdes.keySerializer(), this.topic), this.serdes.rawValue(aggregate));
    }

    private static class RocksDBSessionBytesStore
    extends RocksDBSessionStore<Bytes, byte[]> {
        RocksDBSessionBytesStore(SegmentedBytesStore inner) {
            super(inner, Serdes.Bytes(), Serdes.ByteArray());
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
            KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(key, earliestSessionEndTime, latestSessionStartTime);
            return WrappedSessionStoreIterator.bytesIterator(bytesIterator, this.serdes);
        }

        @Override
        public void remove(Windowed<Bytes> key) {
            this.bytesStore.remove(SessionKeySerde.bytesToBinary(key));
        }

        @Override
        public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
            this.bytesStore.put(SessionKeySerde.bytesToBinary(sessionKey), aggregate);
        }
    }
}

