/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;

class RocksDBSegmentedBytesStore
implements SegmentedBytesStore {
    private final String name;
    private final Segments segments;
    private final SegmentedBytesStore.KeySchema keySchema;
    private ProcessorContext context;
    private volatile boolean open;

    RocksDBSegmentedBytesStore(String name, long retention, int numSegments, SegmentedBytesStore.KeySchema keySchema) {
        this.name = name;
        this.keySchema = keySchema;
        this.segments = new Segments(name, retention, numSegments);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes key, long from, long to) {
        List<Segment> searchSpace = this.keySchema.segmentsToSearch(this.segments, from, to);
        Bytes binaryFrom = this.keySchema.lowerRangeFixedSize(key, from);
        Bytes binaryTo = this.keySchema.upperRangeFixedSize(key, to);
        return new SegmentIterator(searchSpace.iterator(), this.keySchema.hasNextCondition(key, key, from, to), binaryFrom, binaryTo);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        List<Segment> searchSpace = this.keySchema.segmentsToSearch(this.segments, from, to);
        Bytes binaryFrom = this.keySchema.lowerRange(keyFrom, from);
        Bytes binaryTo = this.keySchema.upperRange(keyTo, to);
        return new SegmentIterator(searchSpace.iterator(), this.keySchema.hasNextCondition(keyFrom, keyTo, from, to), binaryFrom, binaryTo);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        List<Segment> searchSpace = this.segments.allSegments();
        return new SegmentIterator(searchSpace.iterator(), this.keySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE), null, null);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetchAll(long timeFrom, long timeTo) {
        List<Segment> searchSpace = this.segments.segments(timeFrom, timeTo);
        return new SegmentIterator(searchSpace.iterator(), this.keySchema.hasNextCondition(null, null, timeFrom, timeTo), null, null);
    }

    @Override
    public void remove(Bytes key) {
        Segment segment = this.segments.getSegmentForTimestamp(this.keySchema.segmentTimestamp(key));
        if (segment == null) {
            return;
        }
        segment.delete(key);
    }

    @Override
    public void put(Bytes key, byte[] value) {
        long segmentId = this.segments.segmentId(this.keySchema.segmentTimestamp(key));
        Segment segment = this.segments.getOrCreateSegment(segmentId, this.context);
        if (segment != null) {
            segment.put(key, value);
        }
    }

    @Override
    public byte[] get(Bytes key) {
        Segment segment = this.segments.getSegmentForTimestamp(this.keySchema.segmentTimestamp(key));
        if (segment == null) {
            return null;
        }
        return segment.get(key);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.keySchema.init(ProcessorStateManager.storeChangelogTopic(context.applicationId(), root.name(), context.applicationInternalStream()));
        this.segments.openExisting(context);
        context.register(root, false, new StateRestoreCallback(){

            @Override
            public void restore(byte[] key, byte[] value) {
                RocksDBSegmentedBytesStore.this.put(Bytes.wrap((byte[])key), value);
            }
        });
        this.flush();
        this.open = true;
    }

    @Override
    public void flush() {
        this.segments.flush();
    }

    @Override
    public void close() {
        this.open = false;
        this.segments.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

