/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.mapr;

import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileSystem;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.PermissionNotMatchException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.mapr.InternalStreamNotExistException;

public class Utils {
    public static void createAppDirAndInternalStreamsIfNotExist(StreamsConfig config) {
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            if (!Utils.maprFSpathExists(fs, "/apps/kafka-streams/")) {
                throw new KafkaException("/apps/kafka-streams/ doesn't exist");
            }
            String currentUser = UserGroupInformation.getCurrentUser().getUserName();
            String validateDirErrorMessage = "User: " + currentUser + " has no permissions to run KStreams application with ID: " + config.getString("application.id");
            ArrayList<MapRFileAce> aceList = new ArrayList<MapRFileAce>();
            MapRFileAce ace = new MapRFileAce(MapRFileAce.AccessType.READDIR);
            ace.setBooleanExpression("u:" + currentUser);
            aceList.add(ace);
            ace = new MapRFileAce(MapRFileAce.AccessType.ADDCHILD);
            ace.setBooleanExpression("u:" + currentUser);
            aceList.add(ace);
            ace = new MapRFileAce(MapRFileAce.AccessType.LOOKUPDIR);
            ace.setBooleanExpression("u:" + currentUser);
            aceList.add(ace);
            ace = new MapRFileAce(MapRFileAce.AccessType.DELETECHILD);
            ace.setBooleanExpression("u:" + currentUser);
            aceList.add(ace);
            Utils.maprFSpathCreate(fs, config.getStreamsInternalStreamFolder(), aceList, currentUser, validateDirErrorMessage);
            Utils.createStream(config.getStreamsInternalStreamNotcompacted());
            Utils.createStream(config.getStreamsInternalStreamCompacted());
            Utils.enableLogCompactionForStreamIfNotEnabled(config.getStreamsInternalStreamCompacted());
            if (!Utils.streamExists(config.getStreamsCliSideAssignmentInternalStream())) {
                throw new InternalStreamNotExistException(config.getStreamsCliSideAssignmentInternalStream() + " doesn't exist");
            }
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public static void enableLogCompactionForStreamIfNotEnabled(String streamName) {
        try {
            Configuration conf = new Configuration();
            Admin admin = Streams.newAdmin((Configuration)conf);
            StreamDescriptor desc = admin.getStreamDescriptor(streamName);
            if (!desc.getCompact()) {
                desc.setCompact(true);
                admin.editStream(streamName, desc);
            }
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private static boolean validatePermsHelper(MapRFileAce ace, String userBoolExpr) {
        try {
            String[] boolExprs;
            for (String boolExpr : boolExprs = ace.getBooleanExpression().split(",")) {
                if (!AceHelper.toPostfix((String)boolExpr).equals(userBoolExpr)) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
        return false;
    }

    public static void validateDirectoryPerms(FileSystem fs, String path, String user, String errorMsg) {
        try {
            boolean userHasAllNeededPerms;
            List aces = ((MapRFileSystem)fs).getAces(new Path(path));
            boolean readDirAce = false;
            boolean addChild = false;
            boolean lookupDir = false;
            boolean deleteChild = false;
            String userBoolExpr = AceHelper.toPostfix((String)String.format("u:%s", user));
            for (MapRFileAce ace : aces) {
                boolean userHasPerms = Utils.validatePermsHelper(ace, userBoolExpr);
                if (ace.getAccessType().equals((Object)MapRFileAce.AccessType.READDIR)) {
                    readDirAce = userHasPerms;
                }
                if (ace.getAccessType().equals((Object)MapRFileAce.AccessType.ADDCHILD)) {
                    addChild = userHasPerms;
                }
                if (ace.getAccessType().equals((Object)MapRFileAce.AccessType.LOOKUPDIR)) {
                    lookupDir = userHasPerms;
                }
                if (!ace.getAccessType().equals((Object)MapRFileAce.AccessType.DELETECHILD)) continue;
                deleteChild = userHasPerms;
            }
            boolean bl = userHasAllNeededPerms = readDirAce && lookupDir && addChild && deleteChild;
            if (!userHasAllNeededPerms) {
                throw new PermissionNotMatchException(errorMsg);
            }
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public static boolean streamExists(String streamName) {
        try {
            Configuration conf = new Configuration();
            Admin admin = Streams.newAdmin((Configuration)conf);
            return admin.streamExists(streamName);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public static void createStream(String streamName) {
        block2: {
            try {
                Configuration conf = new Configuration();
                Admin admin = Streams.newAdmin((Configuration)conf);
                StreamDescriptor desc = Streams.newStreamDescriptor();
                admin.createStream(streamName, desc);
            }
            catch (Exception e) {
                if (Utils.streamExists(streamName)) break block2;
                throw new KafkaException((Throwable)e);
            }
        }
    }

    public static boolean maprFSpathExists(FileSystem fs, String path) throws IOException {
        return fs.exists(new Path(path));
    }

    public static void maprFSpathCreate(FileSystem fs, String pathStr, ArrayList<MapRFileAce> aces, String currentUser, String validateDirErrorMsg) throws IOException {
        try {
            Path path = new Path(pathStr);
            fs.mkdirs(path);
            ((MapRFileSystem)fs).setAces(path, aces);
            int noinherit = 1;
            ((MapRFileSystem)fs).setAces(path, new ArrayList(), false, noinherit, 0, false, null);
        }
        catch (IOException e) {
            if (Utils.maprFSpathExists(fs, pathStr)) {
                Utils.validateDirectoryPerms(fs, pathStr, currentUser, validateDirErrorMsg);
                return;
            }
            throw new KafkaException((Throwable)e);
        }
    }

    public static String getShortTopicNameFromFullTopicName(String fullTopicName) {
        String[] arr = fullTopicName.split(":");
        return arr.length > 1 ? arr[1] : arr[0];
    }
}

