/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKey;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;

public class KStreamTransformValues<K, V, R>
implements ProcessorSupplier<K, V> {
    private final InternalValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier;

    public KStreamTransformValues(InternalValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier) {
        this.valueTransformerSupplier = valueTransformerSupplier;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamTransformValuesProcessor<K, V, R>(this.valueTransformerSupplier.get());
    }

    public static class KStreamTransformValuesProcessor<K, V, R>
    implements Processor<K, V> {
        private final InternalValueTransformerWithKey<K, V, R> valueTransformer;
        private ProcessorContext context;

        public KStreamTransformValuesProcessor(InternalValueTransformerWithKey<K, V, R> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(final ProcessorContext context) {
            this.valueTransformer.init(new ProcessorContext(){

                @Override
                public String applicationId() {
                    return context.applicationId();
                }

                @Override
                public String applicationInternalStream() {
                    return context.applicationInternalStream();
                }

                @Override
                public TaskId taskId() {
                    return context.taskId();
                }

                @Override
                public Serde<?> keySerde() {
                    return context.keySerde();
                }

                @Override
                public Serde<?> valueSerde() {
                    return context.valueSerde();
                }

                @Override
                public File stateDir() {
                    return context.stateDir();
                }

                @Override
                public StreamsMetrics metrics() {
                    return context.metrics();
                }

                @Override
                public void register(StateStore store, boolean deprecatedAndIgnoredLoggingEnabled, StateRestoreCallback stateRestoreCallback) {
                    context.register(store, deprecatedAndIgnoredLoggingEnabled, stateRestoreCallback);
                }

                @Override
                public StateStore getStateStore(String name) {
                    return context.getStateStore(name);
                }

                @Override
                public Cancellable schedule(long interval, PunctuationType type, Punctuator callback) {
                    return context.schedule(interval, type, callback);
                }

                @Override
                public void schedule(long interval) {
                    context.schedule(interval);
                }

                @Override
                public <K, V> void forward(K key, V value) {
                    throw new StreamsException("ProcessorContext#forward() must not be called within TransformValues.");
                }

                @Override
                public <K, V> void forward(K key, V value, int childIndex) {
                    throw new StreamsException("ProcessorContext#forward() must not be called within TransformValues.");
                }

                @Override
                public <K, V> void forward(K key, V value, String childName) {
                    throw new StreamsException("ProcessorContext#forward() must not be called within TransformValues.");
                }

                @Override
                public void commit() {
                    context.commit();
                }

                @Override
                public String topic() {
                    return context.topic();
                }

                @Override
                public int partition() {
                    return context.partition();
                }

                @Override
                public long offset() {
                    return context.offset();
                }

                @Override
                public long timestamp() {
                    return context.timestamp();
                }

                @Override
                public Map<String, Object> appConfigs() {
                    return context.appConfigs();
                }

                @Override
                public Map<String, Object> appConfigsWithPrefix(String prefix) {
                    return context.appConfigsWithPrefix(prefix);
                }
            });
            this.context = context;
        }

        @Override
        public void process(K key, V value) {
            this.context.forward(key, this.valueTransformer.transform(key, value));
        }

        @Override
        public void punctuate(long timestamp) {
            if (this.valueTransformer.punctuate(timestamp) != null) {
                throw new StreamsException("ValueTransformer#punctuate must return null.");
            }
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

