/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class MockProcessorContextAPITest {
    @Test
    public void shouldCaptureOutputRecords() {
        Processor<String, Long, String, Long> processor = new Processor<String, Long, String, Long>(){
            private ProcessorContext<String, Long> context;

            public void init(ProcessorContext<String, Long> context) {
                this.context = context;
            }

            public void process(Record<String, Long> record) {
                String key = (String)record.key();
                Long value = (Long)record.value();
                this.context.forward(record.withKey((Object)(key + value)).withValue((Object)((long)key.length() + value)));
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        processor.process(new Record((Object)"barbaz", (Object)50L, 0L));
        List actual = context.forwarded();
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"foo5", (Object)8L, 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"barbaz50", (Object)56L, 0L)));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is(expected));
        context.resetForwards();
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldCaptureRecordsOutputToChildByName() {
        Processor<String, Long, String, Long> processor = new Processor<String, Long, String, Long>(){
            private ProcessorContext<String, Long> context;
            private int count = 0;

            public void process(Record<String, Long> record) {
                String key = (String)record.key();
                Long value = (Long)record.value();
                if (this.count == 0) {
                    this.context.forward(new Record((Object)"start", (Object)-1L, 0L));
                }
                String toChild = this.count % 2 == 0 ? "george" : "pete";
                this.context.forward(new Record((Object)(key + value), (Object)((long)key.length() + value), 0L), toChild);
                ++this.count;
            }

            public void init(ProcessorContext<String, Long> context) {
                this.context = context;
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        processor.process(new Record((Object)"barbaz", (Object)50L, 0L));
        List forwarded = context.forwarded();
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"start", (Object)-1L, 0L), Optional.empty()), new MockProcessorContext.CapturedForward(new Record((Object)"foo5", (Object)8L, 0L), Optional.of("george")), new MockProcessorContext.CapturedForward(new Record((Object)"barbaz50", (Object)56L, 0L), Optional.of("pete")));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
        forwarded = context.forwarded("george");
        expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"start", (Object)-1L, 0L), Optional.empty()), new MockProcessorContext.CapturedForward(new Record((Object)"foo5", (Object)8L, 0L), Optional.of("george")));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
        forwarded = context.forwarded("pete");
        expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"start", (Object)-1L, 0L), Optional.empty()), new MockProcessorContext.CapturedForward(new Record((Object)"barbaz50", (Object)56L, 0L), Optional.of("pete")));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
        forwarded = context.forwarded("steve");
        expected = Collections.singletonList(new MockProcessorContext.CapturedForward(new Record((Object)"start", (Object)-1L, 0L)));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
    }

    @Test
    public void shouldCaptureCommitsAndAllowReset() {
        Processor<String, Long, Void, Void> processor = new Processor<String, Long, Void, Void>(){
            private ProcessorContext<Void, Void> context;
            private int count = 0;

            public void init(ProcessorContext<Void, Void> context) {
                this.context = context;
            }

            public void process(Record<String, Long> record) {
                if (++this.count > 2) {
                    this.context.commit();
                }
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        processor.process(new Record((Object)"barbaz", (Object)50L, 0L));
        MatcherAssert.assertThat((Object)context.committed(), (Matcher)Matchers.is((Object)false));
        processor.process(new Record((Object)"foobar", (Object)500L, 0L));
        MatcherAssert.assertThat((Object)context.committed(), (Matcher)Matchers.is((Object)true));
        context.resetCommit();
        MatcherAssert.assertThat((Object)context.committed(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldStoreAndReturnStateStores() {
        Processor<String, Long, Void, Void> processor = new Processor<String, Long, Void, Void>(){
            private ProcessorContext<Void, Void> context;

            public void init(ProcessorContext<Void, Void> context) {
                this.context = context;
            }

            public void process(Record<String, Long> record) {
                KeyValueStore stateStore;
                String key = (String)record.key();
                Long value = (Long)record.value();
                stateStore.put((Object)key, (Object)(((stateStore = (KeyValueStore)this.context.getStateStore("my-state")).get((Object)key) == null ? 0L : (Long)stateStore.get((Object)key)) + value));
                stateStore.put((Object)"all", (Object)((stateStore.get((Object)"all") == null ? 0L : (Long)stateStore.get((Object)"all")) + value));
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-state"), (Serde)Serdes.String(), (Serde)Serdes.Long()).withLoggingDisabled();
        KeyValueStore store = (KeyValueStore)storeBuilder.build();
        store.init(context.getStateStoreContext(), (StateStore)store);
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        processor.process(new Record((Object)"bar", (Object)50L, 0L));
        MatcherAssert.assertThat((Object)((Long)store.get((Object)"foo")), (Matcher)Matchers.is((Object)5L));
        MatcherAssert.assertThat((Object)((Long)store.get((Object)"bar")), (Matcher)Matchers.is((Object)50L));
        MatcherAssert.assertThat((Object)((Long)store.get((Object)"all")), (Matcher)Matchers.is((Object)55L));
    }

    @Test
    public void shouldCaptureApplicationAndRecordMetadata() {
        Properties config = Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"testMetadata"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"")}));
        Processor<String, Object, String, Object> processor = new Processor<String, Object, String, Object>(){
            private ProcessorContext<String, Object> context;

            public void init(ProcessorContext<String, Object> context) {
                this.context = context;
            }

            public void process(Record<String, Object> record) {
                this.context.forward(new Record((Object)"appId", (Object)this.context.applicationId(), 0L));
                this.context.forward(new Record((Object)"taskId", (Object)this.context.taskId(), 0L));
                if (this.context.recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = (RecordMetadata)this.context.recordMetadata().get();
                    this.context.forward(new Record((Object)"topic", (Object)recordMetadata.topic(), 0L));
                    this.context.forward(new Record((Object)"partition", (Object)recordMetadata.partition(), 0L));
                    this.context.forward(new Record((Object)"offset", (Object)recordMetadata.offset(), 0L));
                }
                this.context.forward(new Record((Object)"record", record, 0L));
            }
        };
        MockProcessorContext context = new MockProcessorContext(config);
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        List forwarded = context.forwarded();
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"appId", (Object)"testMetadata", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"taskId", (Object)new TaskId(0, 0), 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"record", (Object)new Record((Object)"foo", (Object)5L, 0L), 0L)));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
        context.resetForwards();
        context.setRecordMetadata("t1", 0, 0L);
        processor.process(new Record((Object)"foo", (Object)5L, 0L));
        forwarded = context.forwarded();
        expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"appId", (Object)"testMetadata", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"taskId", (Object)new TaskId(0, 0), 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"topic", (Object)"t1", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"partition", (Object)0, 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"offset", (Object)0L, 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"record", (Object)new Record((Object)"foo", (Object)5L, 0L), 0L)));
        MatcherAssert.assertThat((Object)forwarded, (Matcher)Matchers.is(expected));
    }

    @Test
    public void shouldCapturePunctuator() {
        Processor<String, Long, Void, Void> processor = new Processor<String, Long, Void, Void>(){

            public void init(ProcessorContext<Void, Void> context) {
                context.schedule(Duration.ofSeconds(1L), PunctuationType.WALL_CLOCK_TIME, timestamp -> context.commit());
            }

            public void process(Record<String, Long> record) {
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        MockProcessorContext.CapturedPunctuator capturedPunctuator = (MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0);
        MatcherAssert.assertThat((Object)capturedPunctuator.getInterval(), (Matcher)Matchers.is((Object)Duration.ofMillis(1000L)));
        MatcherAssert.assertThat((Object)capturedPunctuator.getType(), (Matcher)Matchers.is((Object)PunctuationType.WALL_CLOCK_TIME));
        MatcherAssert.assertThat((Object)capturedPunctuator.cancelled(), (Matcher)Matchers.is((Object)false));
        Punctuator punctuator = capturedPunctuator.getPunctuator();
        MatcherAssert.assertThat((Object)context.committed(), (Matcher)Matchers.is((Object)false));
        punctuator.punctuate(1234L);
        MatcherAssert.assertThat((Object)context.committed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void fullConstructorShouldSetAllExpectedAttributes() {
        Properties config = new Properties();
        config.put("application.id", "testFullConstructor");
        config.put("bootstrap.servers", "");
        config.put("default.key.serde", Serdes.String().getClass());
        config.put("default.value.serde", Serdes.Long().getClass());
        File dummyFile = new File("");
        MockProcessorContext context = new MockProcessorContext(config, new TaskId(1, 1), dummyFile);
        MatcherAssert.assertThat((Object)context.applicationId(), (Matcher)Matchers.is((Object)"testFullConstructor"));
        MatcherAssert.assertThat((Object)context.taskId(), (Matcher)Matchers.is((Object)new TaskId(1, 1)));
        MatcherAssert.assertThat(context.appConfigs().get("application.id"), (Matcher)Matchers.is((Object)"testFullConstructor"));
        MatcherAssert.assertThat(context.appConfigsWithPrefix("application.").get("id"), (Matcher)Matchers.is((Object)"testFullConstructor"));
        MatcherAssert.assertThat(context.keySerde().getClass(), (Matcher)Matchers.is(Serdes.String().getClass()));
        MatcherAssert.assertThat(context.valueSerde().getClass(), (Matcher)Matchers.is(Serdes.Long().getClass()));
        MatcherAssert.assertThat((Object)context.stateDir(), (Matcher)Matchers.is((Object)dummyFile));
    }
}

