/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.kstream.internals.RepartitionedInternal;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.scala.kstream.Repartitioned$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]2Aa\u0002\u0005\u0001+!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)q\u0006\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A!)1\u0007\u0001C\u0001A!)Q\u0007\u0001C\u0001A\t\t\"+\u001a9beRLG/[8oK\u0012$Vm\u001d;\u000b\u0005%Q\u0011aB6tiJ,\u0017-\u001c\u0006\u0003\u00171\tQa]2bY\u0006T!!\u0004\b\u0002\u000fM$(/Z1ng*\u0011q\u0002E\u0001\u0006W\u000647.\u0019\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001a\u001b\u0005A\"\"A\u0006\n\u0005iA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0011\u0005\tC/Z:u\u0007J,\u0017\r^3SKB\f'\u000f^5uS>tW\rZ,ji\"\u001cVM\u001d3fgR\t\u0011\u0005\u0005\u0002\u0018E%\u00111\u0005\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0003KA\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0004CBL'B\u0001\u0016,\u0003\u001dQW\u000f]5uKJT!\u0001\f\n\u0002\u000b),h.\u001b;\n\u00059:#\u0001\u0002+fgR\f\u0011\u0007^3ti\u000e\u0013X-\u0019;f%\u0016\u0004\u0018M\u001d;ji&|g.\u001a3XSRD7+\u001a:eKN\fe\u000e\u001a(v[B\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0004K\u0005iC/Z:u\u0007J,\u0017\r^3SKB\f'\u000f^5uS>tW\rZ,ji\"\u001cVM\u001d3fg\u0006sG\rV8qS\u000et\u0015-\\3)\u0005\u0011)\u0013!\u0015;fgR\u001c%/Z1uKJ+\u0007/\u0019:uSRLwN\\3e/&$\bnU3sI\u0016\u001c\u0018I\u001c3U_BL7MT1nK\u0006sGMT;n!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3TiJ,\u0017-\u001c)beRLG/[8oKJD#!B\u0013\u0002\u0011R,7\u000f^\"sK\u0006$XMU3qCJ$\u0018\u000e^5p]\u0016$w+\u001b;i)>\u0004\u0018n\u0019(b[\u0016\fe\u000e\u001a(v[B\u000b'\u000f^5uS>t7/\u00118e'R\u0014X-Y7QCJ$\u0018\u000e^5p]\u0016\u0014\bF\u0001\u0004&\u0001")
public class RepartitionedTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateRepartitionedWithSerdes() {
        void with_valueSerde;
        Serdes.LongSerde longSerde = new Serdes.LongSerde();
        Serdes.StringSerde with_keySerde = new Serdes.StringSerde();
        Object var3_2 = null;
        longSerde = null;
        Repartitioned repartitioned = Repartitioned.with((Serde)with_keySerde, (Serde)with_valueSerde);
        RepartitionedInternal internalRepartitioned = new RepartitionedInternal(repartitioned);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalRepartitioned.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalRepartitioned.valueSerde().getClass());
    }

    @Test
    public void testCreateRepartitionedWithSerdesAndNumPartitions() {
        Repartitioned repartitioned = Repartitioned$.MODULE$.with(5, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        RepartitionedInternal internalRepartitioned = new RepartitionedInternal(repartitioned);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalRepartitioned.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalRepartitioned.valueSerde().getClass());
        Assertions.assertEquals((int)5, (Integer)internalRepartitioned.numberOfPartitions());
    }

    @Test
    public void testCreateRepartitionedWithSerdesAndTopicName() {
        Repartitioned repartitioned = Repartitioned$.MODULE$.with("repartitionTopic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        RepartitionedInternal internalRepartitioned = new RepartitionedInternal(repartitioned);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalRepartitioned.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalRepartitioned.valueSerde().getClass());
        Assertions.assertEquals((Object)"repartitionTopic", (Object)internalRepartitioned.name());
    }

    @Test
    public void testCreateRepartitionedWithSerdesAndTopicNameAndNumPartitionsAndStreamPartitioner() {
        StreamPartitioner<String, Object> partitioner = new StreamPartitioner<String, Object>(null){

            public Optional partitions(String x$1, Object x$2, Object x$3, int x$4) {
                return super.partitions(x$1, x$2, x$3, x$4);
            }

            public Integer partition(String topic, String key, long value, int numPartitions) {
                return Predef$.MODULE$.int2Integer(0);
            }
        };
        Repartitioned repartitioned = Repartitioned$.MODULE$.with((StreamPartitioner)partitioner, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        RepartitionedInternal internalRepartitioned = new RepartitionedInternal(repartitioned);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalRepartitioned.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalRepartitioned.valueSerde().getClass());
        Assertions.assertEquals((Object)partitioner, (Object)internalRepartitioned.streamPartitioner());
    }

    @Test
    public void testCreateRepartitionedWithTopicNameAndNumPartitionsAndStreamPartitioner() {
        StreamPartitioner<String, Object> partitioner = new StreamPartitioner<String, Object>(null){

            public Optional partitions(String x$1, Object x$2, Object x$3, int x$4) {
                return super.partitions(x$1, x$2, x$3, x$4);
            }

            public Integer partition(String topic, String key, long value, int numPartitions) {
                return Predef$.MODULE$.int2Integer(0);
            }
        };
        Repartitioned repartitioned = Repartitioned$.MODULE$.with(5, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde()).withName("repartitionTopic").withStreamPartitioner((StreamPartitioner)partitioner);
        RepartitionedInternal internalRepartitioned = new RepartitionedInternal(repartitioned);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalRepartitioned.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalRepartitioned.valueSerde().getClass());
        Assertions.assertEquals((int)5, (Integer)internalRepartitioned.numberOfPartitions());
        Assertions.assertEquals((Object)"repartitionTopic", (Object)internalRepartitioned.name());
        Assertions.assertEquals((Object)partitioner, (Object)internalRepartitioned.streamPartitioner());
    }
}

