/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]2Aa\u0002\u0005\u0001+!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)q\u0006\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A!)1\u0007\u0001C\u0001A!)Q\u0007\u0001C\u0001A\t\u0001R*\u0019;fe&\fG.\u001b>fIR+7\u000f\u001e\u0006\u0003\u0013)\tqa[:ue\u0016\fWN\u0003\u0002\f\u0019\u0005)1oY1mC*\u0011QBD\u0001\bgR\u0014X-Y7t\u0015\ty\u0001#A\u0003lC\u001a\\\u0017M\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"aF\r\u000e\u0003aQ\u0011aC\u0005\u00035a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\t\u0003\u0001\"Xm\u001d;De\u0016\fG/Z'bi\u0016\u0014\u0018.\u00197ju\u0016$w+\u001b;i'\u0016\u0014H-Z:\u0015\u0003\u0005\u0002\"a\u0006\u0012\n\u0005\rB\"\u0001B+oSRD#AA\u0013\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013aA1qS*\u0011!fK\u0001\bUV\u0004\u0018\u000e^3s\u0015\ta##A\u0003kk:LG/\u0003\u0002/O\t!A+Z:u\u00031\"Xm\u001d;De\u0016\fG/Z'bi\u0016\u0014\u0018.\u00197ju\u0016$w+\u001b;i'\u0016\u0014H-Z:B]\u0012\u001cFo\u001c:f\u001d\u0006lW\r\u000b\u0002\u0004K\u00051D/Z:u\u0007J,\u0017\r^3NCR,'/[1mSj,GmV5uQN+'\u000fZ3t\u0003:$w+\u001b8e_^\u001cFo\u001c:f'V\u0004\b\u000f\\5fe\"\u0012A!J\u00019i\u0016\u001cHo\u0011:fCR,W*\u0019;fe&\fG.\u001b>fI^KG\u000f[*fe\u0012,7/\u00118e\u0017\u0016Lh+\u00197vKN#xN]3TkB\u0004H.[3sQ\t)Q%A\u001cuKN$8I]3bi\u0016l\u0015\r^3sS\u0006d\u0017N_3e/&$\bnU3sI\u0016\u001c\u0018I\u001c3TKN\u001c\u0018n\u001c8Ti>\u0014XmU;qa2LWM\u001d\u0015\u0003\r\u0015\u0002")
public class MaterializedTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateMaterializedWithSerdes() {
        void with_valueSerde;
        Serdes.LongSerde longSerde = new Serdes.LongSerde();
        Serdes.StringSerde with_keySerde = new Serdes.StringSerde();
        Object var3_2 = null;
        longSerde = null;
        Materialized materialized = Materialized.with((Serde)with_keySerde, (Serde)with_valueSerde);
        MaterializedInternal internalMaterialized = new MaterializedInternal(materialized);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalMaterialized.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalMaterialized.valueSerde().getClass());
    }

    @Test
    public void testCreateMaterializedWithSerdesAndStoreName() {
        String storeName = "store";
        Materialized materialized = Materialized$.MODULE$.as(storeName, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        MaterializedInternal internalMaterialized = new MaterializedInternal(materialized);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalMaterialized.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalMaterialized.valueSerde().getClass());
        Assertions.assertEquals((Object)storeName, (Object)internalMaterialized.storeName());
    }

    @Test
    public void testCreateMaterializedWithSerdesAndWindowStoreSupplier() {
        WindowBytesStoreSupplier storeSupplier = Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)true);
        Materialized materialized = Materialized$.MODULE$.as(storeSupplier, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        MaterializedInternal internalMaterialized = new MaterializedInternal(materialized);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalMaterialized.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalMaterialized.valueSerde().getClass());
        Assertions.assertEquals((Object)storeSupplier, (Object)internalMaterialized.storeSupplier());
    }

    @Test
    public void testCreateMaterializedWithSerdesAndKeyValueStoreSupplier() {
        KeyValueBytesStoreSupplier storeSupplier = Stores.persistentKeyValueStore((String)"store");
        Materialized materialized = Materialized$.MODULE$.as(storeSupplier, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        MaterializedInternal internalMaterialized = new MaterializedInternal(materialized);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalMaterialized.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalMaterialized.valueSerde().getClass());
        Assertions.assertEquals((Object)storeSupplier, (Object)internalMaterialized.storeSupplier());
    }

    @Test
    public void testCreateMaterializedWithSerdesAndSessionStoreSupplier() {
        SessionBytesStoreSupplier storeSupplier = Stores.persistentSessionStore((String)"store", (Duration)Duration.ofMillis(1L));
        Materialized materialized = Materialized$.MODULE$.as(storeSupplier, (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde());
        MaterializedInternal internalMaterialized = new MaterializedInternal(materialized);
        Assertions.assertEquals(new Serdes.StringSerde().getClass(), internalMaterialized.keySerde().getClass());
        Assertions.assertEquals(new Serdes.LongSerde().getClass(), internalMaterialized.valueSerde().getClass());
        Assertions.assertEquals((Object)storeSupplier, (Object)internalMaterialized.storeSupplier());
    }
}

