/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.WordCountTestData;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\n\u0015\u0001}AQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u00049\u0011\u0019a\u0004\u0001)A\u0007s!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002$\u0001A\u0003%q\bC\u0004H\u0001\t\u0007I\u0011\u0002%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0007\u0001\"\u0001T\u0011\u00159\u0007\u0001\"\u0001T\u0011\u0015a\u0007\u0001\"\u0001T\u0011\u0015q\u0007\u0001\"\u0001T\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015A\b\u0001\"\u0003r\u0011\u0015I\b\u0001\"\u0003r\u0011\u0015Q\b\u0001\"\u0003|\u000559vN\u001d3D_VtG\u000fV3ti*\u0011QCF\u0001\u0006g\u000e\fG.\u0019\u0006\u0003/a\tqa\u001d;sK\u0006l7O\u0003\u0002\u001a5\u0005)1.\u00194lC*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011&!\t\t3%D\u0001#\u0015\u0005)\u0012B\u0001\u0013#\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002)%\u0011\u0001\u0006\u0006\u0002\u0012/>\u0014HmQ8v]R$Vm\u001d;ECR\f\u0017A\u0002\u001fj]&$h\bF\u0001,!\t1\u0003!A\u0004dYV\u001cH/\u001a:\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000bU$\u0018\u000e\\:\u000b\u0005M2\u0012aC5oi\u0016<'/\u0019;j_:L!!\u000e\u0019\u0003)\u0015k'-\u001a3eK\u0012\\\u0015MZ6b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013aC1mS\u001etW\r\u001a+j[\u0016,\u0012!\u000f\t\u0003CiJ!a\u000f\u0012\u0003\t1{gnZ\u0001\rC2LwM\\3e)&lW\rI\u0001\t[>\u001c7\u000eV5nKV\tq\b\u0005\u0002A\t6\t\u0011I\u0003\u00022\u0005*\u00111\tG\u0001\u0007G>lWn\u001c8\n\u0005\u0015\u000b%\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013A\u0003;fgR4u\u000e\u001c3feV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006\u0011\u0011n\u001c\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0003GS2,\u0017a\u0003;fgR4u\u000e\u001c3fe\u0002\n\u0011c\u001d;beR\\\u0015MZ6b\u00072,8\u000f^3s)\u0005!\u0006CA\u0011V\u0013\t1&E\u0001\u0003V]&$\bF\u0001\u0006Y!\tI\u0006-D\u0001[\u0015\tYF,A\u0002ba&T!!\u00180\u0002\u000f),\b/\u001b;fe*\u0011q\fH\u0001\u0006UVt\u0017\u000e^\u0005\u0003Cj\u0013!BQ3g_J,W)Y2i\u0003A\u0019Ho\u001c9LC\u001a\\\u0017m\u00117vgR,'\u000f\u000b\u0002\fIB\u0011\u0011,Z\u0005\u0003Mj\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002)Q,7\u000f^*i_VdGmQ8v]R<vN\u001d3tQ\ta\u0011\u000e\u0005\u0002ZU&\u00111N\u0017\u0002\u0005)\u0016\u001cH/\u0001\u0011uKN$8\u000b[8vY\u0012\u001cu.\u001e8u/>\u0014Hm]'bi\u0016\u0014\u0018.\u00197ju\u0016$\u0007FA\u0007j\u0003a!Xm\u001d;TQ>,H\u000eZ\"pk:$xk\u001c:eg*\u000bg/\u0019\u0015\u0003\u001d%\fqcZ3u'R\u0014X-Y7t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0003I\u0004\"a\u001d<\u000e\u0003QT!!^'\u0002\tU$\u0018\u000e\\\u0005\u0003oR\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003E9W\r\u001e)s_\u0012,8-\u001a:D_:4\u0017nZ\u0001\u0012O\u0016$8i\u001c8tk6,'oQ8oM&<\u0017a\u00049s_\u0012,8-\u001a(D_:\u001cX/\\3\u0015\u000bq\fi\"!\t\u0011\u0007Mlx0\u0003\u0002\u007fi\n!A*[:u!\u001d\t\t!a\u0001\u0002\bej\u0011AF\u0005\u0004\u0003\u000b1\"\u0001C&fsZ\u000bG.^3\u0011\t\u0005%\u0011q\u0003\b\u0005\u0003\u0017\t\u0019\u0002E\u0002\u0002\u000e\tj!!a\u0004\u000b\u0007\u0005Ea$\u0001\u0004=e>|GOP\u0005\u0004\u0003+\u0011\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016\tBq!a\b\u0013\u0001\u0004\t9!\u0001\u0006j]B,H\u000fV8qS\u000eDq!a\t\u0013\u0001\u0004\t9!A\u0006pkR\u0004X\u000f\u001e+pa&\u001c\u0007f\u0002\u0001\u0002(\u00055\u0012q\u0006\t\u00043\u0006%\u0012bAA\u00165\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0003M\u0002")
public class WordCountTest
implements WordCountTestData {
    private final EmbeddedKafkaCluster cluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final File testFolder;
    private String inputTopic;
    private String outputTopic;
    private String inputTopicJ;
    private String outputTopicJ;
    private List<String> inputValues;
    private List<KeyValue<String, Object>> expectedWordCounts;

    @Override
    public String inputTopic() {
        return this.inputTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String inputTopicJ() {
        return this.inputTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public List<String> inputValues() {
        return this.inputValues;
    }

    @Override
    public List<KeyValue<String, Object>> expectedWordCounts() {
        return this.expectedWordCounts;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopic_$eq(String x$1) {
        this.inputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopicJ_$eq(String x$1) {
        this.inputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputValues_$eq(List<String> x$1) {
        this.inputValues = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$expectedWordCounts_$eq(List<KeyValue<String, Object>> x$1) {
        this.expectedWordCounts = x$1;
    }

    private EmbeddedKafkaCluster cluster() {
        return this.cluster;
    }

    private final long alignedTime() {
        return this.alignedTime;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private File testFolder() {
        return this.testFolder;
    }

    @BeforeEach
    public void startKafkaCluster() {
        this.cluster().start();
        this.cluster().createTopic(this.inputTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.inputTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @AfterEach
    public void stopKafkaCluster() {
        this.cluster().stop();
        Utils.delete((File)this.testFolder());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldCountWords() {
        void producedFromSerde_valueSerde;
        void materializedFromSerde_valueSerde;
        void groupedFromSerde_valueSerde;
        void consumedFromSerde_valueSerde;
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(new org.apache.kafka.streams.StreamsBuilder());
        Serdes.StringSerde stringSerde = new Serdes.StringSerde();
        Serdes.StringSerde consumedFromSerde_keySerde = new Serdes.StringSerde();
        Object var7_4 = null;
        stringSerde = null;
        KStream textLines = streamBuilder.stream(this.inputTopic(), Consumed.with((Serde)consumedFromSerde_keySerde, (Serde)consumedFromSerde_valueSerde));
        Pattern pattern = Pattern.compile("\\W+", 256);
        Serdes.StringSerde stringSerde2 = new Serdes.StringSerde();
        Serdes.StringSerde groupedFromSerde_keySerde = new Serdes.StringSerde();
        Object var9_8 = null;
        stringSerde2 = null;
        Serdes.LongSerde longSerde = new Serdes.LongSerde();
        Serdes.StringSerde materializedFromSerde_keySerde = new Serdes.StringSerde();
        Object var11_10 = null;
        longSerde = null;
        Serdes.LongSerde longSerde2 = new Serdes.LongSerde();
        Serdes.StringSerde producedFromSerde_keySerde = new Serdes.StringSerde();
        Object var13_12 = null;
        longSerde2 = null;
        textLines.flatMapValues((Function1 & Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable)(x$1, v) -> v, Grouped.with((Serde)groupedFromSerde_keySerde, (Serde)groupedFromSerde_valueSerde)).count(Materialized.with((Serde)materializedFromSerde_keySerde, (Serde)materializedFromSerde_valueSerde)).toStream().to(this.outputTopic(), Produced.with((Serde)producedFromSerde_keySerde, (Serde)producedFromSerde_valueSerde));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assertions.assertEquals((Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(actualWordCounts).asScala().take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable)x$2 -> (String)x$2.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable)x$3 -> (String)x$3.key, (Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldCountWordsMaterialized() {
        void producedFromSerde_valueSerde;
        void groupedFromSerde_valueSerde;
        void consumedFromSerde_valueSerde;
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(new org.apache.kafka.streams.StreamsBuilder());
        Serdes.StringSerde stringSerde = new Serdes.StringSerde();
        Serdes.StringSerde consumedFromSerde_keySerde = new Serdes.StringSerde();
        Object var7_4 = null;
        stringSerde = null;
        KStream textLines = streamBuilder.stream(this.inputTopic(), Consumed.with((Serde)consumedFromSerde_keySerde, (Serde)consumedFromSerde_valueSerde));
        Pattern pattern = Pattern.compile("\\W+", 256);
        Serdes.StringSerde stringSerde2 = new Serdes.StringSerde();
        Serdes.StringSerde groupedFromSerde_keySerde = new Serdes.StringSerde();
        Object var9_8 = null;
        stringSerde2 = null;
        Serdes.LongSerde longSerde = new Serdes.LongSerde();
        Serdes.StringSerde producedFromSerde_keySerde = new Serdes.StringSerde();
        Object var11_10 = null;
        longSerde = null;
        textLines.flatMapValues((Function1 & Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable)(k, v) -> v, Grouped.with((Serde)groupedFromSerde_keySerde, (Serde)groupedFromSerde_valueSerde)).count(Materialized$.MODULE$.as("word-count", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde())).toStream().to(this.outputTopic(), Produced.with((Serde)producedFromSerde_keySerde, (Serde)producedFromSerde_valueSerde));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assertions.assertEquals((Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(actualWordCounts).asScala().take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable)x$4 -> (String)x$4.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable)x$5 -> (String)x$5.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsJava() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        streamsConfiguration.put("default.key.serde", new Serdes.StringSerde().getClass().getName());
        streamsConfiguration.put("default.value.serde", new Serdes.StringSerde().getClass().getName());
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopicJ());
        Pattern pattern = Pattern.compile("\\W+", 256);
        textLines.flatMapValues(line -> CollectionConverters$.MODULE$.BufferHasAsJava(Predef$.MODULE$.wrapRefArray((Object[])pattern.split(line.toLowerCase())).toBuffer()).asJava()).groupBy((x$6, v) -> v).count().toStream().to(this.outputTopicJ(), Produced.with((Serde)new Serdes.StringSerde(), (Serde)new Serdes.LongSerde()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopicJ(), this.outputTopicJ());
        streams.close();
        Assertions.assertEquals((Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(actualWordCounts).asScala().take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable)x$7 -> (String)x$7.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable)x$8 -> (String)x$8.key, (Ordering)Ordering.String$.MODULE$));
    }

    private Properties getStreamsConfiguration() {
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "wordcount-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "10000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getPath());
        return streamsConfiguration;
    }

    private Properties getProducerConfig() {
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return p;
    }

    private Properties getConsumerConfig() {
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "wordcount-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return p;
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<KeyValue<String, Object>> produceNConsume(String inputTopic, String outputTopic) {
        void produceValuesSynchronously_time;
        Properties linesProducerConfig = this.getProducerConfig();
        MockTime mockTime = this.mockTime();
        java.util.List produceValuesSynchronously_records = CollectionConverters$.MODULE$.SeqHasAsJava(this.inputValues()).asJava();
        IntegrationTestUtils.produceValuesSynchronously((String)inputTopic, (Collection)produceValuesSynchronously_records, (Properties)linesProducerConfig, (Time)produceValuesSynchronously_time, (boolean)false);
        Object var5_5 = null;
        mockTime = null;
        Properties consumerConfig = this.getConsumerConfig();
        int waitUntilMinKeyValueRecordsReceived_expectedNumRecords = this.expectedWordCounts().size();
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (int)waitUntilMinKeyValueRecordsReceived_expectedNumRecords, (long)60000L);
    }

    public WordCountTest() {
        WordCountTestData.$init$(this);
        this.cluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.testFolder = TestUtils.tempDirectory(null, null);
        Statics.releaseFence();
    }
}

