/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.utils;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.scala.utils.StreamToTableJoinTestData;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\n\u0014\u0001\u0001BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00047\u0001\u0001\u0006Ia\f\u0005\bo\u0001\u0011\r\u0011\"\u00049\u0011\u0019a\u0004\u0001)A\u0007s!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002$\u0001A\u0003%q\bC\u0004H\u0001\t\u0007I\u0011\u0002%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0007\u0001\"\u0001T\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015y\u0007\u0001\"\u0003i\u0011\u0015\u0001\b\u0001\"\u0003i\u0011\u0015\t\b\u0001\"\u0003i\u0011\u0015\u0011\b\u0001\"\u0001t\u0011%\t\u0019\u0003AI\u0001\n\u0003\t)CA\u0015TiJ,\u0017-\u001c+p)\u0006\u0014G.\u001a&pS:\u001c6-\u00197b\u0013:$Xm\u001a:bi&|g\u000eV3ti\n\u000b7/\u001a\u0006\u0003)U\tQ!\u001e;jYNT!AF\f\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005aI\u0012aB:ue\u0016\fWn\u001d\u0006\u00035m\tQa[1gW\u0006T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"MA\u0011!\u0005J\u0007\u0002G)\ta#\u0003\u0002&G\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003MI!!K\n\u00033M#(/Z1n)>$\u0016M\u00197f\u0015>Lg\u000eV3ti\u0012\u000bG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"a\n\u0001\u0002\u000f\rdWo\u001d;feV\tq\u0006\u0005\u00021i5\t\u0011G\u0003\u0002\u0015e)\u00111gF\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00026c\t!R)\u001c2fI\u0012,GmS1gW\u0006\u001cE.^:uKJ\f\u0001b\u00197vgR,'\u000fI\u0001\fC2LwM\\3e)&lW-F\u0001:!\t\u0011#(\u0003\u0002<G\t!Aj\u001c8h\u00031\tG.[4oK\u0012$\u0016.\\3!\u0003!iwnY6US6,W#A \u0011\u0005\u0001#U\"A!\u000b\u0005Q\u0011%BA\"\u001a\u0003\u0019\u0019w.\\7p]&\u0011Q)\u0011\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\u000bi\u0016\u001cHOR8mI\u0016\u0014X#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015AA5p\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\t\u0019KG.Z\u0001\fi\u0016\u001cHOR8mI\u0016\u0014\b%A\tti\u0006\u0014HoS1gW\u0006\u001cE.^:uKJ$\u0012\u0001\u0016\t\u0003EUK!AV\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0015a\u0003\"!\u00171\u000e\u0003iS!a\u0017/\u0002\u0007\u0005\u0004\u0018N\u0003\u0002^=\u00069!.\u001e9ji\u0016\u0014(BA0\u001e\u0003\u0015QWO\\5u\u0013\t\t'L\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001c\u001d;pa.\u000bgm[1DYV\u001cH/\u001a:)\u0005-!\u0007CA-f\u0013\t1'LA\u0005BMR,'/R1dQ\u00069r-\u001a;TiJ,\u0017-\\:D_:4\u0017nZ;sCRLwN\u001c\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A.T\u0001\u0005kRLG.\u0003\u0002oW\nQ\u0001K]8qKJ$\u0018.Z:\u00029\u001d,G/V:feJ+w-[8ogB\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\u0006Yr-\u001a;Vg\u0016\u00148\t\\5dWN\u0004&o\u001c3vG\u0016\u00148i\u001c8gS\u001e\f\u0011cZ3u\u0007>t7/^7fe\u000e{gNZ5h\u0003=\u0001(o\u001c3vG\u0016t5i\u001c8tk6,G#\u0003;\u0002\u000e\u0005E\u0011QCA\r!\rQWo^\u0005\u0003m.\u0014A\u0001T5tiB!\u00010_>:\u001b\u00059\u0012B\u0001>\u0018\u0005!YU-\u001f,bYV,\u0007c\u0001?\u0002\b9\u0019Q0a\u0001\u0011\u0005y\u001cS\"A@\u000b\u0007\u0005\u0005q$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000b\u0019\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!AB*ue&twMC\u0002\u0002\u0006\rBa!a\u0004\u0011\u0001\u0004Y\u0018aD;tKJ\u001cE.[2lgR{\u0007/[2\t\r\u0005M\u0001\u00031\u0001|\u0003A)8/\u001a:SK\u001eLwN\\:U_BL7\r\u0003\u0004\u0002\u0018A\u0001\ra_\u0001\f_V$\b/\u001e;U_BL7\rC\u0005\u0002\u001cA\u0001\n\u00111\u0001\u0002\u001e\u00059r/Y5u)&dGNU3d_J$7OU3dK&4X\r\u001a\t\u0004E\u0005}\u0011bAA\u0011G\t9!i\\8mK\u0006t\u0017!\u00079s_\u0012,8-\u001a(D_:\u001cX/\\3%I\u00164\u0017-\u001e7uIQ*\"!a\n+\t\u0005u\u0011\u0011F\u0016\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u0011QG\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0005=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001!!\u0010\u0002D\u0005\u0015\u0003cA-\u0002@%\u0019\u0011\u0011\t.\u0003\u0007Q\u000bw-A\u0003wC2,X-I\u00014\u0001")
public class StreamToTableJoinScalaIntegrationTestBase
implements StreamToTableJoinTestData {
    private final EmbeddedKafkaCluster cluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final File testFolder;
    private final String brokers;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final String outputTopic;
    private final String userClicksTopicJ;
    private final String userRegionsTopicJ;
    private final String outputTopicJ;
    private final Seq<KeyValue<String, Object>> userClicks;
    private final Seq<KeyValue<String, String>> userRegions;
    private final Seq<KeyValue<String, Object>> expectedClicksPerRegion;

    @Override
    public String brokers() {
        return this.brokers;
    }

    @Override
    public String userClicksTopic() {
        return this.userClicksTopic;
    }

    @Override
    public String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String userClicksTopicJ() {
        return this.userClicksTopicJ;
    }

    @Override
    public String userRegionsTopicJ() {
        return this.userRegionsTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public Seq<KeyValue<String, Object>> userClicks() {
        return this.userClicks;
    }

    @Override
    public Seq<KeyValue<String, String>> userRegions() {
        return this.userRegions;
    }

    @Override
    public Seq<KeyValue<String, Object>> expectedClicksPerRegion() {
        return this.expectedClicksPerRegion;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$brokers_$eq(String x$1) {
        this.brokers = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopic_$eq(String x$1) {
        this.userClicksTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopic_$eq(String x$1) {
        this.userRegionsTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopicJ_$eq(String x$1) {
        this.userClicksTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopicJ_$eq(String x$1) {
        this.userRegionsTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicks_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.userClicks = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegions_$eq(Seq<KeyValue<String, String>> x$1) {
        this.userRegions = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$expectedClicksPerRegion_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.expectedClicksPerRegion = x$1;
    }

    private EmbeddedKafkaCluster cluster() {
        return this.cluster;
    }

    private final long alignedTime() {
        return this.alignedTime;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private File testFolder() {
        return this.testFolder;
    }

    @BeforeEach
    public void startKafkaCluster() {
        this.cluster().start();
        this.cluster().createTopic(this.userClicksTopic());
        this.cluster().createTopic(this.userRegionsTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.userClicksTopicJ());
        this.cluster().createTopic(this.userRegionsTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @AfterEach
    public void stopKafkaCluster() {
        this.cluster().stop();
        Utils.delete((File)this.testFolder());
    }

    public Properties getStreamsConfiguration() {
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "stream-table-join-scala-integration-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "1000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getPath());
        return streamsConfiguration;
    }

    private Properties getUserRegionsProducerConfig() {
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return p;
    }

    private Properties getUserClicksProducerConfig() {
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", LongSerializer.class);
        return p;
    }

    private Properties getConsumerConfig() {
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "join-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return p;
    }

    public List<KeyValue<String, Object>> produceNConsume(String userClicksTopic, String userRegionsTopic, String outputTopic, boolean waitTillRecordsReceived) {
        Properties userRegionsProducerConfig = this.getUserRegionsProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userRegionsTopic, (Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.userRegions()).asJava()), (Properties)userRegionsProducerConfig, (Time)this.mockTime(), (boolean)false);
        Properties userClicksProducerConfig = this.getUserClicksProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userClicksTopic, (Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.userClicks()).asJava()), (Properties)userClicksProducerConfig, (Time)this.mockTime(), (boolean)false);
        if (waitTillRecordsReceived) {
            return IntegrationTestUtils.waitUntilFinalKeyValueRecordsReceived((Properties)this.getConsumerConfig(), (String)outputTopic, (List)((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.expectedClicksPerRegion()).asJava()));
        }
        return Collections.emptyList();
    }

    public boolean produceNConsume$default$4() {
        return true;
    }

    public StreamToTableJoinScalaIntegrationTestBase() {
        StreamToTableJoinTestData.$init$(this);
        this.cluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.testFolder = TestUtils.tempDirectory();
    }
}

