/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import java.time.Duration;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.internals.StreamJoinedInternal;
import org.apache.kafka.streams.scala.kstream.StreamJoined$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0002\u0004\u0001'!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)Q\u0006\u0001C\u0001=!)q\u0006\u0001C\u0001=\t\u00012\u000b\u001e:fC6Tu.\u001b8fIR+7\u000f\u001e\u0006\u0003\u000f!\tqa[:ue\u0016\fWN\u0003\u0002\n\u0015\u0005)1oY1mC*\u00111\u0002D\u0001\bgR\u0014X-Y7t\u0015\tia\"A\u0003lC\u001a\\\u0017M\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\f\u000e\u0003YQ\u0011!C\u0005\u00031Y\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0007\u0003\u0001\"Xm\u001d;De\u0016\fG/Z*ue\u0016\fWNS8j]\u0016$w+\u001b;i'\u0016\u0014H-Z:\u0015\u0003}\u0001\"!\u0006\u0011\n\u0005\u00052\"\u0001B+oSRD#AA\u0012\u0011\u0005\u0011ZS\"A\u0013\u000b\u0005\u0019:\u0013aA1qS*\u0011\u0001&K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ\u0003#A\u0003kk:LG/\u0003\u0002-K\t!A+Z:u\u0003E\"Xm\u001d;De\u0016\fG/Z*ue\u0016\fWNS8j]\u0016$w+\u001b;i'\u0016\u0014H-Z:B]\u0012\u001cFo\u001c:f'V\u0004\b\u000f\\5feND#aA\u0012\u0002cQ,7\u000f^\"sK\u0006$Xm\u0015;sK\u0006l'j\\5oK\u0012<\u0016\u000e\u001e5TKJ$Wm]!oIN#\u0018\r^3Ti>\u0014XMT1nK\"\u0012Aa\t")
public class StreamJoinedTest {
    @Test
    public void testCreateStreamJoinedWithSerdes() {
        StreamJoined streamJoined = StreamJoined$.MODULE$.with(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        StreamJoinedInternal streamJoinedInternal = new StreamJoinedInternal(streamJoined);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.valueSerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), streamJoinedInternal.otherValueSerde().getClass());
    }

    @Test
    public void testCreateStreamJoinedWithSerdesAndStoreSuppliers() {
        WindowBytesStoreSupplier storeSupplier = Stores.inMemoryWindowStore((String)"myStore", (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(250L), (boolean)false);
        WindowBytesStoreSupplier otherStoreSupplier = Stores.inMemoryWindowStore((String)"otherStore", (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(250L), (boolean)false);
        StreamJoined streamJoined = StreamJoined$.MODULE$.with(storeSupplier, otherStoreSupplier, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        StreamJoinedInternal streamJoinedInternal = new StreamJoinedInternal(streamJoined);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.valueSerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), streamJoinedInternal.otherValueSerde().getClass());
        Assertions.assertEquals((Object)otherStoreSupplier, (Object)streamJoinedInternal.otherStoreSupplier());
        Assertions.assertEquals((Object)storeSupplier, (Object)streamJoinedInternal.thisStoreSupplier());
    }

    @Test
    public void testCreateStreamJoinedWithSerdesAndStateStoreName() {
        StreamJoined streamJoined = StreamJoined$.MODULE$.as("myStoreName", Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        StreamJoinedInternal streamJoinedInternal = new StreamJoinedInternal(streamJoined);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), streamJoinedInternal.valueSerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), streamJoinedInternal.otherValueSerde().getClass());
        Assertions.assertEquals((Object)"myStoreName", (Object)streamJoinedInternal.storeName());
    }
}

