/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.CheckpointFile;

public class CommittedOffsetsFile {
    private static final int CURRENT_VERSION = 0;
    private static final String SEPARATOR = " ";
    private static final Pattern MINIMUM_ONE_WHITESPACE = Pattern.compile("\\s+");
    private final CheckpointFile<Map.Entry<Integer, Long>> checkpointFile;

    CommittedOffsetsFile(File offsetsFile) throws IOException {
        EntryFormatter formatter = new EntryFormatter();
        this.checkpointFile = new CheckpointFile(offsetsFile, 0, (CheckpointFile.EntryFormatter)formatter);
    }

    public synchronized void writeEntries(Map<Integer, Long> committedOffsets) throws IOException {
        this.checkpointFile.write(committedOffsets.entrySet());
    }

    public synchronized Map<Integer, Long> readEntries() throws IOException {
        List entries = this.checkpointFile.read();
        HashMap<Integer, Long> partitionToOffsets = new HashMap<Integer, Long>(entries.size());
        for (Map.Entry entry : entries) {
            Long existingValue = partitionToOffsets.put((Integer)entry.getKey(), (Long)entry.getValue());
            if (existingValue == null) continue;
            throw new IOException("Multiple entries exist for key: " + entry.getKey());
        }
        return partitionToOffsets;
    }

    private static class EntryFormatter
    implements CheckpointFile.EntryFormatter<Map.Entry<Integer, Long>> {
        private EntryFormatter() {
        }

        public String toString(Map.Entry<Integer, Long> entry) {
            return entry.getKey() + CommittedOffsetsFile.SEPARATOR + entry.getValue();
        }

        public Optional<Map.Entry<Integer, Long>> fromString(String line) {
            String[] strings = MINIMUM_ONE_WHITESPACE.split(line);
            if (strings.length != 2) {
                return Optional.empty();
            }
            try {
                return Optional.of(Utils.mkEntry((Object)Integer.parseInt(strings[0]), (Object)Long.parseLong(strings[1])));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
    }
}

