/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.utils;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class RecordsKeyValueMatcher<R1, R2, K, V>
extends TypeSafeDiagnosingMatcher<Collection<R2>> {
    private final Collection<R1> expectedRecords;
    private final TopicPartition topicPartition;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public RecordsKeyValueMatcher(Collection<R1> expectedRecords, TopicPartition topicPartition, Serde<K> keySerde, Serde<V> valueSerde) {
        this.expectedRecords = expectedRecords;
        this.topicPartition = topicPartition;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public void describeTo(Description description) {
        description.appendText("Records of ").appendValue((Object)this.topicPartition).appendText(": ").appendValue(this.expectedRecords);
    }

    protected boolean matchesSafely(Collection<R2> actualRecords, Description mismatchDescription) {
        if (this.expectedRecords.size() != actualRecords.size()) {
            mismatchDescription.appendText("Number of records differ. Expected: ").appendValue((Object)this.expectedRecords.size()).appendText(", Actual: ").appendValue((Object)actualRecords.size()).appendText("; ");
            return false;
        }
        Iterator<R1> expectedIterator = this.expectedRecords.iterator();
        Iterator<R2> actualIterator = actualRecords.iterator();
        while (expectedIterator.hasNext() && actualIterator.hasNext()) {
            R2 actual;
            R1 expected = expectedIterator.next();
            if (this.matches(expected, actual = actualIterator.next(), mismatchDescription)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(R1 expected, R2 actual, Description mismatchDescription) {
        SimpleRecord expectedRecord = this.convert(expected);
        SimpleRecord actualRecord = this.convert(actual);
        if (expectedRecord == null) {
            mismatchDescription.appendText("Invalid expected record type: ").appendValue((Object)expected.getClass().getSimpleName());
            return false;
        }
        if (actualRecord == null) {
            mismatchDescription.appendText("Invalid actual record type: ").appendValue((Object)actual.getClass().getSimpleName());
            return false;
        }
        return this.compare(expectedRecord.key(), actualRecord.key(), this.keySerde.deserializer(), "Record key", mismatchDescription) && this.compare(expectedRecord.value(), actualRecord.value(), this.valueSerde.deserializer(), "Record value", mismatchDescription);
    }

    private boolean compare(ByteBuffer lhs, ByteBuffer rhs, Deserializer<?> deserializer, String desc, Description mismatchDescription) {
        if (lhs != null && !lhs.equals(rhs) || lhs == null && rhs != null) {
            mismatchDescription.appendText(desc).appendText(" mismatch. Expected: ").appendValue(deserializer.deserialize(this.topicPartition.topic(), Utils.toNullableArray((ByteBuffer)lhs))).appendText("; Actual: ").appendValue(deserializer.deserialize(this.topicPartition.topic(), Utils.toNullableArray((ByteBuffer)rhs))).appendText("; ");
            return false;
        }
        return true;
    }

    private SimpleRecord convert(Object recordCandidate) {
        if (recordCandidate instanceof ProducerRecord) {
            ProducerRecord record = (ProducerRecord)recordCandidate;
            long timestamp = record.timestamp() != null ? record.timestamp() : -1L;
            ByteBuffer keyBytes = Utils.wrapNullable((byte[])this.keySerde.serializer().serialize(this.topicPartition.topic(), record.key()));
            ByteBuffer valueBytes = Utils.wrapNullable((byte[])this.valueSerde.serializer().serialize(this.topicPartition.topic(), record.value()));
            Header[] headers = record.headers() != null ? record.headers().toArray() : Record.EMPTY_HEADERS;
            return new SimpleRecord(timestamp, keyBytes, valueBytes, headers);
        }
        if (recordCandidate instanceof ConsumerRecord) {
            ConsumerRecord record = (ConsumerRecord)recordCandidate;
            ByteBuffer keyBytes = Utils.wrapNullable((byte[])this.keySerde.serializer().serialize(this.topicPartition.topic(), record.key()));
            ByteBuffer valueBytes = Utils.wrapNullable((byte[])this.valueSerde.serializer().serialize(this.topicPartition.topic(), record.value()));
            Header[] headers = record.headers() != null ? record.headers().toArray() : Record.EMPTY_HEADERS;
            return new SimpleRecord(record.timestamp(), keyBytes, valueBytes, headers);
        }
        if (recordCandidate instanceof Record) {
            Record record = (Record)recordCandidate;
            return new SimpleRecord(record.timestamp(), record.key(), record.value(), record.headers());
        }
        return null;
    }

    public static <R1, R2, K, V> RecordsKeyValueMatcher<R1, R2, K, V> correspondTo(Collection<R1> expectedRecords, TopicPartition topicPartition, Serde<K> keySerde, Serde<V> valueSerde) {
        return new RecordsKeyValueMatcher<R1, R2, K, V>(expectedRecords, topicPartition, keySerde, valueSerde);
    }
}

