/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public final class ReassignReplicaShrinkTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 2;
    }

    @Override
    public int numRemoteLogMetadataPartitions() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        Integer broker1 = 1;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer p1 = 1;
        Integer partitionCount = 2;
        Integer replicationFactor = 2;
        Integer maxBatchCountPerSegment = 1;
        boolean enableRemoteLogStorage = true;
        Map replicaAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)p0, Arrays.asList(broker0, broker1)), Utils.mkEntry((Object)p1, Arrays.asList(broker1, broker0))});
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, replicaAssignment, true).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 2L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).expectSegmentToBeOffloaded(broker1, "topicA", p1, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker1, "topicA", p1, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p1, 2L).produce("topicA", p1, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).shrinkReplica("topicA", p0, Collections.singletonList(broker1)).shrinkReplica("topicA", p1, Collections.singletonList(broker0)).expectLeader("topicA", p0, broker1, false).expectLeader("topicA", p1, broker0, false).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 3L).produce("topicA", p0, new KeyValueSpec("k3", "v3")).expectEarliestLocalOffsetInLogDirectory("topicA", p1, 3L).produce("topicA", p1, new KeyValueSpec("k3", "v3")).expectFetchFromTieredStorage(broker1, "topicA", p0, 3).consume("topicA", p0, 0L, 4, 3).expectFetchFromTieredStorage(broker0, "topicA", p1, 3).consume("topicA", p1, 0L, 4, 3);
    }
}

