/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.List;
import java.util.Map;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public final class OffloadAndConsumeFromLeaderTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 1;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker = 0;
        String topicA = "topicA";
        String topicB = "topicB";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 1;
        Integer oneBatchPerSegment = 1;
        Integer twoBatchPerSegment = 2;
        Map<Integer, List<Integer>> replicaAssignment = null;
        boolean enableRemoteLogStorage = true;
        builder.createTopic("topicA", partitionCount, replicationFactor, oneBatchPerSegment, replicaAssignment, true).expectSegmentToBeOffloaded(broker, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 2L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).createTopic("topicB", partitionCount, replicationFactor, twoBatchPerSegment, replicaAssignment, true).expectEarliestLocalOffsetInLogDirectory("topicB", p0, 4L).expectSegmentToBeOffloaded(broker, "topicB", p0, 0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1")).expectSegmentToBeOffloaded(broker, "topicB", p0, 2, new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3")).produce("topicB", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3"), new KeyValueSpec("k4", "v4")).bounce(broker).expectFetchFromTieredStorage(broker, "topicA", p0, 1).consume("topicA", p0, 1L, 2, 1).expectFetchFromTieredStorage(broker, "topicB", p0, 2).consume("topicB", p0, 1L, 4, 3);
    }
}

