/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageSnapshot;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;
import org.junit.jupiter.api.Assertions;

public final class ExpectTopicIdToMatchInRemoteStorageAction
implements TieredStorageTestAction {
    private final String topic;

    public ExpectTopicIdToMatchInRemoteStorageAction(String topic) {
        this.topic = topic;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        Uuid topicId = TieredStorageTestUtils.describeTopic(context, this.topic).topicId();
        context.remoteStorageManagers().forEach(rsm -> {
            LocalTieredStorageSnapshot snapshot = LocalTieredStorageSnapshot.takeSnapshot(rsm);
            List<TopicPartition> partitions = snapshot.getTopicPartitions().stream().filter(tp -> tp.topic().equals(this.topic)).collect(Collectors.toList());
            partitions.forEach(partition -> snapshot.getFilesets((TopicPartition)partition).forEach(fileset -> Assertions.assertEquals((Object)topicId, (Object)fileset.getRemoteLogSegmentId().id())));
        });
    }

    @Override
    public void describe(PrintStream output) {
        output.println("expect-topic-id-to-match-in-remote-storage: " + this.topic);
    }
}

