/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageSnapshot;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;

public final class ExpectEmptyRemoteStorageAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;

    public ExpectEmptyRemoteStorageAction(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            LocalTieredStorageSnapshot snapshot = context.takeTieredStorageSnapshot();
            return snapshot.getFilesets(this.topicPartition).isEmpty();
        }, (long)2000L, (String)("Remote storage is not empty for " + this.topicPartition));
    }

    @Override
    public void describe(PrintStream output) {
        output.println("expect-empty-remote-storage topic-partition: " + this.topicPartition);
    }
}

