/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataUpdateTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class RemoteLogSegmentMetadataUpdateTransformTest {
    RemoteLogSegmentMetadataUpdateTransformTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testToAndFromMessage(Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata) {
        HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
        segmentLeaderEpochs.put(0, 0L);
        RemoteLogSegmentMetadataUpdate metadataUpdate = new RemoteLogSegmentMetadataUpdate(new RemoteLogSegmentId(new TopicIdPartition(Uuid.randomUuid(), 0, "topic"), Uuid.randomUuid()), 123L, customMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
        RemoteLogSegmentMetadataUpdateTransform transform = new RemoteLogSegmentMetadataUpdateTransform();
        ApiMessageAndVersion message = transform.toApiMessageAndVersion(metadataUpdate);
        Assertions.assertEquals((Object)metadataUpdate, (Object)transform.fromApiMessageAndVersion(message));
    }

    private static Stream<Object> parameters() {
        return Stream.of(Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[0])), Optional.empty());
    }
}

