/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;

public final class UpdateTopicConfigAction
implements TieredStorageTestAction {
    private final String topic;
    private final Map<String, String> configsToBeAdded;
    private final List<String> configsToBeDeleted;

    public UpdateTopicConfigAction(String topic, Map<String, String> configsToBeAdded, List<String> configsToBeDeleted) {
        this.topic = topic;
        this.configsToBeAdded = configsToBeAdded;
        this.configsToBeDeleted = configsToBeDeleted;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws ExecutionException, InterruptedException, TimeoutException {
        context.updateTopicConfig(this.topic, this.configsToBeAdded, this.configsToBeDeleted);
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("update topic config: %s, configs-to-be-added: %s, configs-to-be-deleted: %s%n", this.topic, this.configsToBeAdded, this.configsToBeDeleted);
    }
}

