/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;
import org.junit.jupiter.api.Assertions;

public final class ExpectUserTopicMappedToMetadataPartitionsAction
implements TieredStorageTestAction {
    private final String topic;
    private final List<Integer> metadataPartitions;

    public ExpectUserTopicMappedToMetadataPartitionsAction(String topic, List<Integer> metadataPartitions) {
        this.topic = topic;
        this.metadataPartitions = metadataPartitions;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        String metadataTopic = "__remote_log_metadata";
        Map<String, TopicDescription> descriptions = TieredStorageTestUtils.describeTopics(context, Arrays.asList(this.topic, metadataTopic));
        int metadataTopicPartitionCount = descriptions.get(metadataTopic).partitions().size();
        RemoteLogMetadataTopicPartitioner partitioner = new RemoteLogMetadataTopicPartitioner(metadataTopicPartitionCount);
        Uuid topicId = descriptions.get(this.topic).topicId();
        Set actualMetadataPartitions = descriptions.get(this.topic).partitions().stream().map(info -> new TopicIdPartition(topicId, new TopicPartition(this.topic, info.partition()))).map(arg_0 -> ((RemoteLogMetadataTopicPartitioner)partitioner).metadataPartition(arg_0)).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)actualMetadataPartitions.containsAll(this.metadataPartitions), () -> "metadata-partition distribution expected: " + this.metadataPartitions + ", actual: " + actualMetadataPartitions);
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("expect-user-topic-mapped-to-metadata-partitions topic: %s metadata-partitions: %s%n", this.topic, this.metadataPartitions);
    }
}

