/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.actions.BounceBrokerAction;
import org.apache.kafka.tiered.storage.actions.ConsumeAction;
import org.apache.kafka.tiered.storage.actions.CreatePartitionsAction;
import org.apache.kafka.tiered.storage.actions.CreateTopicAction;
import org.apache.kafka.tiered.storage.actions.DeleteRecordsAction;
import org.apache.kafka.tiered.storage.actions.DeleteTopicAction;
import org.apache.kafka.tiered.storage.actions.EraseBrokerStorageAction;
import org.apache.kafka.tiered.storage.actions.ExpectBrokerInISRAction;
import org.apache.kafka.tiered.storage.actions.ExpectEmptyRemoteStorageAction;
import org.apache.kafka.tiered.storage.actions.ExpectLeaderAction;
import org.apache.kafka.tiered.storage.actions.ExpectLeaderEpochCheckpointAction;
import org.apache.kafka.tiered.storage.actions.ExpectListOffsetsAction;
import org.apache.kafka.tiered.storage.actions.ExpectTopicIdToMatchInRemoteStorageAction;
import org.apache.kafka.tiered.storage.actions.ExpectUserTopicMappedToMetadataPartitionsAction;
import org.apache.kafka.tiered.storage.actions.ProduceAction;
import org.apache.kafka.tiered.storage.actions.ReassignReplicaAction;
import org.apache.kafka.tiered.storage.actions.ShrinkReplicaAction;
import org.apache.kafka.tiered.storage.actions.StartBrokerAction;
import org.apache.kafka.tiered.storage.actions.StopBrokerAction;
import org.apache.kafka.tiered.storage.actions.UpdateBrokerConfigAction;
import org.apache.kafka.tiered.storage.actions.UpdateTopicConfigAction;
import org.apache.kafka.tiered.storage.specs.ConsumableSpec;
import org.apache.kafka.tiered.storage.specs.DeletableSpec;
import org.apache.kafka.tiered.storage.specs.ExpandPartitionCountSpec;
import org.apache.kafka.tiered.storage.specs.FetchableSpec;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;
import org.apache.kafka.tiered.storage.specs.OffloadableSpec;
import org.apache.kafka.tiered.storage.specs.OffloadedSegmentSpec;
import org.apache.kafka.tiered.storage.specs.ProducableSpec;
import org.apache.kafka.tiered.storage.specs.RemoteDeleteSegmentSpec;
import org.apache.kafka.tiered.storage.specs.RemoteFetchSpec;
import org.apache.kafka.tiered.storage.specs.TopicSpec;
import org.junit.jupiter.api.Assertions;

public final class TieredStorageTestBuilder {
    private final int defaultProducedBatchSize = 1;
    private final long defaultEarliestLocalOffsetExpectedInLogDirectory = 0L;
    private Map<TopicPartition, ProducableSpec> producables = new HashMap<TopicPartition, ProducableSpec>();
    private Map<TopicPartition, List<OffloadableSpec>> offloadables = new HashMap<TopicPartition, List<OffloadableSpec>>();
    private Map<TopicPartition, ConsumableSpec> consumables = new HashMap<TopicPartition, ConsumableSpec>();
    private Map<TopicPartition, FetchableSpec> fetchables = new HashMap<TopicPartition, FetchableSpec>();
    private Map<TopicPartition, List<DeletableSpec>> deletables = new HashMap<TopicPartition, List<DeletableSpec>>();
    private List<TieredStorageTestAction> actions = new ArrayList<TieredStorageTestAction>();

    public TieredStorageTestBuilder createTopic(String topic, Integer partitionCount, Integer replicationFactor, Integer maxBatchCountPerSegment, Map<Integer, List<Integer>> replicaAssignment, Boolean enableRemoteLogStorage) {
        Assertions.assertTrue((maxBatchCountPerSegment >= 1 ? 1 : 0) != 0, (String)("Segments size for topic " + topic + " needs to be >= 1"));
        Assertions.assertTrue((partitionCount >= 1 ? 1 : 0) != 0, (String)("Partition count for topic " + topic + " needs to be >= 1"));
        Assertions.assertTrue((replicationFactor >= 1 ? 1 : 0) != 0, (String)("Replication factor for topic " + topic + " needs to be >= 1"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("remote.storage.enable", enableRemoteLogStorage.toString());
        TopicSpec topicSpec = new TopicSpec(topic, partitionCount, replicationFactor, maxBatchCountPerSegment, replicaAssignment, properties);
        this.actions.add(new CreateTopicAction(topicSpec));
        return this;
    }

    public TieredStorageTestBuilder createPartitions(String topic, Integer partitionCount, Map<Integer, List<Integer>> replicaAssignment) {
        Assertions.assertTrue((partitionCount >= 1 ? 1 : 0) != 0, (String)("Partition count for topic " + topic + " needs to be >= 1"));
        ExpandPartitionCountSpec spec = new ExpandPartitionCountSpec(topic, partitionCount, replicaAssignment);
        this.actions.add(new CreatePartitionsAction(spec));
        return this;
    }

    public TieredStorageTestBuilder updateTopicConfig(String topic, Map<String, String> configsToBeAdded, List<String> configsToBeDeleted) {
        Assertions.assertTrue((!configsToBeAdded.isEmpty() || !configsToBeDeleted.isEmpty() ? 1 : 0) != 0, (String)("Topic " + topic + " configs shouldn't be empty"));
        this.actions.add(new UpdateTopicConfigAction(topic, configsToBeAdded, configsToBeDeleted));
        return this;
    }

    public TieredStorageTestBuilder updateBrokerConfig(Integer brokerId, Map<String, String> configsToBeAdded, List<String> configsToBeDeleted) {
        Assertions.assertTrue((!configsToBeAdded.isEmpty() || !configsToBeDeleted.isEmpty() ? 1 : 0) != 0, (String)("Broker " + brokerId + " configs shouldn't be empty"));
        this.actions.add(new UpdateBrokerConfigAction(brokerId, configsToBeAdded, configsToBeDeleted));
        return this;
    }

    public TieredStorageTestBuilder deleteTopic(List<String> topics) {
        topics.forEach(topic -> this.actions.add(this.buildDeleteTopicAction((String)topic, true)));
        return this;
    }

    public TieredStorageTestBuilder produce(String topic, Integer partition, KeyValueSpec ... keyValues) {
        Assertions.assertTrue((partition >= 0 ? 1 : 0) != 0, (String)"Partition must be >= 0");
        ProducableSpec spec = this.getOrCreateProducable(topic, partition);
        for (KeyValueSpec kv : keyValues) {
            spec.getRecords().add((ProducerRecord<String, String>)new ProducerRecord(topic, partition, (Object)kv.getKey(), (Object)kv.getValue()));
        }
        this.createProduceAction();
        return this;
    }

    public TieredStorageTestBuilder produceWithTimestamp(String topic, Integer partition, KeyValueSpec ... keyValues) {
        Assertions.assertTrue((partition >= 0 ? 1 : 0) != 0, (String)"Partition must be >= 0");
        ProducableSpec spec = this.getOrCreateProducable(topic, partition);
        for (KeyValueSpec kv : keyValues) {
            spec.getRecords().add((ProducerRecord<String, String>)new ProducerRecord(topic, partition, kv.getTimestamp(), (Object)kv.getKey(), (Object)kv.getValue()));
        }
        this.createProduceAction();
        return this;
    }

    public TieredStorageTestBuilder withBatchSize(String topic, Integer partition, Integer batchSize) {
        Assertions.assertTrue((batchSize >= 1 ? 1 : 0) != 0, (String)"The size of a batch of produced records must >= 1");
        this.getOrCreateProducable(topic, partition).setBatchSize(batchSize);
        return this;
    }

    public TieredStorageTestBuilder expectEarliestLocalOffsetInLogDirectory(String topic, Integer partition, Long earliestLocalOffset) {
        Assertions.assertTrue((earliestLocalOffset >= 0L ? 1 : 0) != 0, (String)"Record offset must be >= 0");
        this.getOrCreateProducable(topic, partition).setEarliestLocalLogOffset(earliestLocalOffset);
        return this;
    }

    public TieredStorageTestBuilder expectSegmentToBeOffloaded(Integer fromBroker, String topic, Integer partition, Integer baseOffset, KeyValueSpec ... keyValues) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        ArrayList<ProducerRecord<String, String>> records = new ArrayList<ProducerRecord<String, String>>();
        for (KeyValueSpec kv : keyValues) {
            records.add((ProducerRecord<String, String>)new ProducerRecord(topic, partition, (Object)kv.getKey(), (Object)kv.getValue()));
        }
        this.offloadables.computeIfAbsent(topicPartition, k -> new ArrayList()).add(new OffloadableSpec(fromBroker, baseOffset, records));
        return this;
    }

    public TieredStorageTestBuilder expectTopicIdToMatchInRemoteStorage(String topic) {
        this.actions.add(new ExpectTopicIdToMatchInRemoteStorageAction(topic));
        return this;
    }

    public TieredStorageTestBuilder consume(String topic, Integer partition, Long fetchOffset, Integer expectedTotalRecord, Integer expectedRecordsFromSecondTier) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        Assertions.assertTrue((partition >= 0 ? 1 : 0) != 0, (String)"Partition must be >= 0");
        Assertions.assertTrue((fetchOffset >= 0L ? 1 : 0) != 0, (String)"Fetch offset must be >=0");
        Assertions.assertTrue((expectedTotalRecord >= 1 ? 1 : 0) != 0, (String)"Must read at least one record");
        Assertions.assertTrue((expectedRecordsFromSecondTier >= 0 ? 1 : 0) != 0, (String)"Expected read cannot be < 0");
        Assertions.assertTrue((expectedRecordsFromSecondTier <= expectedTotalRecord ? 1 : 0) != 0, (String)"Cannot fetch more records than consumed");
        Assertions.assertFalse((boolean)this.consumables.containsKey(topicPartition), (String)("Consume already in progress for " + topicPartition));
        this.consumables.put(topicPartition, new ConsumableSpec(fetchOffset, expectedTotalRecord, expectedRecordsFromSecondTier));
        this.createConsumeAction();
        return this;
    }

    public TieredStorageTestBuilder expectLeader(String topic, Integer partition, Integer brokerId, Boolean electLeader) {
        this.actions.add(new ExpectLeaderAction(new TopicPartition(topic, partition.intValue()), brokerId, electLeader));
        return this;
    }

    public TieredStorageTestBuilder expectInIsr(String topic, Integer partition, Integer brokerId) {
        this.actions.add(new ExpectBrokerInISRAction(new TopicPartition(topic, partition.intValue()), brokerId));
        return this;
    }

    public TieredStorageTestBuilder expectFetchFromTieredStorage(Integer fromBroker, String topic, Integer partition, Integer remoteFetchRequestCount) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        Assertions.assertTrue((partition >= 0 ? 1 : 0) != 0, (String)"Partition must be >= 0");
        Assertions.assertTrue((remoteFetchRequestCount >= 0 ? 1 : 0) != 0, (String)"Expected fetch count from tiered storage must be >= 0");
        Assertions.assertFalse((boolean)this.fetchables.containsKey(topicPartition), (String)("Consume already in progress for " + topicPartition));
        this.fetchables.put(topicPartition, new FetchableSpec(fromBroker, remoteFetchRequestCount));
        return this;
    }

    public TieredStorageTestBuilder expectDeletionInRemoteStorage(Integer fromBroker, String topic, Integer partition, LocalTieredStorageEvent.EventType eventType, Integer eventCount) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.deletables.computeIfAbsent(topicPartition, k -> new ArrayList()).add(new DeletableSpec(fromBroker, eventType, eventCount));
        return this;
    }

    public TieredStorageTestBuilder waitForRemoteLogSegmentDeletion(String topic) {
        this.actions.add(this.buildDeleteTopicAction(topic, false));
        return this;
    }

    public TieredStorageTestBuilder expectLeaderEpochCheckpoint(Integer brokerId, String topic, Integer partition, Integer beginEpoch, Long startOffset) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new ExpectLeaderEpochCheckpointAction(brokerId, topicPartition, beginEpoch, startOffset));
        return this;
    }

    public TieredStorageTestBuilder expectListOffsets(String topic, Integer partition, OffsetSpec offsetSpec, EpochEntry epochEntry) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new ExpectListOffsetsAction(topicPartition, offsetSpec, epochEntry));
        return this;
    }

    public TieredStorageTestBuilder bounce(Integer brokerId) {
        this.actions.add(new BounceBrokerAction(brokerId));
        return this;
    }

    public TieredStorageTestBuilder stop(Integer brokerId) {
        this.actions.add(new StopBrokerAction(brokerId));
        return this;
    }

    public TieredStorageTestBuilder start(Integer brokerId) {
        this.actions.add(new StartBrokerAction(brokerId));
        return this;
    }

    public TieredStorageTestBuilder eraseBrokerStorage(Integer brokerId) {
        this.actions.add(new EraseBrokerStorageAction(brokerId));
        return this;
    }

    public TieredStorageTestBuilder expectEmptyRemoteStorage(String topic, Integer partition) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new ExpectEmptyRemoteStorageAction(topicPartition));
        return this;
    }

    public TieredStorageTestBuilder shrinkReplica(String topic, Integer partition, List<Integer> replicaIds) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new ShrinkReplicaAction(topicPartition, replicaIds));
        return this;
    }

    public TieredStorageTestBuilder reassignReplica(String topic, Integer partition, List<Integer> replicaIds) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new ReassignReplicaAction(topicPartition, replicaIds));
        return this;
    }

    public TieredStorageTestBuilder expectUserTopicMappedToMetadataPartitions(String topic, List<Integer> metadataPartitions) {
        this.actions.add(new ExpectUserTopicMappedToMetadataPartitionsAction(topic, metadataPartitions));
        return this;
    }

    public TieredStorageTestBuilder deleteRecords(String topic, Integer partition, Long beforeOffset) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.actions.add(new DeleteRecordsAction(topicPartition, beforeOffset, this.buildDeleteSegmentSpecList(topic)));
        return this;
    }

    public List<TieredStorageTestAction> complete() {
        return this.actions;
    }

    private void createProduceAction() {
        if (!this.producables.isEmpty()) {
            this.producables.forEach((topicPartition, producableSpec) -> {
                ArrayList<ProducerRecord<String, String>> recordsToProduce = new ArrayList<ProducerRecord<String, String>>(producableSpec.getRecords());
                List<OffloadedSegmentSpec> offloadedSegmentSpecs = this.offloadables.computeIfAbsent((TopicPartition)topicPartition, k -> new ArrayList()).stream().map(spec -> new OffloadedSegmentSpec(spec.getSourceBrokerId(), (TopicPartition)topicPartition, spec.getBaseOffset(), spec.getRecords())).collect(Collectors.toList());
                ProduceAction action = new ProduceAction((TopicPartition)topicPartition, offloadedSegmentSpecs, (List<ProducerRecord<String, String>>)recordsToProduce, producableSpec.getBatchSize(), producableSpec.getEarliestLocalLogOffset());
                this.actions.add(action);
            });
            this.producables = new HashMap<TopicPartition, ProducableSpec>();
            this.offloadables = new HashMap<TopicPartition, List<OffloadableSpec>>();
        }
    }

    private void createConsumeAction() {
        if (!this.consumables.isEmpty()) {
            this.consumables.forEach((topicPartition, consumableSpec) -> {
                FetchableSpec fetchableSpec = this.fetchables.computeIfAbsent((TopicPartition)topicPartition, k -> new FetchableSpec(0, 0));
                RemoteFetchSpec remoteFetchSpec = new RemoteFetchSpec(fetchableSpec.getSourceBrokerId(), (TopicPartition)topicPartition, fetchableSpec.getFetchCount());
                ConsumeAction action = new ConsumeAction((TopicPartition)topicPartition, consumableSpec.getFetchOffset(), consumableSpec.getExpectedTotalCount(), consumableSpec.getExpectedFromSecondTierCount(), remoteFetchSpec);
                this.actions.add(action);
            });
            this.consumables = new HashMap<TopicPartition, ConsumableSpec>();
            this.fetchables = new HashMap<TopicPartition, FetchableSpec>();
        }
    }

    private ProducableSpec getOrCreateProducable(String topic, Integer partition) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        return this.producables.computeIfAbsent(topicPartition, k -> new ProducableSpec(new ArrayList<ProducerRecord<String, String>>(), 1, 0L));
    }

    private DeleteTopicAction buildDeleteTopicAction(String topic, Boolean shouldDelete) {
        return new DeleteTopicAction(topic, this.buildDeleteSegmentSpecList(topic), shouldDelete);
    }

    private List<RemoteDeleteSegmentSpec> buildDeleteSegmentSpecList(String topic) {
        List<RemoteDeleteSegmentSpec> deleteSegmentSpecList = this.deletables.entrySet().stream().filter(e -> ((TopicPartition)e.getKey()).topic().equals(topic)).flatMap(e -> {
            TopicPartition partition = (TopicPartition)e.getKey();
            List deletableSpecs = (List)e.getValue();
            return deletableSpecs.stream().map(spec -> new RemoteDeleteSegmentSpec(spec.getSourceBrokerId(), partition, spec.getEventType(), spec.getEventCount()));
        }).collect(Collectors.toList());
        deleteSegmentSpecList.forEach(spec -> this.deletables.remove(spec.getTopicPartition()));
        return deleteSegmentSpecList;
    }
}

