/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Random;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.RequestManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestManagerTest {
    private final MockTime time = new MockTime();
    private final int requestTimeoutMs = 30000;
    private final int retryBackoffMs = 100;
    private final Random random = new Random(1L);

    @Test
    public void testResetAllConnections() {
        RequestManager cache = new RequestManager(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 100, 30000, this.random);
        RequestManager.ConnectionState connectionState1 = cache.getOrCreate(1);
        connectionState1.onRequestSent(1L, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState1.isReady(this.time.milliseconds()));
        RequestManager.ConnectionState connectionState2 = cache.getOrCreate(2);
        connectionState2.onRequestSent(2L, this.time.milliseconds());
        connectionState2.onResponseError(2L, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState2.isReady(this.time.milliseconds()));
        cache.resetAll();
        Assertions.assertTrue((boolean)connectionState1.isReady(this.time.milliseconds()));
        Assertions.assertTrue((boolean)connectionState2.isReady(this.time.milliseconds()));
    }

    @Test
    public void testBackoffAfterFailure() {
        RequestManager cache = new RequestManager(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 100, 30000, this.random);
        RequestManager.ConnectionState connectionState = cache.getOrCreate(1);
        Assertions.assertTrue((boolean)connectionState.isReady(this.time.milliseconds()));
        long correlationId = 1L;
        connectionState.onRequestSent(correlationId, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        connectionState.onResponseError(correlationId, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        this.time.sleep(100L);
        Assertions.assertTrue((boolean)connectionState.isReady(this.time.milliseconds()));
    }

    @Test
    public void testSuccessfulResponse() {
        RequestManager cache = new RequestManager(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 100, 30000, this.random);
        RequestManager.ConnectionState connectionState = cache.getOrCreate(1);
        long correlationId = 1L;
        connectionState.onRequestSent(correlationId, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        connectionState.onResponseReceived(correlationId);
        Assertions.assertTrue((boolean)connectionState.isReady(this.time.milliseconds()));
    }

    @Test
    public void testIgnoreUnexpectedResponse() {
        RequestManager cache = new RequestManager(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 100, 30000, this.random);
        RequestManager.ConnectionState connectionState = cache.getOrCreate(1);
        long correlationId = 1L;
        connectionState.onRequestSent(correlationId, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        connectionState.onResponseReceived(correlationId + 1L);
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
    }

    @Test
    public void testRequestTimeout() {
        RequestManager cache = new RequestManager(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 100, 30000, this.random);
        RequestManager.ConnectionState connectionState = cache.getOrCreate(1);
        long correlationId = 1L;
        connectionState.onRequestSent(correlationId, this.time.milliseconds());
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        this.time.sleep(29999L);
        Assertions.assertFalse((boolean)connectionState.isReady(this.time.milliseconds()));
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)connectionState.isReady(this.time.milliseconds()));
    }
}

