/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.raft.MockExpirationService;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MockExpirationServiceTest {
    private final MockTime time = new MockTime();
    private final MockExpirationService expirationService = new MockExpirationService(this.time);

    MockExpirationServiceTest() {
    }

    @Test
    public void testFailAfter() {
        CompletableFuture future1 = this.expirationService.failAfter(50L);
        CompletableFuture future2 = this.expirationService.failAfter(25L);
        CompletableFuture future3 = this.expirationService.failAfter(75L);
        CompletableFuture future4 = this.expirationService.failAfter(50L);
        this.time.sleep(25L);
        TestUtils.assertFutureThrows(future2, TimeoutException.class);
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        Assertions.assertFalse((boolean)future4.isDone());
        this.time.sleep(25L);
        TestUtils.assertFutureThrows(future1, TimeoutException.class);
        TestUtils.assertFutureThrows(future4, TimeoutException.class);
        Assertions.assertFalse((boolean)future3.isDone());
        this.time.sleep(25L);
        TestUtils.assertFutureThrows(future3, TimeoutException.class);
    }
}

