/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Optional;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.controller.ActivationRecordsGenerator;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivationRecordsGeneratorTest {
    @Test
    public void testActivationMessageForEmptyLog() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) at metadata.version 3.0-IV1 from bootstrap source 'test'.", (Object)logMsg), (long)-1L, (boolean)false, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (String)"test"), (MetadataVersion)MetadataVersion.MINIMUM_KRAFT_VERSION);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) at metadata.version 3.4-IV0 from bootstrap source 'test'. Setting the ZK migration state to NONE since this is a de-novo KRaft cluster.", (Object)logMsg), (long)-1L, (boolean)false, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)2, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) at metadata.version 3.4-IV0 from bootstrap source 'test'. Putting the controller into pre-migration mode. No metadata updates will be allowed until the ZK metadata has been migrated.", (Object)logMsg), (long)-1L, (boolean)true, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)2, (int)result.records().size());
        Assertions.assertEquals((Object)"The bootstrap metadata.version 3.3-IV2 does not support ZK migrations. Cannot continue with ZK migrations enabled.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.fail(), (long)-1L, (boolean)true, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_3_IV2, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_3_IV2))).getMessage());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) in metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'. Setting the ZK migration state to NONE since this is a de-novo KRaft cluster.", (Object)logMsg), (long)-1L, (boolean)false, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)4, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) in metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'. Putting the controller into pre-migration mode. No metadata updates will be allowed until the ZK metadata has been migrated.", (Object)logMsg), (long)-1L, (boolean)true, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)4, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting partial bootstrap records transaction at offset 0. Re-appending 1 bootstrap record(s) in new metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'. Setting the ZK migration state to NONE since this is a de-novo KRaft cluster.", (Object)logMsg), (long)0L, (boolean)false, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)5, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting partial bootstrap records transaction at offset 0. Re-appending 1 bootstrap record(s) in new metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'. Putting the controller into pre-migration mode. No metadata updates will be allowed until the ZK metadata has been migrated.", (Object)logMsg), (long)0L, (boolean)true, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)5, (int)result.records().size());
        Assertions.assertEquals((Object)"Detected partial bootstrap records transaction at 0, but the metadata.version 3.6-IV0 does not support transactions. Cannot continue.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"", (Object)logMsg), (long)0L, (boolean)true, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV0, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV0))).getMessage());
    }

    FeatureControlManager buildFeatureControl(MetadataVersion metadataVersion, Optional<ZkMigrationState> zkMigrationState) {
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setMetadataVersion(metadataVersion).build();
        zkMigrationState.ifPresent(migrationState -> featureControl.replay((ZkMigrationStateRecord)migrationState.toRecord().message()));
        return featureControl;
    }

    @Test
    public void testActivationMessageForNonEmptyLogNoMigrations() {
        ControllerResult result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. No metadata.version feature level record was found in the log. Treating the log as version 3.0-IV1.", (Object)logMsg), (long)-1L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.MINIMUM_KRAFT_VERSION, Optional.empty()), (MetadataVersion)MetadataVersion.MINIMUM_KRAFT_VERSION);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation.", (Object)logMsg), (long)-1L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_3_IV0, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_3_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of NONE.", (Object)logMsg), (long)-1L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting in-progress metadata transaction at offset 42. Loaded ZK migration state of NONE.", (Object)logMsg), (long)42L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV1, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertEquals((Object)"Detected in-progress transaction at offset 42, but the metadata.version 3.6-IV0 does not support transactions. Cannot continue.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.fail(), (long)42L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV0, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_6_IV0))).getMessage());
    }

    @Test
    public void testActivationMessageForNonEmptyLogWithMigrations() {
        Assertions.assertEquals((Object)"Should not have ZK migrations enabled on a cluster running metadata.version 3.3-IV0", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.fail(), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_3_IV0, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_3_IV0))).getMessage());
        Assertions.assertEquals((Object)"Should not have ZK migrations enabled on a cluster that was created in KRaft mode.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.fail(), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.empty()), (MetadataVersion)MetadataVersion.IBP_3_4_IV0))).getMessage());
        ControllerResult result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of PRE_MIGRATION. Activating pre-migration controller without empty log. There may be a partial migration.", (Object)logMsg), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.of(ZkMigrationState.PRE_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of PRE_MIGRATION.", (Object)logMsg), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV1, Optional.of(ZkMigrationState.PRE_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of MIGRATION. Staying in ZK migration mode since 'zookeeper.metadata.migration.enable' is still 'true'.", (Object)logMsg), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.of(ZkMigrationState.MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of MIGRATION. Completing the ZK migration since this controller was configured with 'zookeeper.metadata.migration.enable' set to 'false'.", (Object)logMsg), (long)-1L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.of(ZkMigrationState.MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting in-progress metadata transaction at offset 42. Loaded ZK migration state of MIGRATION. Completing the ZK migration since this controller was configured with 'zookeeper.metadata.migration.enable' set to 'false'.", (Object)logMsg), (long)42L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV1, Optional.of(ZkMigrationState.MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)2, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of POST_MIGRATION.", (Object)logMsg), (long)-1L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.of(ZkMigrationState.POST_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting in-progress metadata transaction at offset 42. Loaded ZK migration state of POST_MIGRATION.", (Object)logMsg), (long)42L, (boolean)false, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV1, Optional.of(ZkMigrationState.POST_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Loaded ZK migration state of POST_MIGRATION. Ignoring 'zookeeper.metadata.migration.enable' value of 'true' since the ZK migration has been completed.", (Object)logMsg), (long)-1L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_4_IV0, Optional.of(ZkMigrationState.POST_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_4_IV0);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = ActivationRecordsGenerator.recordsForNonEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting in-progress metadata transaction at offset 42. Loaded ZK migration state of POST_MIGRATION. Ignoring 'zookeeper.metadata.migration.enable' value of 'true' since the ZK migration has been completed.", (Object)logMsg), (long)42L, (boolean)true, (FeatureControlManager)this.buildFeatureControl(MetadataVersion.IBP_3_6_IV1, Optional.of(ZkMigrationState.POST_MIGRATION)), (MetadataVersion)MetadataVersion.IBP_3_6_IV1);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
    }
}

