/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import org.apache.kafka.image.node.ScramCredentialDataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.MetadataNodeRedactionCriteria;
import org.apache.kafka.image.node.printer.NodeStringifier;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScramCredentialDataNodeTest {
    private static final ScramCredentialData DATA;

    @Test
    public void testPrintRedacted() {
        NodeStringifier stringifier = new NodeStringifier();
        new ScramCredentialDataNode(DATA).print((MetadataNodePrinter)stringifier);
        Assertions.assertEquals((Object)"ScramCredentialData(salt=[redacted], storedKey=[redacted], serverKey=[redacted], iterations=[redacted])", (Object)stringifier.toString());
    }

    @Test
    public void testPrintUnredacted() {
        NodeStringifier stringifier = new NodeStringifier((MetadataNodeRedactionCriteria)MetadataNodeRedactionCriteria.Disabled.INSTANCE);
        new ScramCredentialDataNode(DATA).print((MetadataNodePrinter)stringifier);
        Assertions.assertEquals((Object)"ScramCredentialData(salt=4f1d6ea31e58c5ad3aaeb3266f55cce6, storedKey=3cfa1c3421b512d1d1dfc3355138b4ad, serverKey=2d9781209073e8d03aee3cbc63a1d4ca, iterations=16)", (Object)stringifier.toString());
    }

    static {
        MockRandom mockRandom = new MockRandom();
        byte[] salt = new byte[16];
        mockRandom.nextBytes(salt);
        byte[] storedKey = new byte[16];
        mockRandom.nextBytes(storedKey);
        byte[] serverKey = new byte[16];
        mockRandom.nextBytes(serverKey);
        DATA = new ScramCredentialData(salt, storedKey, serverKey, 16);
    }
}

