/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetadataMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller:", new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=ActiveBrokerCount", "kafka.controller:type=KafkaController,name=FencedBrokerCount", "kafka.controller:type=KafkaController,name=MigratingZkBrokerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount", "kafka.controller:type=KafkaController,name=ZkMigrationState")));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "KafkaController", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataErrorCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge metadataErrorCount = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "MetadataErrorCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)metadataErrorCount.value()));
            metrics.incrementMetadataErrorCount();
            Assertions.assertEquals((int)1, (Integer)((Integer)metadataErrorCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntGaugeMetric(Function<ControllerMetadataMetrics, Integer> metricsGetter, Function<MetricsRegistry, Integer> registryGetter, BiConsumer<ControllerMetadataMetrics, Integer> setter, BiConsumer<ControllerMetadataMetrics, Integer> incrementer) {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
            setter.accept(metrics, 123);
            Assertions.assertEquals((int)123, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)123, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, 123);
            Assertions.assertEquals((int)246, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)246, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, -246);
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testFencedBrokerMetric() {
        this.testIntGaugeMetric(m -> m.fencedBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "FencedBrokerCount"))).value(), (m, v) -> m.setFencedBrokerCount(v.intValue()), (m, v) -> m.addToFencedBrokerCount(v.intValue()));
    }

    @Test
    public void testActiveBrokerCountMetric() {
        this.testIntGaugeMetric(m -> m.activeBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "ActiveBrokerCount"))).value(), (m, v) -> m.setActiveBrokerCount(v.intValue()), (m, v) -> m.addToActiveBrokerCount(v.intValue()));
    }

    @Test
    public void testGlobalTopicCountMetric() {
        this.testIntGaugeMetric(m -> m.globalTopicCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "GlobalTopicCount"))).value(), (m, v) -> m.setGlobalTopicCount(v.intValue()), (m, v) -> m.addToGlobalTopicCount(v.intValue()));
    }

    @Test
    public void testGlobalPartitionCountMetric() {
        this.testIntGaugeMetric(m -> m.globalPartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "GlobalPartitionCount"))).value(), (m, v) -> m.setGlobalPartitionCount(v.intValue()), (m, v) -> m.addToGlobalPartitionCount(v.intValue()));
    }

    @Test
    public void testOfflinePartitionCountMetric() {
        this.testIntGaugeMetric(m -> m.offlinePartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "OfflinePartitionsCount"))).value(), (m, v) -> m.setOfflinePartitionCount(v.intValue()), (m, v) -> m.addToOfflinePartitionCount(v.intValue()));
    }

    @Test
    public void testPreferredReplicaImbalanceCountMetric() {
        this.testIntGaugeMetric(m -> m.preferredReplicaImbalanceCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "PreferredReplicaImbalanceCount"))).value(), (m, v) -> m.setPreferredReplicaImbalanceCount(v.intValue()), (m, v) -> m.addToPreferredReplicaImbalanceCount(v.intValue()));
    }
}

