/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import kafka.examples.Utils;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class Producer
extends Thread {
    private final String bootstrapServers;
    private final String topic;
    private final boolean isAsync;
    private final String transactionalId;
    private final boolean enableIdempotency;
    private final int numRecords;
    private final int transactionTimeoutMs;
    private final CountDownLatch latch;
    private volatile boolean closed;

    public Producer(String threadName, String bootstrapServers, String topic, boolean isAsync, String transactionalId, boolean enableIdempotency, int numRecords, int transactionTimeoutMs, CountDownLatch latch) {
        super(threadName);
        this.bootstrapServers = bootstrapServers;
        this.topic = topic;
        this.isAsync = isAsync;
        this.transactionalId = transactionalId;
        this.enableIdempotency = enableIdempotency;
        this.numRecords = numRecords;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.latch = latch;
    }

    @Override
    public void run() {
        int sentRecords;
        int key = 0;
        try (KafkaProducer<Integer, String> producer = this.createKafkaProducer();){
            for (sentRecords = 0; !this.closed && sentRecords < this.numRecords; ++sentRecords) {
                if (this.isAsync) {
                    this.asyncSend(producer, key, "test" + key);
                } else {
                    this.syncSend(producer, key, "test" + key);
                }
                ++key;
            }
        }
        catch (Throwable e) {
            Utils.printOut("Unhandled exception", new Object[0]);
            e.printStackTrace();
        }
        Utils.printOut("Sent %d records", sentRecords);
        this.shutdown();
    }

    public void shutdown() {
        if (!this.closed) {
            this.closed = true;
            this.latch.countDown();
        }
    }

    public KafkaProducer<Integer, String> createKafkaProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("client.id", "client-" + UUID.randomUUID());
        props.put("key.serializer", IntegerSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        if (this.transactionTimeoutMs > 0) {
            props.put("transaction.timeout.ms", (Object)this.transactionTimeoutMs);
        }
        if (this.transactionalId != null) {
            props.put("transactional.id", this.transactionalId);
        }
        props.put("enable.idempotence", (Object)this.enableIdempotency);
        return new KafkaProducer(props);
    }

    private void asyncSend(KafkaProducer<Integer, String> producer, int key, String value) {
        producer.send(new ProducerRecord(this.topic, (Object)key, (Object)value), (Callback)new ProducerCallback(key, value));
    }

    private RecordMetadata syncSend(KafkaProducer<Integer, String> producer, int key, String value) throws ExecutionException, InterruptedException {
        try {
            RecordMetadata metadata = (RecordMetadata)producer.send(new ProducerRecord(this.topic, (Object)key, (Object)value)).get();
            Utils.maybePrintRecord(this.numRecords, key, value, metadata);
            return metadata;
        }
        catch (AuthorizationException | FencedInstanceIdException | OutOfOrderSequenceException | ProducerFencedException | SerializationException | UnsupportedVersionException e) {
            Utils.printErr(e.getMessage(), new Object[0]);
            this.shutdown();
        }
        catch (KafkaException e) {
            Utils.printErr(e.getMessage(), new Object[0]);
        }
        return null;
    }

    class ProducerCallback
    implements Callback {
        private final int key;
        private final String value;

        public ProducerCallback(int key, String value) {
            this.key = key;
            this.value = value;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                Utils.printErr(exception.getMessage(), new Object[0]);
                if (!(exception instanceof RetriableException)) {
                    Producer.this.shutdown();
                }
            } else {
                Utils.maybePrintRecord(Producer.this.numRecords, this.key, this.value, metadata);
            }
        }
    }
}

