/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.producer;

import com.mapr.fs.jni.MarlinProducerResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.DuplicateSequenceException;

public class MarlinProducerResultImpl
implements MarlinProducerResult {
    private final CountDownLatch latch = new CountDownLatch(1);
    protected final String topic;
    private final Callback callback;
    protected volatile int feed = -1;
    protected volatile long offset = 0L;
    protected volatile long timestamp = -1L;
    protected int serializedKeySize;
    protected final int serializedValueSize;
    private volatile Exception error;

    public MarlinProducerResultImpl(String topic, int feed, Callback callback, int serKeySz, int serValSz) {
        this.topic = topic;
        this.feed = feed;
        this.callback = callback;
        this.serializedKeySize = serKeySz;
        this.serializedValueSize = serValSz;
    }

    public void done(int feedid, long offset, long timestamp, Exception error) {
        if (feedid == -1 || this.feed == -1 || this.feed == feedid) {
            // empty if block
        }
        this.feed = feedid;
        this.offset = offset;
        this.timestamp = timestamp;
        this.error = error;
        this.latch.countDown();
        if (error instanceof DuplicateSequenceException) {
            this.error = null;
            this.timestamp = -1L;
            this.offset = -1L;
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public int getFeed() {
        return this.feed;
    }

    public RecordMetadata getRecordMetadata() {
        return new RecordMetadata(new TopicPartition(this.topic, this.feed), this.offset, 0, this.timestamp, this.serializedKeySize, this.serializedValueSize);
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public boolean completed() {
        return this.latch.getCount() == 0L;
    }

    public long offset() {
        return this.offset;
    }

    public Exception error() {
        return this.error;
    }

    public Callback callback() {
        return this.callback;
    }

    public void onCompletion() {
        if (this.callback != null) {
            this.callback.onCompletion(this.getRecordMetadata(), this.error());
        }
    }
}

