/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.admin;

import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.StreamDescriptor;
import com.mapr.kafka.eventstreams.TimestampType;
import com.mapr.kafka.eventstreams.TopicDescriptor;
import com.mapr.kafka.eventstreams.impl.admin.MTopicDescriptor;
import com.mapr.kafka.eventstreams.impl.admin.TopicFeedInfo;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;

public class MockAdmin
implements Admin {
    private Map<String, List<String>> existingStreamsAndTopics = new HashMap<String, List<String>>();
    private Map<String, Integer> topicPartitions = new HashMap<String, Integer>();

    public void setExistingStreamsAndTopics(List<String> topicsFullName) {
        this.existingStreamsAndTopics = new HashMap<String, List<String>>();
        for (String fullTopic : topicsFullName) {
            String stream;
            String[] tokens = fullTopic.split(":");
            if (tokens.length == 2) {
                stream = tokens[0];
                String topic = tokens[1];
                this.existingStreamsAndTopics.compute(stream, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(topic);
                    return v;
                });
                continue;
            }
            stream = tokens[0];
            this.existingStreamsAndTopics.putIfAbsent(stream, new ArrayList());
        }
    }

    public void setExistingStreamsAndTopics(Map<String, Integer> topicsFullNameWithDescr) {
        this.existingStreamsAndTopics = new HashMap<String, List<String>>();
        this.topicPartitions = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> topic : topicsFullNameWithDescr.entrySet()) {
            String streamName;
            String[] tokens = topic.getKey().split(":");
            if (tokens.length == 2) {
                streamName = tokens[0];
                String topicName = tokens[1];
                this.existingStreamsAndTopics.compute(streamName, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(topicName);
                    return v;
                });
                this.topicPartitions.put(topic.getKey(), topic.getValue());
                continue;
            }
            streamName = tokens[0];
            this.existingStreamsAndTopics.putIfAbsent(streamName, new ArrayList());
        }
    }

    public void createStream(String streamPath, StreamDescriptor desc) throws IOException, IllegalArgumentException {
    }

    public void editStream(String streamPath, StreamDescriptor desc) throws IOException, IllegalArgumentException {
    }

    public StreamDescriptor getStreamDescriptor(String streamPath) throws IOException, IllegalArgumentException {
        return null;
    }

    public void deleteStream(String streamPath) throws IOException, IllegalArgumentException {
    }

    public int countTopics(String streamPath) throws IOException, IllegalArgumentException {
        return 0;
    }

    public void createTopic(String streamPath, String topicName) throws IOException {
    }

    public void createTopic(String streamPath, String topicName, int npartitions) throws IOException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException();
        }
        if (this.existingStreamsAndTopics.get(streamPath).contains(topicName)) {
            String topicFullName = streamPath + ":" + topicName;
            throw new FileAlreadyExistsException("Topic " + topicFullName + " already exists.");
        }
        this.existingStreamsAndTopics.compute(streamPath, (k, v) -> {
            v.add(topicName);
            return v;
        });
    }

    public void createTopic(String streamPath, String topicName, TopicDescriptor desc) throws IOException {
    }

    public void editTopic(String streamPath, String topicName, int npartitions) throws IOException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException("Stream " + streamPath + " does not exist.");
        }
        if (!this.existingStreamsAndTopics.get(streamPath).contains(topicName)) {
            String topicFullName = streamPath + ":" + topicName;
            throw new NoSuchFileException("Topic " + topicFullName + " does not exist.");
        }
    }

    public void editTopic(String streamPath, String topicName, TopicDescriptor desc) throws IOException {
    }

    public void deleteTopic(String streamPath, String topicName) throws IOException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException("Stream " + streamPath + " does not exist.");
        }
        if (!this.existingStreamsAndTopics.get(streamPath).contains(topicName)) {
            String topicFullName = streamPath + ":" + topicName;
            throw new NoSuchFileException("Topic " + topicFullName + " does not exist.");
        }
        this.existingStreamsAndTopics.get(streamPath).remove(topicName);
    }

    public void compactTopicNow(String streamPath, String topicName) throws IOException {
    }

    public TopicDescriptor getTopicDescriptor(String streamPath, String topicName) throws IOException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException("Stream " + streamPath + " does not exist.");
        }
        if (!this.existingStreamsAndTopics.get(streamPath).contains(topicName)) {
            String topicFullName = streamPath + ":" + topicName;
            throw new NoSuchFileException("Topic " + topicFullName + " does not exist.");
        }
        String fullTopicName = streamPath + ":" + topicName;
        MTopicDescriptor desc = new MTopicDescriptor();
        desc.setPartitions(this.topicPartitions.get(fullTopicName).intValue());
        desc.setTimestampType(TimestampType.CREATE_TIME);
        return desc;
    }

    public List<String> listTopics(String streamPath) throws IOException, IllegalArgumentException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException("Stream " + streamPath + " does not exist.");
        }
        return this.existingStreamsAndTopics.get(streamPath);
    }

    public Map<String, List<TopicFeedInfo>> listTopicsForStream(String streamPath) throws IOException, IllegalArgumentException {
        if (!this.existingStreamsAndTopics.containsKey(streamPath)) {
            throw new TableNotFoundException("Stream " + streamPath + " does not exist.");
        }
        HashMap<String, List<TopicFeedInfo>> topicStatMap = new HashMap<String, List<TopicFeedInfo>>();
        for (String topic : this.existingStreamsAndTopics.get(streamPath)) {
            String fullTopicName = streamPath + ":" + topic;
            ArrayList<TopicFeedInfo> fstatList = new ArrayList<TopicFeedInfo>();
            for (int i = 0; i < this.topicPartitions.get(fullTopicName); ++i) {
                fstatList.add(new TopicFeedInfo(i));
            }
            topicStatMap.put(topic, fstatList);
        }
        return topicStatMap;
    }

    public Collection<Object> listConsumerGroups(String streamPath) throws IOException, IllegalArgumentException {
        return null;
    }

    public boolean streamExists(String streamPath) throws IOException {
        return false;
    }

    public Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String streamPath, String groupId) throws IOException, IllegalArgumentException {
        return null;
    }

    public Map<TopicPartition, Errors> alterConsumerGroupOffsets(String streamPath, String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) throws IOException, IllegalArgumentException {
        return null;
    }

    public void close() {
    }

    public void close(long duration, TimeUnit unit) {
    }

    public void close(Duration duration) {
    }
}

