/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.admin;

import com.mapr.fs.jni.MarlinJniListener;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.impl.admin.MarlinAdminClientImpl;
import com.mapr.kafka.eventstreams.impl.admin.MockAdmin;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MarlinAdminClientImplTest {
    private static final String DEFAULT_STREAM = "/default-stream";
    private String existingStream = "/existing-stream";
    private String nonExistingStream = "/non-existing-stream";
    private String testTopic1 = "testTopic1";
    private String testTopic2 = "testTopic2";
    private String testTopic3 = "testTopic3";
    private String testTopic4 = "testTopic4";
    private String fullTestTopic1 = "/default-stream:testTopic1";
    private String fullTestTopic2 = "/existing-stream:testTopic2";
    private String fullTestTopic3 = "/non-existing-stream:testTopic3";
    private String fullTestTopic4 = "/existing-stream:testTopic4";
    private NewTopic newTestTopic1 = new NewTopic(this.testTopic1, 1, 0);
    private NewTopic newTestTopic2 = new NewTopic(this.fullTestTopic2, 2, 0);
    private NewTopic newTestTopic3 = new NewTopic(this.fullTestTopic3, 3, 0);
    private TopicPartition testTopic1Part0 = new TopicPartition(this.testTopic1, 0);
    private TopicPartition testTopic2Part0 = new TopicPartition(this.fullTestTopic2, 0);
    private TopicPartition testTopic2Part1 = new TopicPartition(this.fullTestTopic2, 1);
    private TopicPartition testTopic2Part2 = new TopicPartition(this.fullTestTopic2, 2);
    private TopicPartition testTopic3Part0 = new TopicPartition(this.fullTestTopic3, 0);
    private TopicPartition testTopic3Part1 = new TopicPartition(this.fullTestTopic3, 1);
    private TopicPartition testTopic4Part0 = new TopicPartition(this.fullTestTopic4, 0);
    private Map<TopicPartition, OffsetSpec> testTopic1PartOffsets = Map.of(this.testTopic1Part0, new OffsetSpec());
    private Map<TopicPartition, OffsetSpec> testTopic2PartOffsets = Map.of(this.testTopic2Part0, new OffsetSpec(), this.testTopic2Part1, new OffsetSpec());
    private Map<TopicPartition, OffsetSpec> testTopic2PartOffsetsWrongPart = Map.of(this.testTopic2Part0, new OffsetSpec(), this.testTopic2Part2, new OffsetSpec());
    private Map<TopicPartition, OffsetSpec> testTopic3PartOffsets = Map.of(this.testTopic3Part0, new OffsetSpec(), this.testTopic3Part1, new OffsetSpec());
    private Map<TopicPartition, OffsetSpec> testTopic4PartOffsets = Map.of(this.testTopic4Part0, new OffsetSpec());
    private MockAdmin mockAdmin;
    private MarlinAdminClientImpl adminClientWithDefaultStream;
    private MarlinAdminClientImpl adminClientWithoutDefaultStream;

    @BeforeClass
    public static void staticSetUp() {
        MarlinJniListener.class.getDeclaredMethods();
    }

    @Before
    public void setUp() {
        this.mockAdmin = new MockAdmin();
        this.adminClientWithDefaultStream = new MarlinAdminClientImpl((Admin)this.mockAdmin, DEFAULT_STREAM);
        this.adminClientWithoutDefaultStream = new MarlinAdminClientImpl((Admin)this.mockAdmin, null);
    }

    @Test
    public void testTopicCreationWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(DEFAULT_STREAM, this.existingStream));
        KafkaFuture createTopic = this.adminClientWithDefaultStream.createTopics(Collections.singletonList(this.newTestTopic1)).all();
        createTopic.get();
        KafkaFuture createTopicWithStream = this.adminClientWithDefaultStream.createTopics(Collections.singletonList(this.newTestTopic2)).all();
        createTopicWithStream.get();
        try {
            this.adminClientWithDefaultStream.createTopics(Collections.singletonList(this.newTestTopic2)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(TopicExistsException.class, e.getCause().getClass());
        }
        try {
            this.adminClientWithDefaultStream.createTopics(Collections.singletonList(this.newTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
        }
    }

    @Test
    public void testTopicCreationWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(DEFAULT_STREAM, this.existingStream));
        try {
            this.adminClientWithoutDefaultStream.createTopics(Collections.singletonList(this.newTestTopic1)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
        }
        KafkaFuture createTopicWithStream = this.adminClientWithoutDefaultStream.createTopics(Collections.singletonList(this.newTestTopic2)).all();
        createTopicWithStream.get();
        try {
            this.adminClientWithoutDefaultStream.createTopics(Collections.singletonList(this.newTestTopic2)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(TopicExistsException.class, e.getCause().getClass());
        }
        try {
            this.adminClientWithoutDefaultStream.createTopics(Collections.singletonList(this.newTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
        }
    }

    @Test
    public void testDeleteTopicsWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(this.fullTestTopic1, this.fullTestTopic2));
        KafkaFuture deleteTopic = this.adminClientWithDefaultStream.deleteTopics(Collections.singletonList(this.testTopic1)).all();
        deleteTopic.get();
        KafkaFuture deleteTopicWithStream = this.adminClientWithDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic2)).all();
        deleteTopicWithStream.get();
        try {
            this.adminClientWithDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic4)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testDeleteTopicsWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(this.fullTestTopic1, this.fullTestTopic2));
        try {
            this.adminClientWithoutDefaultStream.deleteTopics(Collections.singletonList(this.testTopic1)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
        }
        KafkaFuture deleteTopicWithStream = this.adminClientWithoutDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic2)).all();
        deleteTopicWithStream.get();
        try {
            this.adminClientWithoutDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.deleteTopics(Collections.singletonList(this.fullTestTopic4)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testListTopicsWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(this.fullTestTopic1, this.fullTestTopic2, this.fullTestTopic4));
        List<String> topicsFromDefault = List.of(this.testTopic1);
        List<String> topicsFromExistingStream = List.of(this.testTopic2, this.testTopic4);
        KafkaFuture topicListings = this.adminClientWithDefaultStream.listTopics().listings();
        List topics = ((Collection)topicListings.get()).stream().map(TopicListing::name).collect(Collectors.toList());
        Assert.assertEquals(topicsFromDefault, topics);
        KafkaFuture topicListingsWithStream = this.adminClientWithDefaultStream.listTopics(this.existingStream).listings();
        topics = ((Collection)topicListingsWithStream.get()).stream().map(TopicListing::name).collect(Collectors.toList());
        Assert.assertEquals(topicsFromExistingStream, topics);
        try {
            this.adminClientWithDefaultStream.listTopics(this.nonExistingStream).listings().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testListTopicsWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(List.of(this.fullTestTopic1, this.fullTestTopic2, this.fullTestTopic4));
        List<String> topicsFromExistingStream = List.of(this.testTopic2, this.testTopic4);
        try {
            this.adminClientWithoutDefaultStream.listTopics().listings().get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(KafkaException.class, e.getClass());
        }
        KafkaFuture topicListingsWithStream = this.adminClientWithoutDefaultStream.listTopics(this.existingStream).listings();
        List topics = ((Collection)topicListingsWithStream.get()).stream().map(TopicListing::name).collect(Collectors.toList());
        Assert.assertEquals(topicsFromExistingStream, topics);
        try {
            this.adminClientWithoutDefaultStream.listTopics(this.nonExistingStream).listings().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testDescribeTopicsWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        KafkaFuture topicDesc = this.adminClientWithDefaultStream.describeTopics(Collections.singletonList(this.testTopic1)).all();
        TopicDescription desc = (TopicDescription)((Map)topicDesc.get()).get(this.fullTestTopic1);
        Assert.assertEquals((long)1L, (long)desc.partitions().size());
        KafkaFuture topicDescWithStream = this.adminClientWithDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic2)).all();
        desc = (TopicDescription)((Map)topicDescWithStream.get()).get(this.fullTestTopic2);
        Assert.assertEquals((long)2L, (long)desc.partitions().size());
        try {
            this.adminClientWithoutDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic4)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testDescribeTopicsWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        try {
            this.adminClientWithoutDefaultStream.describeTopics(Collections.singletonList(this.testTopic1)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
        }
        KafkaFuture topicDescWithStream = this.adminClientWithDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic2)).all();
        TopicDescription desc = (TopicDescription)((Map)topicDescWithStream.get()).get(this.fullTestTopic2);
        Assert.assertEquals((long)2L, (long)desc.partitions().size());
        try {
            this.adminClientWithoutDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic3)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.describeTopics(Collections.singletonList(this.fullTestTopic4)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testCreatePartitionsWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        NewPartitions inc = NewPartitions.increaseTo((int)5);
        KafkaFuture createPartitions = this.adminClientWithDefaultStream.createPartitions(Map.of(this.testTopic1, inc)).all();
        createPartitions.get();
        createPartitions = this.adminClientWithDefaultStream.createPartitions(Map.of(this.fullTestTopic2, inc)).all();
        createPartitions.get();
        try {
            this.adminClientWithDefaultStream.createPartitions(Map.of(this.fullTestTopic3, inc)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithDefaultStream.createPartitions(Map.of(this.fullTestTopic4, inc)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testCreatePartitionsWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        NewPartitions inc = NewPartitions.increaseTo((int)5);
        try {
            this.adminClientWithoutDefaultStream.createPartitions(Map.of(this.testTopic1, inc)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
        }
        KafkaFuture createPartitions = this.adminClientWithoutDefaultStream.createPartitions(Map.of(this.fullTestTopic2, inc)).all();
        createPartitions.get();
        try {
            this.adminClientWithoutDefaultStream.createPartitions(Map.of(this.fullTestTopic3, inc)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.createPartitions(Map.of(this.fullTestTopic4, inc)).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic /existing-stream:testTopic4 does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testListOffsetsWithDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        NewPartitions inc = NewPartitions.increaseTo((int)5);
        KafkaFuture offsetsResult = this.adminClientWithDefaultStream.listOffsets(this.testTopic1PartOffsets).all();
        offsetsResult.get();
        offsetsResult = this.adminClientWithDefaultStream.listOffsets(this.testTopic2PartOffsets).all();
        offsetsResult.get();
        try {
            this.adminClientWithDefaultStream.listOffsets(this.testTopic2PartOffsetsWrongPart).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Partition 2 cannot be found in the topic /existing-stream:testTopic2", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithDefaultStream.listOffsets(this.testTopic4PartOffsets).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic testTopic4 cannot be found in the stream /existing-stream", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithDefaultStream.listOffsets(this.testTopic3PartOffsets).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testListOffsetsWithoutDefaultStream() throws Exception {
        this.mockAdmin.setExistingStreamsAndTopics(Map.of(this.fullTestTopic1, 1, this.fullTestTopic2, 2));
        NewPartitions inc = NewPartitions.increaseTo((int)5);
        try {
            this.adminClientWithoutDefaultStream.listOffsets(this.testTopic1PartOffsets).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
        }
        KafkaFuture offsetsResult = this.adminClientWithoutDefaultStream.listOffsets(this.testTopic2PartOffsets).all();
        offsetsResult.get();
        try {
            this.adminClientWithoutDefaultStream.listOffsets(this.testTopic2PartOffsetsWrongPart).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Partition 2 cannot be found in the topic /existing-stream:testTopic2", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.listOffsets(this.testTopic4PartOffsets).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Topic testTopic4 cannot be found in the stream /existing-stream", (Object)e.getCause().getMessage());
        }
        try {
            this.adminClientWithoutDefaultStream.listOffsets(this.testTopic3PartOffsets).all().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"Stream /non-existing-stream does not exist.", (Object)e.getCause().getMessage());
        }
    }
}

