/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AbortTransactionOptions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsOptions;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.DelegationTokenNotFoundException;
import org.apache.kafka.common.errors.InvalidPrincipalTypeException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;

public class MockAdminClient
extends AdminClient {
    public static final String DEFAULT_CLUSTER_ID = "I4ZmrWqfT2e-upky_4fdPA";
    public static final List<String> DEFAULT_LOG_DIRS = Collections.singletonList("/tmp/kafka-logs");
    private final List<Node> brokers;
    private final Map<String, TopicMetadata> allTopics = new HashMap<String, TopicMetadata>();
    private final Map<String, Uuid> topicIds = new HashMap<String, Uuid>();
    private final Map<Uuid, String> topicNames = new HashMap<Uuid, String>();
    private final Map<TopicPartition, NewPartitionReassignment> reassignments = new HashMap<TopicPartition, NewPartitionReassignment>();
    private final Map<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> replicaMoves = new HashMap<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo>();
    private final Map<TopicPartition, Long> beginningOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private final Map<TopicPartition, Long> committedOffsets;
    private final boolean usingRaftController;
    private final Map<String, Short> featureLevels;
    private final Map<String, Short> minSupportedFeatureLevels;
    private final Map<String, Short> maxSupportedFeatureLevels;
    private final String clusterId;
    private final List<List<String>> brokerLogDirs;
    private final List<Map<String, String>> brokerConfigs;
    private Node controller;
    private int timeoutNextRequests = 0;
    private final int defaultPartitions;
    private final int defaultReplicationFactor;
    private KafkaException listConsumerGroupOffsetsException;
    private Map<MetricName, Metric> mockMetrics = new HashMap<MetricName, Metric>();
    private final List<DelegationToken> allTokens = new ArrayList<DelegationToken>();

    public static Builder create() {
        return new Builder();
    }

    public MockAdminClient() {
        this(Collections.singletonList(Node.noNode()), Node.noNode());
    }

    public MockAdminClient(List<Node> brokers, Node controller) {
        this(brokers, controller, DEFAULT_CLUSTER_ID, 1, brokers.size(), Collections.nCopies(brokers.size(), DEFAULT_LOG_DIRS), false, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private MockAdminClient(List<Node> brokers, Node controller, String clusterId, int defaultPartitions, int defaultReplicationFactor, List<List<String>> brokerLogDirs, boolean usingRaftController, Map<String, Short> featureLevels, Map<String, Short> minSupportedFeatureLevels, Map<String, Short> maxSupportedFeatureLevels) {
        this.brokers = brokers;
        this.controller(controller);
        this.clusterId = clusterId;
        this.defaultPartitions = defaultPartitions;
        this.defaultReplicationFactor = defaultReplicationFactor;
        this.brokerLogDirs = brokerLogDirs;
        this.brokerConfigs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < brokers.size(); ++i) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("default.replication.factor", String.valueOf(defaultReplicationFactor));
            this.brokerConfigs.add(config);
        }
        this.beginningOffsets = new HashMap<TopicPartition, Long>();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.committedOffsets = new HashMap<TopicPartition, Long>();
        this.usingRaftController = usingRaftController;
        this.featureLevels = new HashMap<String, Short>(featureLevels);
        this.minSupportedFeatureLevels = new HashMap<String, Short>(minSupportedFeatureLevels);
        this.maxSupportedFeatureLevels = new HashMap<String, Short>(maxSupportedFeatureLevels);
    }

    public synchronized void controller(Node controller) {
        if (!this.brokers.contains(controller)) {
            throw new IllegalArgumentException("The controller node must be in the list of brokers");
        }
        this.controller = controller;
    }

    public void addTopic(boolean internal, String name, List<TopicPartitionInfo> partitions, Map<String, String> configs) {
        this.addTopic(internal, name, partitions, configs, true);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addTopic(boolean internal, String name, List<TopicPartitionInfo> partitions, Map<String, String> configs, boolean usesTopicId) {
        void var7_11;
        if (this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s was already added.", name));
        }
        for (TopicPartitionInfo topicPartitionInfo : partitions) {
            if (!this.brokers.contains(topicPartitionInfo.leader())) {
                throw new IllegalArgumentException("Leader broker unknown");
            }
            if (!this.brokers.containsAll(topicPartitionInfo.replicas())) {
                throw new IllegalArgumentException("Unknown brokers in replica list");
            }
            if (this.brokers.containsAll(topicPartitionInfo.isr())) continue;
            throw new IllegalArgumentException("Unknown brokers in isr list");
        }
        ArrayList<String> logDirs = new ArrayList<String>();
        for (TopicPartitionInfo partition : partitions) {
            if (partition.leader() == null) continue;
            logDirs.add(this.brokerLogDirs.get(partition.leader().id()).get(0));
        }
        if (usesTopicId) {
            Uuid uuid = Uuid.randomUuid();
            this.topicIds.put(name, uuid);
            this.topicNames.put(uuid, name);
        } else {
            Uuid uuid = Uuid.ZERO_UUID;
        }
        this.allTopics.put(name, new TopicMetadata((Uuid)var7_11, internal, partitions, logDirs, configs));
    }

    public synchronized void markTopicForDeletion(String name) {
        if (!this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s did not exist.", name));
        }
        this.allTopics.get((Object)name).markedForDeletion = true;
    }

    public synchronized void timeoutNextRequest(int numberOfRequest) {
        this.timeoutNextRequests = numberOfRequest;
    }

    public synchronized DescribeClusterResult describeCluster(DescribeClusterOptions options) {
        KafkaFutureImpl nodesFuture = new KafkaFutureImpl();
        KafkaFutureImpl controllerFuture = new KafkaFutureImpl();
        KafkaFutureImpl brokerIdFuture = new KafkaFutureImpl();
        KafkaFutureImpl authorizedOperationsFuture = new KafkaFutureImpl();
        if (this.timeoutNextRequests > 0) {
            nodesFuture.completeExceptionally((Throwable)new TimeoutException());
            controllerFuture.completeExceptionally((Throwable)new TimeoutException());
            brokerIdFuture.completeExceptionally((Throwable)new TimeoutException());
            authorizedOperationsFuture.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
        } else {
            nodesFuture.complete(this.brokers);
            controllerFuture.complete((Object)this.controller);
            brokerIdFuture.complete((Object)this.clusterId);
            authorizedOperationsFuture.complete(Collections.emptySet());
        }
        return new DescribeClusterResult((KafkaFuture)nodesFuture, (KafkaFuture)controllerFuture, (KafkaFuture)brokerIdFuture, (KafkaFuture)authorizedOperationsFuture);
    }

    public synchronized CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> createTopicResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (NewTopic newTopic : newTopics) {
                String topicName = newTopic.name();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                createTopicResult.put(topicName, future);
            }
            --this.timeoutNextRequests;
            return new CreateTopicsResult(createTopicResult);
        }
        for (NewTopic newTopic : newTopics) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String topicName = newTopic.name();
            if (this.allTopics.containsKey(topicName)) {
                future.completeExceptionally((Throwable)new TopicExistsException(String.format("Topic %s exists already.", topicName)));
                createTopicResult.put(topicName, future);
                continue;
            }
            int replicationFactor = newTopic.replicationFactor();
            if (replicationFactor == -1) {
                replicationFactor = this.defaultReplicationFactor;
            }
            if (replicationFactor > this.brokers.size()) {
                future.completeExceptionally((Throwable)new InvalidReplicationFactorException(String.format("Replication factor: %d is larger than brokers: %d", newTopic.replicationFactor(), this.brokers.size())));
                createTopicResult.put(topicName, future);
                continue;
            }
            ArrayList<Node> replicas = new ArrayList<Node>(replicationFactor);
            for (int i = 0; i < replicationFactor; ++i) {
                replicas.add(this.brokers.get(i));
            }
            int numberOfPartitions = newTopic.numPartitions();
            if (numberOfPartitions == -1) {
                numberOfPartitions = this.defaultPartitions;
            }
            ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(numberOfPartitions);
            ArrayList<String> logDirs = new ArrayList<String>(numberOfPartitions);
            for (int i = 0; i < numberOfPartitions; ++i) {
                partitions.add(new TopicPartitionInfo(i, this.brokers.get(0), replicas, Collections.emptyList()));
                logDirs.add(this.brokerLogDirs.get(((TopicPartitionInfo)partitions.get(i)).leader().id()).get(0));
            }
            Uuid topicId = Uuid.randomUuid();
            this.topicIds.put(topicName, topicId);
            this.topicNames.put(topicId, topicName);
            this.allTopics.put(topicName, new TopicMetadata(topicId, false, partitions, logDirs, newTopic.configs()));
            future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(topicId, numberOfPartitions, replicationFactor, MockAdminClient.config(newTopic)));
            createTopicResult.put(topicName, future);
        }
        return new CreateTopicsResult(createTopicResult);
    }

    private static Config config(NewTopic newTopic) {
        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
        if (newTopic.configs() != null) {
            for (Map.Entry entry : newTopic.configs().entrySet()) {
                configEntries.add(new ConfigEntry((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return new Config(configEntries);
    }

    public synchronized ListTopicsResult listTopics(ListTopicsOptions options) {
        HashMap<String, TopicListing> topicListings = new HashMap<String, TopicListing>();
        if (this.timeoutNextRequests > 0) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
            return new ListTopicsResult((KafkaFuture)future);
        }
        for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
            String topicName = topicDescription.getKey();
            if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                --topicDescription.getValue().fetchesRemainingUntilVisible;
                continue;
            }
            topicListings.put(topicName, new TopicListing(topicName, topicDescription.getValue().topicId, topicDescription.getValue().isInternalTopic));
        }
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(topicListings);
        return new ListTopicsResult((KafkaFuture)future);
    }

    public ListTopicsResult listTopics(String streamPath, ListTopicsOptions options) {
        return this.listTopics(options);
    }

    public synchronized DescribeTopicsResult describeTopics(TopicCollection topics, DescribeTopicsOptions options) {
        if (topics instanceof TopicCollection.TopicIdCollection) {
            return DescribeTopicsResult.ofTopicIds(new HashMap<Uuid, KafkaFuture<TopicDescription>>(this.handleDescribeTopicsUsingIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options)));
        }
        if (topics instanceof TopicCollection.TopicNameCollection) {
            return DescribeTopicsResult.ofTopicNames(new HashMap<String, KafkaFuture<TopicDescription>>(this.handleDescribeTopicsByNames(((TopicCollection.TopicNameCollection)topics).topicNames(), options)));
        }
        throw new IllegalArgumentException("The TopicCollection provided did not match any supported classes for describeTopics.");
    }

    private Map<String, KafkaFuture<TopicDescription>> handleDescribeTopicsByNames(Collection<String> topicNames, DescribeTopicsOptions options) {
        HashMap<String, KafkaFuture<TopicDescription>> topicDescriptions = new HashMap<String, KafkaFuture<TopicDescription>>();
        if (this.timeoutNextRequests > 0) {
            for (String requestedTopic : topicNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                topicDescriptions.put(requestedTopic, (KafkaFuture<TopicDescription>)future);
            }
            --this.timeoutNextRequests;
            return topicDescriptions;
        }
        for (String requestedTopic : topicNames) {
            for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
                String topicName = topicDescription.getKey();
                Uuid topicId = this.topicIds.getOrDefault(topicName, Uuid.ZERO_UUID);
                if (!topicName.equals(requestedTopic) || topicDescription.getValue().markedForDeletion) continue;
                if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                    --topicDescription.getValue().fetchesRemainingUntilVisible;
                    continue;
                }
                TopicMetadata topicMetadata = topicDescription.getValue();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new TopicDescription(topicName, topicMetadata.isInternalTopic, topicMetadata.partitions, Collections.emptySet(), topicId));
                topicDescriptions.put(topicName, (KafkaFuture<TopicDescription>)future);
                break;
            }
            if (topicDescriptions.containsKey(requestedTopic)) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Topic " + requestedTopic + " not found."));
            topicDescriptions.put(requestedTopic, (KafkaFuture<TopicDescription>)future);
        }
        return topicDescriptions;
    }

    public synchronized Map<Uuid, KafkaFuture<TopicDescription>> handleDescribeTopicsUsingIds(Collection<Uuid> topicIds, DescribeTopicsOptions options) {
        HashMap<Uuid, KafkaFuture<TopicDescription>> topicDescriptions = new HashMap<Uuid, KafkaFuture<TopicDescription>>();
        if (this.timeoutNextRequests > 0) {
            for (Uuid requestedTopicId : topicIds) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
            }
            --this.timeoutNextRequests;
            return topicDescriptions;
        }
        for (Uuid requestedTopicId : topicIds) {
            for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
                String topicName = topicDescription.getKey();
                Uuid topicId = this.topicIds.get(topicName);
                if (topicId == null || !topicId.equals((Object)requestedTopicId) || topicDescription.getValue().markedForDeletion) continue;
                if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                    --topicDescription.getValue().fetchesRemainingUntilVisible;
                    continue;
                }
                TopicMetadata topicMetadata = topicDescription.getValue();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new TopicDescription(topicName, topicMetadata.isInternalTopic, topicMetadata.partitions, Collections.emptySet(), topicId));
                topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
                break;
            }
            if (topicDescriptions.containsKey(requestedTopicId)) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new UnknownTopicIdException("Topic id" + requestedTopicId + " not found."));
            topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
        }
        return topicDescriptions;
    }

    public synchronized DeleteTopicsResult deleteTopics(TopicCollection topics, DeleteTopicsOptions options) {
        DeleteTopicsResult result;
        if (topics instanceof TopicCollection.TopicIdCollection) {
            result = DeleteTopicsResult.ofTopicIds(new HashMap<Uuid, KafkaFuture<Void>>(this.handleDeleteTopicsUsingIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options)));
        } else if (topics instanceof TopicCollection.TopicNameCollection) {
            result = DeleteTopicsResult.ofTopicNames(new HashMap<String, KafkaFuture<Void>>(this.handleDeleteTopicsUsingNames(((TopicCollection.TopicNameCollection)topics).topicNames(), options)));
        } else {
            throw new IllegalArgumentException("The TopicCollection provided did not match any supported classes for deleteTopics.");
        }
        return result;
    }

    private Map<String, KafkaFuture<Void>> handleDeleteTopicsUsingNames(Collection<String> topicNameCollection, DeleteTopicsOptions options) {
        HashMap<String, KafkaFuture<Void>> deleteTopicsResult = new HashMap<String, KafkaFuture<Void>>();
        ArrayList<String> topicNames = new ArrayList<String>(topicNameCollection);
        if (this.timeoutNextRequests > 0) {
            for (String topicName : topicNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteTopicsResult.put(topicName, (KafkaFuture<Void>)future);
            }
            --this.timeoutNextRequests;
            return deleteTopicsResult;
        }
        for (String topicName : topicNames) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.allTopics.remove(topicName) == null) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s does not exist.", topicName)));
            } else {
                topicNames.remove(this.topicIds.remove(topicName));
                future.complete(null);
            }
            deleteTopicsResult.put(topicName, (KafkaFuture<Void>)future);
        }
        return deleteTopicsResult;
    }

    private Map<Uuid, KafkaFuture<Void>> handleDeleteTopicsUsingIds(Collection<Uuid> topicIdCollection, DeleteTopicsOptions options) {
        HashMap<Uuid, KafkaFuture<Void>> deleteTopicsResult = new HashMap<Uuid, KafkaFuture<Void>>();
        ArrayList<Uuid> topicIds = new ArrayList<Uuid>(topicIdCollection);
        if (this.timeoutNextRequests > 0) {
            for (Uuid topicId : topicIds) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteTopicsResult.put(topicId, (KafkaFuture<Void>)future);
            }
            --this.timeoutNextRequests;
            return deleteTopicsResult;
        }
        for (Uuid topicId : topicIds) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String name = this.topicNames.remove(topicId);
            if (name == null || this.allTopics.remove(name) == null) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s does not exist.", topicId)));
            } else {
                topicIds.remove(name);
                future.complete(null);
            }
            deleteTopicsResult.put(topicId, (KafkaFuture<Void>)future);
        }
        return deleteTopicsResult;
    }

    public synchronized CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        HashMap deletedRecordsResult = new HashMap();
        if (recordsToDelete.isEmpty()) {
            return new DeleteRecordsResult(deletedRecordsResult);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        for (KafkaPrincipal renewer : options.renewers()) {
            if (renewer.getPrincipalType().equals("User")) continue;
            future.completeExceptionally((Throwable)new InvalidPrincipalTypeException(""));
            return new CreateDelegationTokenResult((KafkaFuture)future);
        }
        String tokenId = Uuid.randomUuid().toString();
        TokenInformation tokenInfo = new TokenInformation(tokenId, (KafkaPrincipal)options.renewers().get(0), (Collection)options.renewers(), System.currentTimeMillis(), options.maxlifeTimeMs(), -1L);
        DelegationToken token = new DelegationToken(tokenInfo, tokenId.getBytes());
        this.allTokens.add(token);
        future.complete((Object)token);
        return new CreateDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized RenewDelegationTokenResult renewDelegationToken(byte[] hmac, RenewDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Boolean tokenFound = false;
        Long expiryTimestamp = options.renewTimePeriodMs();
        for (DelegationToken token : this.allTokens) {
            if (!Arrays.equals(token.hmac(), hmac)) continue;
            token.tokenInfo().setExpiryTimestamp(expiryTimestamp.longValue());
            tokenFound = true;
        }
        if (tokenFound.booleanValue()) {
            future.complete((Object)expiryTimestamp);
        } else {
            future.completeExceptionally((Throwable)new DelegationTokenNotFoundException(""));
        }
        return new RenewDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized ExpireDelegationTokenResult expireDelegationToken(byte[] hmac, ExpireDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Long expiryTimestamp = options.expiryTimePeriodMs();
        ArrayList<DelegationToken> tokensToRemove = new ArrayList<DelegationToken>();
        Boolean tokenFound = false;
        for (DelegationToken token : this.allTokens) {
            if (!Arrays.equals(token.hmac(), hmac)) continue;
            if (expiryTimestamp == -1L || expiryTimestamp < System.currentTimeMillis()) {
                tokensToRemove.add(token);
            }
            tokenFound = true;
        }
        if (tokenFound.booleanValue()) {
            this.allTokens.removeAll(tokensToRemove);
            future.complete((Object)expiryTimestamp);
        } else {
            future.completeExceptionally((Throwable)new DelegationTokenNotFoundException(""));
        }
        return new ExpireDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (options.owners().isEmpty()) {
            future.complete(this.allTokens);
        } else {
            ArrayList<DelegationToken> tokensResult = new ArrayList<DelegationToken>();
            for (DelegationToken token : this.allTokens) {
                if (!options.owners().contains(token.tokenInfo().owner())) continue;
                tokensResult.add(token);
            }
            future.complete(tokensResult);
        }
        return new DescribeDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ListConsumerGroupOffsetsResult listConsumerGroupOffsets(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, ListConsumerGroupOffsetsOptions options) {
        if (groupSpecs.size() != 1) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        String group = groupSpecs.keySet().iterator().next();
        Collection topicPartitions = groupSpecs.get(group).topicPartitions();
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.listConsumerGroupOffsetsException != null) {
            future.completeExceptionally((Throwable)this.listConsumerGroupOffsetsException);
        } else if (topicPartitions.isEmpty()) {
            future.complete(this.committedOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new OffsetAndMetadata(((Long)entry.getValue()).longValue()))));
        } else {
            future.complete(this.committedOffsets.entrySet().stream().filter(entry -> topicPartitions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> new OffsetAndMetadata(((Long)entry.getValue()).longValue()))));
        }
        return new ListConsumerGroupOffsetsResult(Collections.singletonMap(CoordinatorKey.byGroupId((String)group), future));
    }

    public synchronized DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions, ElectLeadersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
        if (this.timeoutNextRequests > 0) {
            HashMap<ConfigResource, KafkaFutureImpl> configs = new HashMap<ConfigResource, KafkaFutureImpl>();
            for (ConfigResource requestedResource : resources) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                configs.put(requestedResource, future);
            }
            --this.timeoutNextRequests;
            return new DescribeConfigsResult(configs);
        }
        HashMap<ConfigResource, KafkaFutureImpl> results = new HashMap<ConfigResource, KafkaFutureImpl>();
        for (ConfigResource resource : resources) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(resource, future);
            try {
                future.complete((Object)this.getResourceDescription(resource));
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }
        return new DescribeConfigsResult(results);
    }

    private synchronized Config getResourceDescription(ConfigResource resource) {
        switch (resource.type()) {
            case BROKER: {
                int brokerId = Integer.parseInt(resource.name());
                if (brokerId >= this.brokerConfigs.size()) {
                    throw new InvalidRequestException("Broker " + resource.name() + " not found.");
                }
                return MockAdminClient.toConfigObject(this.brokerConfigs.get(brokerId));
            }
            case TOPIC: {
                TopicMetadata topicMetadata = this.allTopics.get(resource.name());
                if (topicMetadata != null && !topicMetadata.markedForDeletion) {
                    if (topicMetadata.fetchesRemainingUntilVisible > 0) {
                        topicMetadata.fetchesRemainingUntilVisible = Math.max(0, topicMetadata.fetchesRemainingUntilVisible - 1);
                    } else {
                        return MockAdminClient.toConfigObject(topicMetadata.configs);
                    }
                }
                throw new UnknownTopicOrPartitionException("Resource " + resource + " not found.");
            }
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private static Config toConfigObject(Map<String, String> map) {
        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configEntries.add(new ConfigEntry(entry.getKey(), entry.getValue()));
        }
        return new Config(configEntries);
    }

    @Deprecated
    public synchronized AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl> futures = new HashMap<ConfigResource, KafkaFutureImpl>();
        for (Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry : configs.entrySet()) {
            ConfigResource resource = entry.getKey();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(resource, future);
            Throwable throwable = this.handleIncrementalResourceAlteration(resource, entry.getValue());
            if (throwable == null) {
                future.complete(null);
                continue;
            }
            future.completeExceptionally(throwable);
        }
        return new AlterConfigsResult(futures);
    }

    private synchronized Throwable handleIncrementalResourceAlteration(ConfigResource resource, Collection<AlterConfigOp> ops) {
        switch (resource.type()) {
            case BROKER: {
                int brokerId;
                try {
                    brokerId = Integer.parseInt(resource.name());
                }
                catch (NumberFormatException e) {
                    return e;
                }
                if (brokerId >= this.brokerConfigs.size()) {
                    return new InvalidRequestException("no such broker as " + brokerId);
                }
                HashMap<String, String> newMap = new HashMap<String, String>(this.brokerConfigs.get(brokerId));
                block14: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block14;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block14;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + op.opType());
                }
                this.brokerConfigs.set(brokerId, newMap);
                return null;
            }
            case TOPIC: {
                TopicMetadata topicMetadata = this.allTopics.get(resource.name());
                if (topicMetadata == null) {
                    return new UnknownTopicOrPartitionException("No such topic as " + resource.name());
                }
                HashMap<String, String> newMap = new HashMap<String, String>(topicMetadata.configs);
                block15: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block15;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block15;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + op.opType());
                }
                topicMetadata.configs = newMap;
                return null;
            }
        }
        return new UnsupportedOperationException();
    }

    public synchronized AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        HashMap<TopicPartitionReplica, KafkaFutureImpl> results = new HashMap<TopicPartitionReplica, KafkaFutureImpl>();
        for (Map.Entry<TopicPartitionReplica, String> entry : replicaAssignment.entrySet()) {
            TopicPartitionReplica replica = entry.getKey();
            String newLogDir = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(replica, future);
            List<String> dirs = this.brokerLogDirs.get(replica.brokerId());
            if (dirs == null) {
                future.completeExceptionally((Throwable)new ReplicaNotAvailableException("Can't find " + replica));
                continue;
            }
            if (!dirs.contains(newLogDir)) {
                future.completeExceptionally((Throwable)new KafkaStorageException("Log directory " + newLogDir + " is offline"));
                continue;
            }
            TopicMetadata metadata = this.allTopics.get(replica.topic());
            if (metadata == null || metadata.partitions.size() <= replica.partition()) {
                future.completeExceptionally((Throwable)new ReplicaNotAvailableException("Can't find " + replica));
                continue;
            }
            String currentLogDir = metadata.partitionLogDirs.get(replica.partition());
            this.replicaMoves.put(replica, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(currentLogDir, 0L, newLogDir, 0L));
            future.complete(null);
        }
        return new AlterReplicaLogDirsResult(results);
    }

    public synchronized DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        HashMap unwrappedResults = new HashMap();
        for (Integer n : brokers) {
            unwrappedResults.putIfAbsent(n, new HashMap());
        }
        for (Map.Entry entry : this.allTopics.entrySet()) {
            String topicName = (String)entry.getKey();
            TopicMetadata topicMetadata = (TopicMetadata)entry.getValue();
            List<String> partitionLogDirs = topicMetadata.partitionLogDirs;
            List<TopicPartitionInfo> topicPartitionInfos = topicMetadata.partitions;
            for (TopicPartitionInfo topicPartitionInfo : topicPartitionInfos) {
                List nodes = topicPartitionInfo.replicas();
                for (Node node : nodes) {
                    Map logDirDescriptionMap = (Map)unwrappedResults.get(node.id());
                    LogDirDescription logDirDescription = logDirDescriptionMap.getOrDefault(partitionLogDirs.get(0), new LogDirDescription(null, new HashMap()));
                    logDirDescription.replicaInfos().put(new TopicPartition(topicName, topicPartitionInfo.partition()), new ReplicaInfo(0L, 0L, false));
                }
            }
        }
        HashMap<Integer, KafkaFutureImpl> results = new HashMap<Integer, KafkaFutureImpl>();
        for (Map.Entry entry : unwrappedResults.entrySet()) {
            KafkaFutureImpl kafkaFuture = new KafkaFutureImpl();
            kafkaFuture.complete((Object)((Map)entry.getValue()));
            results.put((Integer)entry.getKey(), kafkaFuture);
        }
        return new DescribeLogDirsResult(results);
    }

    public synchronized DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        HashMap<TopicPartitionReplica, KafkaFutureImpl> results = new HashMap<TopicPartitionReplica, KafkaFutureImpl>();
        for (TopicPartitionReplica replica : replicas) {
            TopicMetadata topicMetadata = this.allTopics.get(replica.topic());
            if (topicMetadata == null) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(replica, future);
            String currentLogDir = this.currentLogDir(replica);
            if (currentLogDir == null) {
                future.complete((Object)new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(null, -1L, null, -1L));
                continue;
            }
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = this.replicaMoves.get(replica);
            if (info == null) {
                future.complete((Object)new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(currentLogDir, 0L, null, 0L));
                continue;
            }
            future.complete((Object)info);
        }
        return new DescribeReplicaLogDirsResult(results);
    }

    private synchronized String currentLogDir(TopicPartitionReplica replica) {
        TopicMetadata topicMetadata = this.allTopics.get(replica.topic());
        if (topicMetadata == null) {
            return null;
        }
        if (topicMetadata.partitionLogDirs.size() <= replica.partition()) {
            return null;
        }
        return topicMetadata.partitionLogDirs.get(replica.partition());
    }

    public synchronized AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> newReassignments, AlterPartitionReassignmentsOptions options) {
        HashMap<TopicPartition, KafkaFutureImpl> futures = new HashMap<TopicPartition, KafkaFutureImpl>();
        for (Map.Entry<TopicPartition, Optional<NewPartitionReassignment>> entry : newReassignments.entrySet()) {
            TopicPartition partition = entry.getKey();
            Optional<NewPartitionReassignment> newReassignment = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(partition, future);
            TopicMetadata topicMetadata = this.allTopics.get(partition.topic());
            if (partition.partition() < 0 || topicMetadata == null || topicMetadata.partitions.size() <= partition.partition()) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
                continue;
            }
            if (newReassignment.isPresent()) {
                this.reassignments.put(partition, newReassignment.get());
                future.complete(null);
                continue;
            }
            this.reassignments.remove(partition);
            future.complete(null);
        }
        return new AlterPartitionReassignmentsResult(futures);
    }

    public synchronized ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        HashMap<TopicPartition, PartitionReassignment> map = new HashMap<TopicPartition, PartitionReassignment>();
        for (TopicPartition partition : partitions.isPresent() ? partitions.get() : this.reassignments.keySet()) {
            PartitionReassignment reassignment = this.findPartitionReassignment(partition);
            if (reassignment == null) continue;
            map.put(partition, reassignment);
        }
        return new ListPartitionReassignmentsResult(KafkaFutureImpl.completedFuture(map));
    }

    private synchronized PartitionReassignment findPartitionReassignment(TopicPartition partition) {
        NewPartitionReassignment reassignment = this.reassignments.get(partition);
        if (reassignment == null) {
            return null;
        }
        TopicMetadata metadata = this.allTopics.get(partition.topic());
        if (metadata == null) {
            throw new RuntimeException("Internal MockAdminClient logic error: found reassignment for " + partition + ", but no TopicMetadata");
        }
        TopicPartitionInfo info = metadata.partitions.get(partition.partition());
        if (info == null) {
            throw new RuntimeException("Internal MockAdminClient logic error: found reassignment for " + partition + ", but no TopicPartitionInfo");
        }
        ArrayList<Integer> replicas = new ArrayList<Integer>();
        ArrayList<Integer> removingReplicas = new ArrayList<Integer>();
        ArrayList addingReplicas = new ArrayList(reassignment.targetReplicas());
        for (Node node : info.replicas()) {
            replicas.add(node.id());
            if (!reassignment.targetReplicas().contains(node.id())) {
                removingReplicas.add(node.id());
            }
            addingReplicas.remove((Object)node.id());
        }
        return new PartitionReassignment(replicas, addingReplicas, removingReplicas);
    }

    public synchronized AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public synchronized ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        HashMap<TopicPartition, KafkaFutureImpl> futures = new HashMap<TopicPartition, KafkaFutureImpl>();
        for (Map.Entry<TopicPartition, OffsetSpec> entry : topicPartitionOffsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            OffsetSpec spec = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (spec instanceof OffsetSpec.TimestampSpec) {
                throw new UnsupportedOperationException("Not implement yet");
            }
            if (spec instanceof OffsetSpec.EarliestSpec) {
                future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(this.beginningOffsets.get(tp).longValue(), -1L, Optional.empty()));
            } else {
                future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(this.endOffsets.get(tp).longValue(), -1L, Optional.empty()));
            }
            futures.put(tp, future);
        }
        return new ListOffsetsResult(futures);
    }

    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> users, DescribeUserScramCredentialsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(List<UserScramCredentialAlteration> alterations, AlterUserScramCredentialsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeMetadataQuorumResult describeMetadataQuorum(DescribeMetadataQuorumOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions options) {
        HashMap<String, FinalizedVersionRange> finalizedFeatures = new HashMap<String, FinalizedVersionRange>();
        HashMap<String, SupportedVersionRange> supportedFeatures = new HashMap<String, SupportedVersionRange>();
        for (Map.Entry<String, Short> entry : this.featureLevels.entrySet()) {
            finalizedFeatures.put(entry.getKey(), new FinalizedVersionRange(entry.getValue().shortValue(), entry.getValue().shortValue()));
            supportedFeatures.put(entry.getKey(), new SupportedVersionRange(this.minSupportedFeatureLevels.get(entry.getKey()).shortValue(), this.maxSupportedFeatureLevels.get(entry.getKey()).shortValue()));
        }
        return new DescribeFeaturesResult(KafkaFuture.completedFuture((Object)new FeatureMetadata(finalizedFeatures, Optional.of(123L), supportedFeatures)));
    }

    public UpdateFeaturesResult updateFeatures(Map<String, FeatureUpdate> featureUpdates, UpdateFeaturesOptions options) {
        HashMap<String, KafkaFutureImpl> results = new HashMap<String, KafkaFutureImpl>();
        for (Map.Entry<String, FeatureUpdate> entry : featureUpdates.entrySet()) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String feature = entry.getKey();
            try {
                short next = entry.getValue().maxVersionLevel();
                short min = this.minSupportedFeatureLevels.getOrDefault(feature, (short)0);
                short max = this.maxSupportedFeatureLevels.getOrDefault(feature, (short)0);
                switch (entry.getValue().upgradeType()) {
                    case UNKNOWN: {
                        throw new InvalidRequestException("Invalid upgrade type.");
                    }
                    case UPGRADE: {
                        short cur;
                        if (cur <= next) break;
                        throw new InvalidUpdateVersionException("Can't upgrade to lower version.");
                    }
                    case SAFE_DOWNGRADE: {
                        short cur;
                        if (cur >= next) break;
                        throw new InvalidUpdateVersionException("Can't downgrade to newer version.");
                    }
                    case UNSAFE_DOWNGRADE: {
                        short cur;
                        if (cur < next) {
                            throw new InvalidUpdateVersionException("Can't downgrade to newer version.");
                        }
                        for (cur = this.featureLevels.getOrDefault(feature, 0).shortValue(); next != cur; cur = (short)(cur - 1)) {
                            if (cur % 2 != 0 || entry.getValue().upgradeType() != FeatureUpdate.UpgradeType.SAFE_DOWNGRADE) continue;
                            throw new InvalidUpdateVersionException("Unable to perform a safe downgrade.");
                        }
                        break;
                    }
                }
                if (next < min) {
                    throw new InvalidUpdateVersionException("Can't downgrade below " + min);
                }
                if (next > max) {
                    throw new InvalidUpdateVersionException("Can't upgrade above " + max);
                }
                if (!options.validateOnly()) {
                    this.featureLevels.put(feature, next);
                }
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)e);
            }
            results.put(feature, future);
        }
        return new UpdateFeaturesResult(results);
    }

    public UnregisterBrokerResult unregisterBroker(int brokerId, UnregisterBrokerOptions options) {
        if (this.usingRaftController) {
            return new UnregisterBrokerResult(KafkaFuture.completedFuture(null));
        }
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException(""));
        return new UnregisterBrokerResult((KafkaFuture)future);
    }

    public DescribeProducersResult describeProducers(Collection<TopicPartition> partitions, DescribeProducersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeTransactionsResult describeTransactions(Collection<String> transactionalIds, DescribeTransactionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AbortTransactionResult abortTransaction(AbortTransactionSpec spec, AbortTransactionOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ListTransactionsResult listTransactions(ListTransactionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public FenceProducersResult fenceProducers(Collection<String> transactionalIds, FenceProducersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized void close(Duration timeout) {
    }

    public synchronized void updateBeginningOffsets(Map<TopicPartition, Long> newOffsets) {
        this.beginningOffsets.putAll(newOffsets);
    }

    public synchronized void updateEndOffsets(Map<TopicPartition, Long> newOffsets) {
        this.endOffsets.putAll(newOffsets);
    }

    public synchronized void updateConsumerGroupOffsets(Map<TopicPartition, Long> newOffsets) {
        this.committedOffsets.putAll(newOffsets);
    }

    public synchronized void throwOnListConsumerGroupOffsets(KafkaException exception) {
        this.listConsumerGroupOffsetsException = exception;
    }

    public synchronized void setMockMetrics(MetricName name, Metric metric) {
        this.mockMetrics.put(name, metric);
    }

    public synchronized Map<MetricName, ? extends Metric> metrics() {
        return this.mockMetrics;
    }

    public synchronized void setFetchesRemainingUntilVisible(String topicName, int fetchesRemainingUntilVisible) {
        TopicMetadata metadata = this.allTopics.get(topicName);
        if (metadata == null) {
            throw new RuntimeException("No such topic as " + topicName);
        }
        metadata.fetchesRemainingUntilVisible = fetchesRemainingUntilVisible;
    }

    public synchronized List<Node> brokers() {
        return new ArrayList<Node>(this.brokers);
    }

    public synchronized Node broker(int index) {
        return this.brokers.get(index);
    }

    private static final class TopicMetadata {
        final Uuid topicId;
        final boolean isInternalTopic;
        final List<TopicPartitionInfo> partitions;
        final List<String> partitionLogDirs;
        Map<String, String> configs;
        int fetchesRemainingUntilVisible;
        public boolean markedForDeletion;

        TopicMetadata(Uuid topicId, boolean isInternalTopic, List<TopicPartitionInfo> partitions, List<String> partitionLogDirs, Map<String, String> configs) {
            this.topicId = topicId;
            this.isInternalTopic = isInternalTopic;
            this.partitions = partitions;
            this.partitionLogDirs = partitionLogDirs;
            this.configs = configs != null ? configs : Collections.emptyMap();
            this.markedForDeletion = false;
            this.fetchesRemainingUntilVisible = 0;
        }
    }

    public static class Builder {
        private String clusterId = "I4ZmrWqfT2e-upky_4fdPA";
        private List<Node> brokers = new ArrayList<Node>();
        private Node controller = null;
        private List<List<String>> brokerLogDirs = new ArrayList<List<String>>();
        private Short defaultPartitions;
        private boolean usingRaftController = false;
        private Integer defaultReplicationFactor;
        private Map<String, Short> featureLevels = Collections.emptyMap();
        private Map<String, Short> minSupportedFeatureLevels = Collections.emptyMap();
        private Map<String, Short> maxSupportedFeatureLevels = Collections.emptyMap();

        public Builder() {
            this.numBrokers(1);
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder brokers(List<Node> brokers) {
            this.numBrokers(brokers.size());
            this.brokers = brokers;
            return this;
        }

        public Builder numBrokers(int numBrokers) {
            if (this.brokers.size() >= numBrokers) {
                this.brokers = this.brokers.subList(0, numBrokers);
                this.brokerLogDirs = this.brokerLogDirs.subList(0, numBrokers);
            } else {
                for (int id = this.brokers.size(); id < numBrokers; ++id) {
                    this.brokers.add(new Node(id, "localhost", 1000 + id));
                    this.brokerLogDirs.add(DEFAULT_LOG_DIRS);
                }
            }
            return this;
        }

        public Builder controller(int index) {
            this.controller = this.brokers.get(index);
            return this;
        }

        public Builder brokerLogDirs(List<List<String>> brokerLogDirs) {
            this.brokerLogDirs = brokerLogDirs;
            return this;
        }

        public Builder defaultReplicationFactor(int defaultReplicationFactor) {
            this.defaultReplicationFactor = defaultReplicationFactor;
            return this;
        }

        public Builder usingRaftController(boolean usingRaftController) {
            this.usingRaftController = usingRaftController;
            return this;
        }

        public Builder defaultPartitions(short numPartitions) {
            this.defaultPartitions = numPartitions;
            return this;
        }

        public Builder featureLevels(Map<String, Short> featureLevels) {
            this.featureLevels = featureLevels;
            return this;
        }

        public Builder minSupportedFeatureLevels(Map<String, Short> minSupportedFeatureLevels) {
            this.minSupportedFeatureLevels = minSupportedFeatureLevels;
            return this;
        }

        public Builder maxSupportedFeatureLevels(Map<String, Short> maxSupportedFeatureLevels) {
            this.maxSupportedFeatureLevels = maxSupportedFeatureLevels;
            return this;
        }

        public MockAdminClient build() {
            return new MockAdminClient(this.brokers, this.controller == null ? this.brokers.get(0) : this.controller, this.clusterId, this.defaultPartitions != null ? this.defaultPartitions : (short)1, this.defaultReplicationFactor != null ? this.defaultReplicationFactor.shortValue() : Math.min(this.brokers.size(), 3), this.brokerLogDirs, this.usingRaftController, this.featureLevels, this.minSupportedFeatureLevels, this.maxSupportedFeatureLevels);
        }
    }
}

