/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WriteTxnMarkersResponseTest {
    private static long producerIdOne = 1L;
    private static long producerIdTwo = 2L;
    private static TopicPartition tp1 = new TopicPartition("topic", 1);
    private static TopicPartition tp2 = new TopicPartition("topic", 2);
    private static Errors pidOneError = Errors.UNKNOWN_PRODUCER_ID;
    private static Errors pidTwoError = Errors.INVALID_PRODUCER_EPOCH;
    private static Map<Long, Map<TopicPartition, Errors>> errorMap;

    @Before
    public void setUp() {
        errorMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        errorMap.put(producerIdOne, Collections.singletonMap(tp1, pidOneError));
        errorMap.put(producerIdTwo, Collections.singletonMap(tp2, pidTwoError));
    }

    @Test
    public void testConstructorWithStruct() {
        HashMap<Errors, Integer> expectedErrorCounts = new HashMap<Errors, Integer>();
        expectedErrorCounts.put(Errors.UNKNOWN_PRODUCER_ID, 1);
        expectedErrorCounts.put(Errors.INVALID_PRODUCER_EPOCH, 1);
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(errorMap);
        Assert.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
        Assert.assertEquals(Collections.singletonMap(tp1, pidOneError), (Object)response.errors(producerIdOne));
        Assert.assertEquals(Collections.singletonMap(tp2, pidTwoError), (Object)response.errors(producerIdTwo));
    }
}

