/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.message.ApiMessageTypeGenerator;
import org.apache.kafka.message.JsonConverterGenerator;
import org.apache.kafka.message.MessageClassGenerator;
import org.apache.kafka.message.MessageDataGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.MetadataJsonConvertersGenerator;
import org.apache.kafka.message.MetadataRecordTypeGenerator;
import org.apache.kafka.message.TypeClassGenerator;

public final class MessageGenerator {
    static final String JSON_SUFFIX = ".json";
    static final String JSON_GLOB = "*.json";
    static final String JAVA_SUFFIX = ".java";
    static final String API_MESSAGE_TYPE_JAVA = "ApiMessageType.java";
    static final String API_SCOPE_JAVA = "ApiScope.java";
    static final String METADATA_RECORD_TYPE_JAVA = "MetadataRecordType.java";
    static final String METADATA_JSON_CONVERTERS_JAVA = "MetadataJsonConverters.java";
    static final String API_MESSAGE_CLASS = "org.apache.kafka.common.protocol.ApiMessage";
    static final String MESSAGE_CLASS = "org.apache.kafka.common.protocol.Message";
    static final String MESSAGE_UTIL_CLASS = "org.apache.kafka.common.protocol.MessageUtil";
    static final String READABLE_CLASS = "org.apache.kafka.common.protocol.Readable";
    static final String WRITABLE_CLASS = "org.apache.kafka.common.protocol.Writable";
    static final String ARRAYS_CLASS = "java.util.Arrays";
    static final String OBJECTS_CLASS = "java.util.Objects";
    static final String LIST_CLASS = "java.util.List";
    static final String ARRAYLIST_CLASS = "java.util.ArrayList";
    static final String IMPLICIT_LINKED_HASH_COLLECTION_CLASS = "org.apache.kafka.common.utils.ImplicitLinkedHashCollection";
    static final String IMPLICIT_LINKED_HASH_MULTI_COLLECTION_CLASS = "org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection";
    static final String UNSUPPORTED_VERSION_EXCEPTION_CLASS = "org.apache.kafka.common.errors.UnsupportedVersionException";
    static final String ITERATOR_CLASS = "java.util.Iterator";
    static final String ENUM_SET_CLASS = "java.util.EnumSet";
    static final String TYPE_CLASS = "org.apache.kafka.common.protocol.types.Type";
    static final String FIELD_CLASS = "org.apache.kafka.common.protocol.types.Field";
    static final String SCHEMA_CLASS = "org.apache.kafka.common.protocol.types.Schema";
    static final String ARRAYOF_CLASS = "org.apache.kafka.common.protocol.types.ArrayOf";
    static final String COMPACT_ARRAYOF_CLASS = "org.apache.kafka.common.protocol.types.CompactArrayOf";
    static final String BYTES_CLASS = "org.apache.kafka.common.utils.Bytes";
    static final String UUID_CLASS = "org.apache.kafka.common.Uuid";
    static final String BASE_RECORDS_CLASS = "org.apache.kafka.common.record.BaseRecords";
    static final String MEMORY_RECORDS_CLASS = "org.apache.kafka.common.record.MemoryRecords";
    static final String REQUEST_SUFFIX = "Request";
    static final String RESPONSE_SUFFIX = "Response";
    static final String BYTE_UTILS_CLASS = "org.apache.kafka.common.utils.ByteUtils";
    static final String STANDARD_CHARSETS = "java.nio.charset.StandardCharsets";
    static final String TAGGED_FIELDS_SECTION_CLASS = "org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection";
    static final String OBJECT_SERIALIZATION_CACHE_CLASS = "org.apache.kafka.common.protocol.ObjectSerializationCache";
    static final String MESSAGE_SIZE_ACCUMULATOR_CLASS = "org.apache.kafka.common.protocol.MessageSizeAccumulator";
    static final String RAW_TAGGED_FIELD_CLASS = "org.apache.kafka.common.protocol.types.RawTaggedField";
    static final String RAW_TAGGED_FIELD_WRITER_CLASS = "org.apache.kafka.common.protocol.types.RawTaggedFieldWriter";
    static final String TREE_MAP_CLASS = "java.util.TreeMap";
    static final String BYTE_BUFFER_CLASS = "java.nio.ByteBuffer";
    static final String NAVIGABLE_MAP_CLASS = "java.util.NavigableMap";
    static final String MAP_ENTRY_CLASS = "java.util.Map.Entry";
    static final String JSON_NODE_CLASS = "com.fasterxml.jackson.databind.JsonNode";
    static final String OBJECT_NODE_CLASS = "com.fasterxml.jackson.databind.node.ObjectNode";
    static final String JSON_NODE_FACTORY_CLASS = "com.fasterxml.jackson.databind.node.JsonNodeFactory";
    static final String BOOLEAN_NODE_CLASS = "com.fasterxml.jackson.databind.node.BooleanNode";
    static final String SHORT_NODE_CLASS = "com.fasterxml.jackson.databind.node.ShortNode";
    static final String INT_NODE_CLASS = "com.fasterxml.jackson.databind.node.IntNode";
    static final String LONG_NODE_CLASS = "com.fasterxml.jackson.databind.node.LongNode";
    static final String TEXT_NODE_CLASS = "com.fasterxml.jackson.databind.node.TextNode";
    static final String BINARY_NODE_CLASS = "com.fasterxml.jackson.databind.node.BinaryNode";
    static final String NULL_NODE_CLASS = "com.fasterxml.jackson.databind.node.NullNode";
    static final String ARRAY_NODE_CLASS = "com.fasterxml.jackson.databind.node.ArrayNode";
    static final String DOUBLE_NODE_CLASS = "com.fasterxml.jackson.databind.node.DoubleNode";
    static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    static final int UNSIGNED_SHORT_MAX = 65535;
    static final ObjectMapper JSON_SERDE = new ObjectMapper();

    private static List<TypeClassGenerator> createTypeClassGenerators(String packageName, List<String> types) {
        if (types == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeClassGenerator> generators = new ArrayList<TypeClassGenerator>();
        Iterator<String> iterator = types.iterator();
        block10: while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "ApiMessageTypeGenerator": {
                    generators.add(new ApiMessageTypeGenerator(packageName));
                    continue block10;
                }
                case "MetadataRecordTypeGenerator": {
                    generators.add(new MetadataRecordTypeGenerator(packageName));
                    continue block10;
                }
                case "MetadataJsonConvertersGenerator": {
                    generators.add(new MetadataJsonConvertersGenerator(packageName));
                    continue block10;
                }
            }
            throw new RuntimeException("Unknown type class generator type '" + type + "'");
        }
        return generators;
    }

    private static List<MessageClassGenerator> createMessageClassGenerators(String packageName, List<String> types) {
        if (types == null) {
            return Collections.emptyList();
        }
        ArrayList<MessageClassGenerator> generators = new ArrayList<MessageClassGenerator>();
        Iterator<String> iterator = types.iterator();
        block8: while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "MessageDataGenerator": {
                    generators.add(new MessageDataGenerator(packageName));
                    continue block8;
                }
                case "JsonConverterGenerator": {
                    generators.add(new JsonConverterGenerator(packageName));
                    continue block8;
                }
            }
            throw new RuntimeException("Unknown message class generator type '" + type + "'");
        }
        return generators;
    }

    /*
     * Exception decompiling
     */
    public static void processDirectories(String packageName, String outputDir, String inputDir, List<String> typeClassGeneratorTypes, List<String> messageClassGeneratorTypes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String capitalizeFirst(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    static String lowerCaseFirst(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1);
    }

    static boolean firstIsCapitalized(String string) {
        if (string.isEmpty()) {
            return false;
        }
        return Character.isUpperCase(string.charAt(0));
    }

    static String toSnakeCase(String string) {
        StringBuilder bld = new StringBuilder();
        boolean prevWasCapitalized = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!prevWasCapitalized) {
                    bld.append('_');
                }
                bld.append(Character.toLowerCase(c));
                prevWasCapitalized = true;
                continue;
            }
            bld.append(c);
            prevWasCapitalized = false;
        }
        return bld.toString();
    }

    static String stripSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        throw new RuntimeException("String " + str + " does not end with the expected suffix " + suffix);
    }

    static int sizeOfUnsignedVarint(int value) {
        int bytes = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            ++bytes;
            value >>>= 7;
        }
        return bytes;
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"message-generator").defaultHelp(true).description("The Kafka message generator");
        parser.addArgument(new String[]{"--package", "-p"}).action((ArgumentAction)Arguments.store()).required(true).metavar(new String[]{"PACKAGE"}).help("The java package to use in generated files.");
        parser.addArgument(new String[]{"--output", "-o"}).action((ArgumentAction)Arguments.store()).required(true).metavar(new String[]{"OUTPUT"}).help("The output directory to create.");
        parser.addArgument(new String[]{"--input", "-i"}).action((ArgumentAction)Arguments.store()).required(true).metavar(new String[]{"INPUT"}).help("The input directory to use.");
        parser.addArgument(new String[]{"--typeclass-generators", "-t"}).nargs("+").action((ArgumentAction)Arguments.store()).metavar(new String[]{"TYPECLASS_GENERATORS"}).help("The type class generators to use, if any.");
        parser.addArgument(new String[]{"--message-class-generators", "-m"}).nargs("+").action((ArgumentAction)Arguments.store()).metavar(new String[]{"MESSAGE_CLASS_GENERATORS"}).help("The message class generators to use.");
        Namespace res = parser.parseArgsOrFail(args);
        MessageGenerator.processDirectories(res.getString("package"), res.getString("output"), res.getString("input"), res.getList("typeclass_generators"), res.getList("message_class_generators"));
    }

    private static /* synthetic */ void lambda$processDirectories$0(MessageSpec spec, TypeClassGenerator generator) {
        generator.registerMessageType(spec);
    }

    static {
        JSON_SERDE.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_SERDE.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
        JSON_SERDE.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JSON_SERDE.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

