/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.Versions;

public final class IsNullConditional {
    private final String name;
    private Versions nullableVersions = Versions.ALL;
    private Versions possibleVersions = Versions.ALL;
    private Runnable ifNull = null;
    private Runnable ifShouldNotBeNull = null;
    private boolean alwaysEmitBlockScope = false;
    private ConditionalGenerator conditionalGenerator = PrimitiveConditionalGenerator.INSTANCE;

    static IsNullConditional forName(String name) {
        return new IsNullConditional(name);
    }

    static IsNullConditional forField(FieldSpec field) {
        IsNullConditional cond = new IsNullConditional(field.camelCaseName());
        cond.nullableVersions(field.nullableVersions());
        return cond;
    }

    private IsNullConditional(String name) {
        this.name = name;
    }

    IsNullConditional nullableVersions(Versions nullableVersions) {
        this.nullableVersions = nullableVersions;
        return this;
    }

    IsNullConditional possibleVersions(Versions possibleVersions) {
        this.possibleVersions = possibleVersions;
        return this;
    }

    IsNullConditional ifNull(Runnable ifNull) {
        this.ifNull = ifNull;
        return this;
    }

    IsNullConditional ifShouldNotBeNull(Runnable ifShouldNotBeNull) {
        this.ifShouldNotBeNull = ifShouldNotBeNull;
        return this;
    }

    IsNullConditional alwaysEmitBlockScope(boolean alwaysEmitBlockScope) {
        this.alwaysEmitBlockScope = alwaysEmitBlockScope;
        return this;
    }

    IsNullConditional conditionalGenerator(ConditionalGenerator conditionalGenerator) {
        this.conditionalGenerator = conditionalGenerator;
        return this;
    }

    void generate(CodeBuffer buffer) {
        if (this.nullableVersions.intersect(this.possibleVersions).empty()) {
            if (this.ifShouldNotBeNull != null) {
                if (this.alwaysEmitBlockScope) {
                    buffer.printf("{%n", new Object[0]);
                    buffer.incrementIndent();
                }
                this.ifShouldNotBeNull.run();
                if (this.alwaysEmitBlockScope) {
                    buffer.decrementIndent();
                    buffer.printf("}%n", new Object[0]);
                }
            }
        } else if (this.ifNull != null) {
            buffer.printf("if (%s) {%n", this.conditionalGenerator.generate(this.name, false));
            buffer.incrementIndent();
            this.ifNull.run();
            buffer.decrementIndent();
            if (this.ifShouldNotBeNull != null) {
                buffer.printf("} else {%n", new Object[0]);
                buffer.incrementIndent();
                this.ifShouldNotBeNull.run();
                buffer.decrementIndent();
            }
            buffer.printf("}%n", new Object[0]);
        } else if (this.ifShouldNotBeNull != null) {
            buffer.printf("if (%s) {%n", this.conditionalGenerator.generate(this.name, true));
            buffer.incrementIndent();
            this.ifShouldNotBeNull.run();
            buffer.decrementIndent();
            buffer.printf("}%n", new Object[0]);
        }
    }

    private static class PrimitiveConditionalGenerator
    implements ConditionalGenerator {
        static final PrimitiveConditionalGenerator INSTANCE = new PrimitiveConditionalGenerator();

        private PrimitiveConditionalGenerator() {
        }

        @Override
        public String generate(String name, boolean negated) {
            if (negated) {
                return String.format("%s != null", name);
            }
            return String.format("%s == null", name);
        }
    }

    static interface ConditionalGenerator {
        public String generate(String var1, boolean var2);
    }
}

