/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.kafka.message.CodeBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class CodeBufferTest {
    @Test
    public void testWrite() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        buffer.printf("public static void main(String[] args) throws Exception {%n", new Object[0]);
        buffer.incrementIndent();
        buffer.printf("System.out.println(\"%s\");%n", new Object[]{"hello world"});
        buffer.decrementIndent();
        buffer.printf("}%n", new Object[0]);
        StringWriter stringWriter = new StringWriter();
        buffer.write((Writer)stringWriter);
        Assertions.assertEquals((Object)stringWriter.toString(), (Object)(String.format("public static void main(String[] args) throws Exception {%n", new Object[0]) + String.format("    System.out.println(\"hello world\");%n", new Object[0]) + String.format("}%n", new Object[0])));
    }

    @Test
    public void testEquals() {
        CodeBuffer buffer1 = new CodeBuffer();
        CodeBuffer buffer2 = new CodeBuffer();
        Assertions.assertEquals((Object)buffer1, (Object)buffer2);
        buffer1.printf("hello world", new Object[0]);
        Assertions.assertNotEquals((Object)buffer1, (Object)buffer2);
        buffer2.printf("hello world", new Object[0]);
        Assertions.assertEquals((Object)buffer1, (Object)buffer2);
        buffer1.printf("foo, bar, and baz", new Object[0]);
        buffer2.printf("foo, bar, and baz", new Object[0]);
        Assertions.assertEquals((Object)buffer1, (Object)buffer2);
    }

    @Test
    public void testIndentMustBeNonNegative() {
        CodeBuffer buffer = new CodeBuffer();
        buffer.incrementIndent();
        buffer.decrementIndent();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((CodeBuffer)buffer).decrementIndent());
        Assertions.assertTrue((boolean)e.getMessage().contains("Indent < 0"));
    }
}

