/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.SetSchemaMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetSchemaMetadataTest {
    private final SetSchemaMetadata<SinkRecord> xform = new SetSchemaMetadata.Value();

    @AfterEach
    public void teardown() {
        this.xform.close();
    }

    @Test
    public void schemaNameUpdate() {
        this.xform.configure(Collections.singletonMap("schema.name", "foo"));
        SinkRecord record = new SinkRecord("", 0, null, null, SchemaBuilder.struct().build(), null, 0L);
        SinkRecord updatedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)"foo", (Object)updatedRecord.valueSchema().name());
    }

    @Test
    public void schemaVersionUpdate() {
        this.xform.configure(Collections.singletonMap("schema.version", 42));
        SinkRecord record = new SinkRecord("", 0, null, null, SchemaBuilder.struct().build(), null, 0L);
        SinkRecord updatedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Integer)42, (Integer)updatedRecord.valueSchema().version());
    }

    @Test
    public void schemaNameAndVersionUpdate() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("schema.name", "foo");
        props.put("schema.version", "42");
        this.xform.configure(props);
        SinkRecord record = new SinkRecord("", 0, null, null, SchemaBuilder.struct().build(), null, 0L);
        SinkRecord updatedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)"foo", (Object)updatedRecord.valueSchema().name());
        Assertions.assertEquals((Integer)42, (Integer)updatedRecord.valueSchema().version());
    }

    @Test
    public void schemaNameAndVersionUpdateWithStruct() {
        String fieldName1 = "f1";
        String fieldName2 = "f2";
        String fieldValue1 = "value1";
        boolean fieldValue2 = true;
        Schema schema = SchemaBuilder.struct().name("my.orig.SchemaDefn").field("f1", Schema.STRING_SCHEMA).field("f2", Schema.INT32_SCHEMA).build();
        Struct value = new Struct(schema).put("f1", (Object)"value1").put("f2", (Object)1);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("schema.name", "foo");
        props.put("schema.version", "42");
        this.xform.configure(props);
        SinkRecord record = new SinkRecord("", 0, null, null, schema, (Object)value, 0L);
        SinkRecord updatedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)"foo", (Object)updatedRecord.valueSchema().name());
        Assertions.assertEquals((Integer)42, (Integer)updatedRecord.valueSchema().version());
        this.assertMatchingSchema((Struct)updatedRecord.value(), updatedRecord.valueSchema());
    }

    @Test
    public void valueSchemaRequired() {
        SinkRecord record = new SinkRecord("", 0, null, null, null, (Object)42, 0L);
        Assertions.assertThrows(DataException.class, () -> this.xform.apply((ConnectRecord)record));
    }

    @Test
    public void ignoreRecordWithNullValue() {
        SinkRecord record = new SinkRecord("", 0, null, null, null, null, 0L);
        SinkRecord updatedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)updatedRecord.key());
        Assertions.assertNull((Object)updatedRecord.keySchema());
        Assertions.assertNull((Object)updatedRecord.value());
        Assertions.assertNull((Object)updatedRecord.valueSchema());
    }

    @Test
    public void updateSchemaOfStruct() {
        String fieldName1 = "f1";
        String fieldName2 = "f2";
        String fieldValue1 = "value1";
        boolean fieldValue2 = true;
        Schema schema = SchemaBuilder.struct().name("my.orig.SchemaDefn").field("f1", Schema.STRING_SCHEMA).field("f2", Schema.INT32_SCHEMA).build();
        Struct value = new Struct(schema).put("f1", (Object)"value1").put("f2", (Object)1);
        Schema newSchema = SchemaBuilder.struct().name("my.updated.SchemaDefn").field("f1", Schema.STRING_SCHEMA).field("f2", Schema.INT32_SCHEMA).build();
        Struct newValue = (Struct)SetSchemaMetadata.updateSchemaIn((Object)value, (Schema)newSchema);
        this.assertMatchingSchema(newValue, newSchema);
    }

    @Test
    public void updateSchemaOfNonStruct() {
        Integer value = 1;
        Object updatedValue = SetSchemaMetadata.updateSchemaIn((Object)value, (Schema)Schema.INT32_SCHEMA);
        Assertions.assertSame((Object)value, (Object)updatedValue);
    }

    @Test
    public void updateSchemaOfNull() {
        Object updatedValue = SetSchemaMetadata.updateSchemaIn(null, (Schema)Schema.INT32_SCHEMA);
        Assertions.assertNull((Object)updatedValue);
    }

    @Test
    public void testSchemaMetadataVersionRetrievedFromAppInfoParser() {
        Assertions.assertEquals((Object)AppInfoParser.getVersion(), (Object)this.xform.version());
    }

    protected void assertMatchingSchema(Struct value, Schema schema) {
        Assertions.assertSame((Object)schema, (Object)value.schema());
        Assertions.assertEquals((Object)schema.name(), (Object)value.schema().name());
        for (Field field : schema.fields()) {
            String fieldName = field.name();
            Assertions.assertEquals((Object)schema.field(fieldName).name(), (Object)value.schema().field(fieldName).name());
            Assertions.assertEquals((int)schema.field(fieldName).index(), (int)value.schema().field(fieldName).index());
            Assertions.assertSame((Object)schema.field(fieldName).schema(), (Object)value.schema().field(fieldName).schema());
        }
    }
}

